/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.reuse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.connectors.DynamicSourceUtils;
import org.apache.flink.table.planner.plan.abilities.source.ProjectPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.ReadingMetadataSpec;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpec;
import org.apache.flink.table.planner.plan.abilities.source.WatermarkPushDownSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSourceSpec;
import org.apache.flink.table.planner.plan.nodes.physical.common.CommonPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.reuse.ReplaceScanWithCalcShuttle;
import org.apache.flink.table.planner.plan.reuse.ReusableScanVisitor;
import org.apache.flink.table.planner.plan.reuse.ScanReuserUtils;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class ScanReuser {
    private static final Comparator<int[]> INT_ARRAY_COMPARATOR = (v1, v2) -> {
        int lim = Math.min(((int[])v1).length, ((int[])v2).length);
        for (int k = 0; k < lim; ++k) {
            if (v1[k] == v2[k]) continue;
            return v1[k] - v2[k];
        }
        return ((int[])v1).length - ((int[])v2).length;
    };
    private final Map<CommonPhysicalTableSourceScan, RelNode> replaceMap = new HashMap<CommonPhysicalTableSourceScan, RelNode>();
    private final FlinkContext flinkContext;
    private final FlinkTypeFactory flinkTypeFactory;

    public ScanReuser(FlinkContext flinkContext, FlinkTypeFactory flinkTypeFactory) {
        this.flinkContext = flinkContext;
        this.flinkTypeFactory = flinkTypeFactory;
    }

    public List<RelNode> reuseDuplicatedScan(List<RelNode> relNodes) {
        ReusableScanVisitor visitor = new ReusableScanVisitor();
        relNodes.forEach(visitor::go);
        for (List<CommonPhysicalTableSourceScan> reusableNodes : visitor.digestToReusableScans().values()) {
            if (reusableNodes.size() < 2 || ScanReuserUtils.reusableWithoutAdjust(reusableNodes) || reusableNodes.stream().anyMatch(ScanReuserUtils::containsRexNodeSpecAfterProjection)) continue;
            CommonPhysicalTableSourceScan pickScan = ScanReuserUtils.pickScanWithWatermark(reusableNodes);
            TableSourceTable pickTable = pickScan.tableSourceTable();
            RexBuilder rexBuilder = pickScan.getCluster().getRexBuilder();
            TreeSet<int[]> allProjectFieldSet = new TreeSet<int[]>(INT_ARRAY_COMPARATOR);
            HashSet<String> allMetaKeySet = new HashSet<String>();
            for (CommonPhysicalTableSourceScan scan : reusableNodes) {
                TableSourceTable source = scan.tableSourceTable();
                allProjectFieldSet.addAll(Arrays.asList(ScanReuserUtils.projectedFields(source)));
                allMetaKeySet.addAll(ScanReuserUtils.metadataKeys(source));
            }
            int[][] allProjectFields = (int[][])allProjectFieldSet.toArray((T[])new int[0][]);
            List<String> allMetaKeys = ScanReuserUtils.enforceMetadataKeyOrder(allMetaKeySet, pickTable.tableSource());
            List<SourceAbilitySpec> specs = ScanReuserUtils.abilitySpecsWithoutEscaped(pickTable);
            RowType originType = DynamicSourceUtils.createProducedType(pickTable.contextResolvedTable().getResolvedSchema(), pickTable.tableSource());
            ArrayList<SourceAbilitySpec> newSpecs = new ArrayList<SourceAbilitySpec>();
            RowType newSourceType = ScanReuser.applyPhysicalAndMetadataPushDown(pickTable.tableSource(), originType, newSpecs, ScanReuserUtils.concatProjectedFields(pickTable.contextResolvedTable().getResolvedSchema(), originType, allProjectFields, allMetaKeys), allProjectFields, allMetaKeys);
            specs.addAll(newSpecs);
            Optional<WatermarkPushDownSpec> watermarkSpec = ScanReuserUtils.getAdjustedWatermarkSpec(pickTable, originType, newSourceType);
            if (watermarkSpec.isPresent()) {
                specs.add(watermarkSpec.get());
                newSourceType = watermarkSpec.get().getProducedType().get();
            }
            DynamicTableSourceSpec tableSourceSpec = new DynamicTableSourceSpec(pickTable.contextResolvedTable(), specs);
            ScanTableSource newTableSource = tableSourceSpec.getScanTableSource(this.flinkContext, this.flinkTypeFactory);
            TableSourceTable newSourceTable = pickTable.replace((DynamicTableSource)newTableSource, ((FlinkTypeFactory)rexBuilder.getTypeFactory()).buildRelNodeRowType(newSourceType), specs.toArray(new SourceAbilitySpec[0]));
            RelNode newScan = pickScan.copy(newSourceTable);
            for (CommonPhysicalTableSourceScan scan : reusableNodes) {
                TableSourceTable source = scan.tableSourceTable();
                int[][] projectedFields = ScanReuserUtils.projectedFields(source);
                List<String> metaKeys = ScanReuserUtils.metadataKeys(source);
                if (Arrays.deepEquals((Object[])projectedFields, (Object[])allProjectFields) && metaKeys.equals(allMetaKeys)) {
                    this.replaceMap.put(scan, newScan);
                    continue;
                }
                RexProgramBuilder builder = new RexProgramBuilder(newScan.getRowType(), rexBuilder);
                for (int[] field : projectedFields) {
                    int index = ScanReuserUtils.indexOf(allProjectFields, field);
                    builder.addProject(index, newScan.getRowType().getFieldNames().get(index));
                }
                Object object = metaKeys.iterator();
                while (object.hasNext()) {
                    String key = (String)object.next();
                    int index = allProjectFields.length + allMetaKeys.indexOf(key);
                    builder.addProject(index, newScan.getRowType().getFieldNames().get(index));
                }
                this.replaceMap.put(scan, ScanReuserUtils.createCalcForScan(newScan, builder.getProgram()));
            }
        }
        ReplaceScanWithCalcShuttle replaceShuttle = new ReplaceScanWithCalcShuttle(this.replaceMap);
        return relNodes.stream().map(rel -> rel.accept(replaceShuttle)).collect(Collectors.toList());
    }

    private static RowType applyPhysicalAndMetadataPushDown(DynamicTableSource source, RowType originType, List<SourceAbilitySpec> sourceAbilitySpecs, int[][] physicalAndMetaFields, int[][] projectedPhysicalFields, List<String> usedMetadataNames) {
        RowType newProducedType = originType;
        boolean supportsProjectPushDown = source instanceof SupportsProjectionPushDown;
        boolean supportsReadingMeta = source instanceof SupportsReadingMetadata;
        if (supportsProjectPushDown || supportsReadingMeta) {
            newProducedType = (RowType)Projection.of((int[][])physicalAndMetaFields).project((LogicalType)originType);
        }
        if (supportsProjectPushDown) {
            sourceAbilitySpecs.add(new ProjectPushDownSpec(projectedPhysicalFields, newProducedType));
        }
        if (supportsReadingMeta) {
            sourceAbilitySpecs.add(new ReadingMetadataSpec(usedMetadataNames, newProducedType));
        }
        return newProducedType;
    }
}

