/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalDeltaJoin;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalJoin;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil;

public class StreamPhysicalDeltaJoinForceValidator {
    public static List<RelNode> validatePhysicalPlan(List<RelNode> roots, TableConfig tableConfig) {
        OptimizerConfigOptions.DeltaJoinStrategy deltaJoinStrategy = (OptimizerConfigOptions.DeltaJoinStrategy)tableConfig.get(OptimizerConfigOptions.TABLE_OPTIMIZER_DELTA_JOIN_STRATEGY);
        if (OptimizerConfigOptions.DeltaJoinStrategy.FORCE != deltaJoinStrategy) {
            return roots;
        }
        DeltaJoinFinder finder = new DeltaJoinFinder();
        roots.forEach(finder::go);
        if (!finder.regularJoinExists && !finder.deltaJoinExists) {
            return roots;
        }
        if (finder.deltaJoinExists) {
            return roots;
        }
        throw new ValidationException(String.format("The current sql doesn't support to do delta join optimization. The plan is:\n\n%s", roots.stream().map(StreamPhysicalDeltaJoinForceValidator::getPlanAsString).collect(Collectors.joining("\n"))));
    }

    private static String getPlanAsString(RelNode root) {
        return FlinkRelOptUtil.toString(root, SqlExplainLevel.DIGEST_ATTRIBUTES, false, true, false, false, false, true);
    }

    private static class DeltaJoinFinder
    extends RelVisitor {
        private boolean deltaJoinExists = false;
        private boolean regularJoinExists = false;

        private DeltaJoinFinder() {
        }

        @Override
        public void visit(RelNode node, int ordinal, @Nullable RelNode parent) {
            if (node instanceof StreamPhysicalJoin) {
                this.regularJoinExists = true;
            } else if (node instanceof StreamPhysicalDeltaJoin) {
                this.deltaJoinExists = true;
            }
            super.visit(node, ordinal, parent);
        }
    }
}

