/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.RexFactory;
import org.apache.flink.table.planner.delegation.StreamPlanner;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.nodes.calcite.LegacySink;
import org.apache.flink.table.planner.plan.nodes.calcite.Sink;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalDataStreamScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalIntermediateTableScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalLegacyTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.optimize.CommonSubGraphBasedOptimizer;
import org.apache.flink.table.planner.plan.optimize.RelNodeBlock;
import org.apache.flink.table.planner.plan.optimize.RelNodeBlockPlanBuilder$;
import org.apache.flink.table.planner.plan.optimize.StreamNonDeterministicPhysicalPlanResolver;
import org.apache.flink.table.planner.plan.optimize.StreamPhysicalDeltaJoinForceValidator;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.optimize.program.StreamOptimizeContext;
import org.apache.flink.table.planner.plan.schema.IntermediateRelTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.plan.trait.DuplicateChanges;
import org.apache.flink.table.planner.plan.trait.DuplicateChangesTrait;
import org.apache.flink.table.planner.plan.trait.DuplicateChangesTraitDef;
import org.apache.flink.table.planner.plan.trait.MiniBatchInterval;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTrait;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTrait$;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTraitDef$;
import org.apache.flink.table.planner.plan.trait.MiniBatchMode;
import org.apache.flink.table.planner.plan.trait.ModifyKindSet;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTrait;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTraitDef$;
import org.apache.flink.table.planner.plan.trait.RelModifiedMonotonicity;
import org.apache.flink.table.planner.plan.trait.RelWindowProperties;
import org.apache.flink.table.planner.plan.trait.UpdateKind;
import org.apache.flink.table.planner.plan.trait.UpdateKindTrait;
import org.apache.flink.table.planner.plan.trait.UpdateKindTraitDef$;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil$;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001\u0002\u0007\u000e\u0001qA\u0001B\u0005\u0001\u0003\u0002\u0003\u0006I!\t\u0005\u0006O\u0001!\t\u0001\u000b\u0005\u0006W\u0001!I\u0001\f\u0005\u0006\u0011\u0002!\t&\u0013\u0005\u0006+\u0002!IA\u0016\u0005\u0006E\u0002!Ia\u0019\u0005\u0006g\u0002!I\u0001\u001e\u0005\u0006u\u0002!Ia\u001f\u0005\u0006{\u0002!IA \u0005\b\u0003_\u0001A\u0011BA\u0019\u0011\u001d\tI\u0006\u0001C)\u00037\u0012!e\u0015;sK\u0006l7i\\7n_:\u001cVOY$sCBD')Y:fI>\u0003H/[7ju\u0016\u0014(B\u0001\b\u0010\u0003!y\u0007\u000f^5nSj,'B\u0001\t\u0012\u0003\u0011\u0001H.\u00198\u000b\u0005I\u0019\u0012a\u00029mC:tWM\u001d\u0006\u0003)U\tQ\u0001^1cY\u0016T!AF\f\u0002\u000b\u0019d\u0017N\\6\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001f?5\tQ\"\u0003\u0002!\u001b\ta2i\\7n_:\u001cVOY$sCBD')Y:fI>\u0003H/[7ju\u0016\u0014\bC\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0012\u0003)!W\r\\3hCRLwN\\\u0005\u0003M\r\u0012Qb\u0015;sK\u0006l\u0007\u000b\\1o]\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0002*UA\u0011a\u0004\u0001\u0005\u0006%\t\u0001\r!I\u0001\u0013_B$\u0018.\\5{KNKgn\u001b\"m_\u000e\\7\u000fF\u0002.}\u0019\u00032A\f\u001d<\u001d\tySG\u0004\u00021g5\t\u0011G\u0003\u000237\u00051AH]8pizJ\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003m]\nq\u0001]1dW\u0006<WMC\u00015\u0013\tI$HA\u0002TKFT!AN\u001c\u0011\u0005ya\u0014BA\u001f\u000e\u00051\u0011V\r\u001c(pI\u0016\u0014En\\2l\u0011\u0015y4\u00011\u0001A\u0003-!\u0018M\u00197f\u0007>tg-[4\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r\u001b\u0012aA1qS&\u0011QI\u0011\u0002\f)\u0006\u0014G.Z\"p]\u001aLw\rC\u0003H\u0007\u0001\u0007Q&\u0001\u0006tS:\\'\t\\8dWN\f!\u0002Z8PaRLW.\u001b>f)\ti#\nC\u0003L\t\u0001\u0007A*A\u0003s_>$8\u000fE\u0002/q5\u0003\"AT*\u000e\u0003=S!\u0001U)\u0002\u0007I,GN\u0003\u0002S/\u000591-\u00197dSR,\u0017B\u0001+P\u0005\u001d\u0011V\r\u001c(pI\u0016\fQb\u001c9uS6L'0\u001a\"m_\u000e\\GcA,\\;B\u0011\u0001,W\u0007\u0002o%\u0011!l\u000e\u0002\u0005+:LG\u000fC\u0003]\u000b\u0001\u00071(A\u0003cY>\u001c7\u000eC\u0003_\u000b\u0001\u0007q,A\u0006jgNKgn\u001b\"m_\u000e\\\u0007C\u0001-a\u0013\t\twGA\u0004C_>dW-\u00198\u0002\u0019=\u0004H/[7ju\u0016$&/Z3\u0015\r5#g\r\u001b9s\u0011\u0015)g\u00011\u0001N\u0003\u001d\u0011X\r\u001c(pI\u0016DQa\u001a\u0004A\u0002}\u000bA#\u001e9eCR,')\u001a4pe\u0016\u0014V-];je\u0016$\u0007\"B5\u0007\u0001\u0004Q\u0017!E7j]&\u0014\u0015\r^2i\u0013:$XM\u001d<bYB\u00111N\\\u0007\u0002Y*\u0011QnD\u0001\u0006iJ\f\u0017\u000e^\u0005\u0003_2\u0014\u0011#T5oS\n\u000bGo\u00195J]R,'O^1m\u0011\u0015\th\u00011\u0001`\u0003U\tG\u000e\\8x\tV\u0004H.[2bi\u0016\u001c\u0005.\u00198hKNDQA\u0018\u0004A\u0002}\u000bq\u0005\u001d:pa\u0006<\u0017\r^3Va\u0012\fG/Z&j]\u0012\fe\u000eZ'j]&\u0014\u0015\r^2i\u0013:$XM\u001d<bYR1q+\u001e<xqfDQ\u0001X\u0004A\u0002mBQaZ\u0004A\u0002}CQ![\u0004A\u0002)DQ!]\u0004A\u0002}CQAX\u0004A\u0002}\u000bqC]3tKRLe\u000e^3s[\u0016$\u0017.\u0019;f%\u0016\u001cX\u000f\u001c;\u0015\u0005]c\b\"\u0002/\t\u0001\u0004Y\u0014AG2sK\u0006$X-\u00138uKJlW\rZ5bi\u0016\u0014V\r\u001c+bE2,G#C@\u0002\f\u0005}\u0011\u0011EA\u0016!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003\u001f\u000511o\u00195f[\u0006LA!!\u0003\u0002\u0004\t!\u0012J\u001c;fe6,G-[1uKJ+G\u000eV1cY\u0016Dq!!\u0004\n\u0001\u0004\ty!\u0001\u0003oC6,\u0007\u0003BA\t\u00033qA!a\u0005\u0002\u0016A\u0011\u0001gN\u0005\u0004\u0003/9\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001c\u0005u!AB*ue&twMC\u0002\u0002\u0018]BQ!Z\u0005A\u00025Cq!a\t\n\u0001\u0004\t)#A\u0007n_\u0012Lg-_&j]\u0012\u001cV\r\u001e\t\u0004W\u0006\u001d\u0012bAA\u0015Y\niQj\u001c3jMf\\\u0015N\u001c3TKRDa!!\f\n\u0001\u0004y\u0016AF5t+B$\u0017\r^3CK\u001a|'/\u001a*fcVL'/\u001a3\u0002\u001b\u001d,G/\u00168jcV,7*Z=t)\u0011\t\u0019$a\u00161\t\u0005U\u0012\u0011\n\t\u0007\u0003o\t\t%!\u0012\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\tA!\u001e;jY*\u0011\u0011qH\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002D\u0005e\"aA*fiB!\u0011qIA%\u0019\u0001!1\"a\u0013\u000b\u0003\u0003\u0005\tQ!\u0001\u0002N\t\u0019q\fJ\u0019\u0012\t\u0005=\u0013Q\u000b\t\u00041\u0006E\u0013bAA*o\t9aj\u001c;iS:<\u0007CBA\u001c\u0003\u0003\ny\u0001C\u0003f\u0015\u0001\u0007Q*\u0001\u0007q_N$x\n\u001d;j[&TX\rF\u0002M\u0003;Ba!a\u0018\f\u0001\u0004a\u0015\u0001C3ya\u0006tG-\u001a3")
public class StreamCommonSubGraphBasedOptimizer
extends CommonSubGraphBasedOptimizer {
    public final StreamPlanner org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner;

    private Seq<RelNodeBlock> optimizeSinkBlocks(TableConfig tableConfig, Seq<RelNodeBlock> sinkBlocks) {
        sinkBlocks.foreach((Function1 & Serializable & scala.Serializable)sinkBlock -> {
            StreamCommonSubGraphBasedOptimizer.$anonfun$optimizeSinkBlocks$1(tableConfig, sinkBlock);
            return BoxedUnit.UNIT;
        });
        if (sinkBlocks.size() == 1) {
            RelNodeBlock block2 = (RelNodeBlock)sinkBlocks.head();
            RelNode optimizedTree = this.optimizeTree(block2.getPlan(), block2.isUpdateBeforeRequired(), block2.getMiniBatchInterval(), block2.isDuplicateChangesAllowed(), true);
            block2.setOptimizedPlan(optimizedTree);
            return sinkBlocks;
        }
        sinkBlocks.foreach((Function1 & Serializable & scala.Serializable)b -> {
            this.optimizeBlock(b, true);
            return BoxedUnit.UNIT;
        });
        sinkBlocks.foreach((Function1 & Serializable & scala.Serializable)b -> {
            this.propagateUpdateKindAndMiniBatchInterval(b, b.isUpdateBeforeRequired(), b.getMiniBatchInterval(), b.isDuplicateChangesAllowed(), true);
            return BoxedUnit.UNIT;
        });
        sinkBlocks.foreach((Function1 & Serializable & scala.Serializable)block -> {
            this.resetIntermediateResult(block);
            return BoxedUnit.UNIT;
        });
        sinkBlocks.foreach((Function1 & Serializable & scala.Serializable)b -> {
            this.optimizeBlock(b, true);
            return BoxedUnit.UNIT;
        });
        return sinkBlocks;
    }

    @Override
    public Seq<RelNodeBlock> doOptimize(Seq<RelNode> roots) {
        Seq<RelNodeBlock> seq;
        TableConfig tableConfig = this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.getTableConfig();
        Seq<RelNodeBlock> sinkBlocks = RelNodeBlockPlanBuilder$.MODULE$.buildRelNodeBlockPlan(roots, (ReadableConfig)tableConfig);
        Boolean origMiniBatchEnabled = (Boolean)tableConfig.get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED);
        try {
            Object object = Predef$.MODULE$.Boolean2boolean(origMiniBatchEnabled) ? tableConfig.set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((!FlinkRexUtil$.MODULE$.shouldSkipMiniBatch(sinkBlocks) ? 1 : 0) != 0)) : BoxedUnit.UNIT;
            seq = this.optimizeSinkBlocks(tableConfig, sinkBlocks);
        }
        finally {
            tableConfig.getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)origMiniBatchEnabled);
        }
        return seq;
    }

    private void optimizeBlock(RelNodeBlock block, boolean isSinkBlock) {
        RelNode blockLogicalPlan;
        block.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
            StreamCommonSubGraphBasedOptimizer.$anonfun$optimizeBlock$1(this, child);
            return BoxedUnit.UNIT;
        });
        RelNode relNode = blockLogicalPlan = block.getPlan();
        if (relNode instanceof LegacySink ? true : relNode instanceof Sink) {
            Predef$.MODULE$.require(isSinkBlock);
            RelNode optimizedTree = this.optimizeTree(blockLogicalPlan, block.isUpdateBeforeRequired(), block.getMiniBatchInterval(), block.isDuplicateChangesAllowed(), true);
            block.setOptimizedPlan(optimizedTree);
            return;
        }
        RelNode optimizedPlan = this.optimizeTree(relNode, block.isUpdateBeforeRequired(), block.getMiniBatchInterval(), block.isDuplicateChangesAllowed(), isSinkBlock);
        ModifyKindSetTrait modifyKindSetTrait = optimizedPlan.getTraitSet().getTrait(ModifyKindSetTraitDef$.MODULE$.INSTANCE());
        String name = this.createUniqueIntermediateRelTableName();
        IntermediateRelTable intermediateRelTable = this.createIntermediateRelTable(name, optimizedPlan, modifyKindSetTrait.modifyKindSet(), block.isUpdateBeforeRequired());
        TableScan newTableScan = this.wrapIntermediateRelTableToTableScan(intermediateRelTable, name);
        block.setNewOutputNode(newTableScan);
        block.setOutputTableName(name);
        block.setOptimizedPlan(optimizedPlan);
    }

    private RelNode optimizeTree(RelNode relNode, boolean updateBeforeRequired, MiniBatchInterval miniBatchInterval, boolean allowDuplicateChanges, boolean isSinkBlock) {
        TableConfig tableConfig = this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.getTableConfig();
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig(tableConfig);
        FlinkChainedProgram programs = (FlinkChainedProgram)calciteConfig.getStreamProgram().getOrElse((Function0 & Serializable & scala.Serializable)() -> FlinkStreamProgram$.MODULE$.buildProgram((ReadableConfig)tableConfig));
        Preconditions.checkNotNull((Object)programs);
        FlinkContext context = ShortcutUtils.unwrapContext(relNode);
        return programs.optimize(relNode, new StreamOptimizeContext(this, tableConfig, context, updateBeforeRequired, miniBatchInterval, allowDuplicateChanges, isSinkBlock){
            private final /* synthetic */ StreamCommonSubGraphBasedOptimizer $outer;
            private final TableConfig tableConfig$2;
            private final FlinkContext context$1;
            private final boolean updateBeforeRequired$1;
            private final MiniBatchInterval miniBatchInterval$1;
            private final boolean allowDuplicateChanges$1;
            private final boolean isSinkBlock$1;

            public <C> C unwrap(Class<C> clazz) {
                return (C)FlinkContext.unwrap$(this, clazz);
            }

            public boolean isBatchMode() {
                return false;
            }

            public TableConfig getTableConfig() {
                return this.tableConfig$2;
            }

            public FunctionCatalog getFunctionCatalog() {
                return this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.functionCatalog();
            }

            public CatalogManager getCatalogManager() {
                return this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.catalogManager();
            }

            public ModuleManager getModuleManager() {
                return this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.moduleManager();
            }

            public RexFactory getRexFactory() {
                return this.context$1.getRexFactory();
            }

            public FlinkRelBuilder getFlinkRelBuilder() {
                return this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.createRelBuilder();
            }

            public boolean isUpdateBeforeRequired() {
                return this.updateBeforeRequired$1;
            }

            public MiniBatchInterval getMiniBatchInterval() {
                return this.miniBatchInterval$1;
            }

            public boolean isAllowDuplicateChanges() {
                return this.allowDuplicateChanges$1;
            }

            public boolean needFinalTimeIndicatorConversion() {
                return this.isSinkBlock$1;
            }

            public ClassLoader getClassLoader() {
                return this.context$1.getClassLoader();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableConfig$2 = tableConfig$2;
                this.context$1 = context$1;
                this.updateBeforeRequired$1 = updateBeforeRequired$1;
                this.miniBatchInterval$1 = miniBatchInterval$1;
                this.allowDuplicateChanges$1 = allowDuplicateChanges$1;
                this.isSinkBlock$1 = isSinkBlock$1;
                FlinkContext.$init$(this);
            }
        });
    }

    private void propagateUpdateKindAndMiniBatchInterval(RelNodeBlock block, boolean updateBeforeRequired, MiniBatchInterval miniBatchInterval, boolean allowDuplicateChanges, boolean isSinkBlock) {
        RelNode blockLogicalPlan = block.getPlan();
        RelNode optimizedPlan = this.optimizeTree(blockLogicalPlan, updateBeforeRequired, miniBatchInterval, allowDuplicateChanges, isSinkBlock);
        StreamCommonSubGraphBasedOptimizer.propagateTraits$1(optimizedPlan, block);
        block.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
            this.propagateUpdateKindAndMiniBatchInterval(child, child.isUpdateBeforeRequired(), child.getMiniBatchInterval(), child.isDuplicateChangesAllowed(), false);
            return BoxedUnit.UNIT;
        });
    }

    private void resetIntermediateResult(RelNodeBlock block) {
        block.setNewOutputNode(null);
        block.setOutputTableName(null);
        block.setOptimizedPlan(null);
        block.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
            StreamCommonSubGraphBasedOptimizer.$anonfun$resetIntermediateResult$1(this, child);
            return BoxedUnit.UNIT;
        });
    }

    private IntermediateRelTable createIntermediateRelTable(String name, RelNode relNode, ModifyKindSet modifyKindSet, boolean isUpdateBeforeRequired) {
        Set<? extends Set<String>> uniqueKeys = this.getUniqueKeys(relNode);
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.createRelBuilder().getCluster().getMetadataQuery());
        RelModifiedMonotonicity monotonicity = fmq.getRelModifiedMonotonicity(relNode);
        RelWindowProperties windowProperties = fmq.getRelWindowProperties(relNode);
        FlinkStatistic statistic = FlinkStatistic$.MODULE$.builder().uniqueKeys(uniqueKeys).relModifiedMonotonicity(monotonicity).relWindowProperties(windowProperties).build();
        return new IntermediateRelTable(Collections.singletonList(name), relNode, modifyKindSet, isUpdateBeforeRequired, fmq.getUpsertKeys(relNode), statistic);
    }

    private Set<? extends Set<String>> getUniqueKeys(RelNode relNode) {
        RelDataType rowType = relNode.getRowType();
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.createRelBuilder().getCluster().getMetadataQuery());
        Set<ImmutableBitSet> uniqueKeys = fmq.getUniqueKeys(relNode);
        if (uniqueKeys != null) {
            return JavaConversions$.MODULE$.deprecated$u0020mutableSetAsJavaSet((scala.collection.mutable.Set)((SetLike)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(uniqueKeys).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamCommonSubGraphBasedOptimizer.$anonfun$getUniqueKeys$1(x$1)))).map((Function1 & Serializable & scala.Serializable)uniqueKey -> {
                HashSet keys = new HashSet();
                JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(uniqueKey.asList()).foreach((Function1 & Serializable & scala.Serializable)idx -> BoxesRunTime.boxToBoolean((boolean)keys.add(rowType.getFieldNames().get(Predef$.MODULE$.Integer2int(idx)))));
                return keys;
            }, Set$.MODULE$.canBuildFrom()));
        }
        return null;
    }

    @Override
    public Seq<RelNode> postOptimize(Seq<RelNode> expanded) {
        TableConfig tableConfig = this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.getTableConfig();
        List<RelNode> newRoots = StreamNonDeterministicPhysicalPlanResolver.resolvePhysicalPlan(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(expanded), tableConfig);
        return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(StreamPhysicalDeltaJoinForceValidator.validatePhysicalPlan(newRoots, tableConfig));
    }

    public static final /* synthetic */ void $anonfun$optimizeSinkBlocks$1(TableConfig tableConfig$1, RelNodeBlock sinkBlock) {
        MiniBatchInterval miniBatchInterval;
        sinkBlock.setUpdateBeforeRequired(false);
        if (Predef$.MODULE$.Boolean2boolean((Boolean)tableConfig$1.get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED))) {
            long miniBatchLatency = ((Duration)tableConfig$1.get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY)).toMillis();
            Preconditions.checkArgument((miniBatchLatency > 0L ? 1 : 0) != 0, (String)"MiniBatch Latency must be greater than 0 ms.", (Object[])new Object[]{null});
            miniBatchInterval = new MiniBatchInterval(miniBatchLatency, MiniBatchMode.ProcTime);
        } else {
            miniBatchInterval = MiniBatchIntervalTrait$.MODULE$.NONE().getMiniBatchInterval();
        }
        MiniBatchInterval miniBatchInterval2 = miniBatchInterval;
        sinkBlock.setMiniBatchInterval(miniBatchInterval2);
        sinkBlock.mergeAllowDuplicateChanges(false);
    }

    public static final /* synthetic */ void $anonfun$optimizeBlock$1(StreamCommonSubGraphBasedOptimizer $this, RelNodeBlock child) {
        if (child.getNewOutputNode().isEmpty()) {
            $this.optimizeBlock(child, false);
            return;
        }
    }

    private static final void propagateTraits$1(RelNode rel, RelNodeBlock block$1) {
        RelNode relNode = rel;
        if (relNode instanceof StreamPhysicalDataStreamScan ? true : (relNode instanceof StreamPhysicalIntermediateTableScan ? true : (relNode instanceof StreamPhysicalLegacyTableSourceScan ? true : relNode instanceof StreamPhysicalTableSourceScan))) {
            TableScan scan = (TableScan)rel;
            UpdateKindTrait updateKindTrait = scan.getTraitSet().getTrait(UpdateKindTraitDef$.MODULE$.INSTANCE());
            MiniBatchIntervalTrait miniBatchIntervalTrait = scan.getTraitSet().getTrait(MiniBatchIntervalTraitDef$.MODULE$.INSTANCE());
            DuplicateChangesTrait duplicateChangesTrait = scan.getTraitSet().getTrait(DuplicateChangesTraitDef.INSTANCE);
            String tableName = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(scan.getTable().getQualifiedName()).mkString(".");
            Seq inputBlocks = (Seq)block$1.children().filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)tableName.equals(b.getOutputTableName())));
            Preconditions.checkArgument((inputBlocks.size() <= 1 ? 1 : 0) != 0);
            if (inputBlocks.size() == 1) {
                RelNodeBlock childBlock = (RelNodeBlock)inputBlocks.head();
                childBlock.setMiniBatchInterval(miniBatchIntervalTrait.getMiniBatchInterval());
                UpdateKind updateKind = updateKindTrait.updateKind();
                UpdateKind updateKind2 = UpdateKind.BEFORE_AND_AFTER;
                boolean requireUB = !(updateKind != null ? !((Object)((Object)updateKind)).equals((Object)updateKind2) : updateKind2 != null);
                childBlock.setUpdateBeforeRequired(requireUB || childBlock.isUpdateBeforeRequired());
                boolean allowDuplicateChanges = StreamCommonSubGraphBasedOptimizer.isAllowDuplicateChanges$1(duplicateChangesTrait);
                childBlock.mergeAllowDuplicateChanges(allowDuplicateChanges);
                return;
            }
            return;
        }
        if (relNode instanceof StreamPhysicalRel) {
            StreamPhysicalRel streamPhysicalRel = (StreamPhysicalRel)relNode;
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(streamPhysicalRel.getInputs()).foreach((Function1 & Serializable & scala.Serializable)e -> {
                StreamCommonSubGraphBasedOptimizer.propagateTraits$1(e, block$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private static final boolean isAllowDuplicateChanges$1(DuplicateChangesTrait duplicateChangesTrait) {
        DuplicateChanges duplicateChanges = duplicateChangesTrait.getDuplicateChanges();
        return ((Object)((Object)DuplicateChanges.ALLOW)).equals((Object)duplicateChanges);
    }

    public static final /* synthetic */ void $anonfun$resetIntermediateResult$1(StreamCommonSubGraphBasedOptimizer $this, RelNodeBlock child) {
        if (child.getNewOutputNode().nonEmpty()) {
            $this.resetIntermediateResult(child);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getUniqueKeys$1(ImmutableBitSet x$1) {
        return JavaConversions$.MODULE$.deprecated$u0020iterableAsScalaIterable((Iterable)x$1).nonEmpty();
    }

    public StreamCommonSubGraphBasedOptimizer(StreamPlanner planner) {
        this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner = planner;
    }
}

