/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.stream;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.TableCharacteristic;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.planner.calcite.RexTableArgCall;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableFunctionScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalMLPredictTableFunctionRule;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalProcessTableFunction;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.utils.ShortcutUtils;

public class StreamPhysicalProcessTableFunctionRule
extends ConverterRule {
    public static final StreamPhysicalProcessTableFunctionRule INSTANCE = new StreamPhysicalProcessTableFunctionRule(ConverterRule.Config.INSTANCE.withConversion(FlinkLogicalTableFunctionScan.class, FlinkConventions.LOGICAL(), FlinkConventions.STREAM_PHYSICAL(), "StreamPhysicalProcessTableFunctionRule"));

    private StreamPhysicalProcessTableFunctionRule(ConverterRule.Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalTableFunctionScan scan = (FlinkLogicalTableFunctionScan)call.rel(0);
        if (scan.getInputs().isEmpty()) {
            return false;
        }
        RexCall rexCall = (RexCall)scan.getCall();
        FunctionDefinition definition = ShortcutUtils.unwrapFunctionDefinition(rexCall);
        return definition != null && !StreamPhysicalMLPredictTableFunctionRule.isMLPredictFunction(definition) && definition.getKind() == FunctionKind.PROCESS_TABLE;
    }

    @Override
    public @Nullable RelNode convert(RelNode rel) {
        FlinkLogicalTableFunctionScan scan = (FlinkLogicalTableFunctionScan)rel;
        RexCall rexCall = (RexCall)scan.getCall();
        BridgingSqlFunction.WithTableFunction function = (BridgingSqlFunction.WithTableFunction)rexCall.getOperator();
        List<RexNode> operands = rexCall.getOperands();
        List<RelNode> newInputs = StreamPhysicalProcessTableFunctionRule.applyDistributionOnInputs(function, operands, rel.getInputs());
        RelTraitSet providedTraitSet = rel.getTraitSet().replace(FlinkConventions.STREAM_PHYSICAL());
        return new StreamPhysicalProcessTableFunction(scan.getCluster(), providedTraitSet, newInputs, scan, scan.getRowType());
    }

    private static List<RelNode> applyDistributionOnInputs(BridgingSqlFunction.WithTableFunction function, List<RexNode> operands, List<RelNode> inputs) {
        return Ord.zip(operands).stream().filter(operand -> operand.e instanceof RexTableArgCall).map(tableOperand -> {
            int pos = tableOperand.i;
            RexTableArgCall tableArgCall = (RexTableArgCall)tableOperand.e;
            TableCharacteristic tableCharacteristic = function.tableCharacteristic(pos);
            assert (tableCharacteristic != null);
            return StreamPhysicalProcessTableFunctionRule.applyDistributionOnInput(tableArgCall, tableCharacteristic, (RelNode)inputs.get(tableArgCall.getInputIndex()));
        }).collect(Collectors.toList());
    }

    private static RelNode applyDistributionOnInput(RexTableArgCall tableOperand, TableCharacteristic tableCharacteristic, RelNode input) {
        FlinkRelDistribution requiredDistribution = StreamPhysicalProcessTableFunctionRule.deriveDistribution(tableOperand, tableCharacteristic);
        RelTraitSet requiredTraitSet = input.getCluster().getPlanner().emptyTraitSet().replace(requiredDistribution).replace(FlinkConventions.STREAM_PHYSICAL());
        return RelOptRule.convert(input, requiredTraitSet);
    }

    private static FlinkRelDistribution deriveDistribution(RexTableArgCall tableOperand, TableCharacteristic tableCharacteristic) {
        if (tableCharacteristic.semantics == TableCharacteristic.Semantics.SET) {
            int[] partitionKeys = tableOperand.getPartitionKeys();
            if (partitionKeys.length == 0) {
                return FlinkRelDistribution.SINGLETON();
            }
            return FlinkRelDistribution.hash(partitionKeys, true);
        }
        return FlinkRelDistribution.DEFAULT();
    }
}

