/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.hive;

import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;

public class LogicalDistribution
extends SingleRel {
    private final List<Integer> distKeys;
    private final RelCollation collation;

    private LogicalDistribution(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelCollation collation, List<Integer> distKeys) {
        super(cluster, traits, child);
        this.distKeys = distKeys;
        this.collation = collation;
    }

    public static LogicalDistribution create(RelNode input, RelCollation collation, List<Integer> distKeys) {
        RelOptCluster cluster = input.getCluster();
        collation = RelCollationTraitDef.INSTANCE.canonize(collation);
        RelTraitSet traitSet = input.getTraitSet().replace(Convention.NONE).replace(collation);
        return new LogicalDistribution(cluster, traitSet, input, collation, distKeys);
    }

    public List<Integer> getDistKeys() {
        return this.distKeys;
    }

    public RelCollation getCollation() {
        return this.collation;
    }

    @Override
    public LogicalDistribution copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new LogicalDistribution(this.getCluster(), traitSet, inputs.get(0), this.collation, this.distKeys);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        pw.item("collation", this.collation);
        pw.item("dist", this.distKeys);
        return pw;
    }
}

