/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.legacy.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.legacy.sources.TableSource;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.OperatorCodeGenerator;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecLegacyTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.utils.ScanUtil;
import org.apache.flink.table.planner.sources.TableSourceUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.operators.wmassigners.PeriodicWatermarkAssignerWrapper;
import org.apache.flink.table.runtime.operators.wmassigners.PunctuatedWatermarkAssignerWrapper;
import org.apache.flink.table.sources.wmstrategies.PeriodicWatermarkAssigner;
import org.apache.flink.table.sources.wmstrategies.PunctuatedWatermarkAssigner;
import org.apache.flink.table.sources.wmstrategies.WatermarkStrategy;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import scala.Function1;
import scala.Function2;

public class StreamExecLegacyTableSourceScan
extends CommonExecLegacyTableSourceScan
implements StreamExecNode<RowData> {
    public StreamExecLegacyTableSourceScan(ReadableConfig tableConfig, TableSource<?> tableSource, List<String> qualifiedName, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecLegacyTableSourceScan.class), ExecNodeContext.newPersistedConfig(StreamExecLegacyTableSourceScan.class, tableConfig), tableSource, qualifiedName, outputType, description);
    }

    @Override
    protected Transformation<RowData> createConversionTransformationIfNeeded(StreamExecutionEnvironment streamExecEnv, ExecNodeConfig config, ClassLoader classLoader, Transformation<?> sourceTransform, @Nullable RexNode rowtimeExpression) {
        Object transformation;
        RowType outputType = (RowType)this.getOutputType();
        int[] fieldIndexes = this.computeIndexMapping(true);
        if (this.needInternalConversion(fieldIndexes)) {
            String resetElement;
            String extractElement;
            if (ScanUtil.hasTimeAttributeField(fieldIndexes)) {
                String elementTerm = OperatorCodeGenerator.ELEMENT();
                extractElement = String.format("ctx.%s = %s;", elementTerm, elementTerm);
                resetElement = String.format("ctx.%s = null;", elementTerm);
            } else {
                extractElement = "";
                resetElement = "";
            }
            CodeGeneratorContext ctx = new CodeGeneratorContext(config, classLoader).setOperatorBaseClass(TableStreamOperator.class);
            DataType fixedProducedDataType = TableSourceUtil.fixPrecisionForProducedDataType(this.tableSource, outputType);
            transformation = ScanUtil.convertToInternalRow(ctx, sourceTransform, fieldIndexes, fixedProducedDataType, outputType, this.qualifiedName, (Function2<String, String, String>)((Function2)(detailName, simplifyName) -> this.createFormattedTransformationName((String)detailName, (String)simplifyName, config)), (Function1<String, String>)((Function1)description -> this.createFormattedTransformationDescription((String)description, config)), JavaScalaConversionUtil.toScala(Optional.ofNullable(rowtimeExpression)), extractElement, resetElement);
        } else {
            transformation = sourceTransform;
        }
        DataStream ingestedTable = new DataStream(streamExecEnv, transformation);
        Optional<RowtimeAttributeDescriptor> rowtimeDesc = JavaScalaConversionUtil.toJava(TableSourceUtil.getRowtimeAttributeDescriptor(this.tableSource, outputType));
        DataStream withWatermarks = rowtimeDesc.map(desc -> {
            int rowtimeFieldIdx = outputType.getFieldNames().indexOf(desc.getAttributeName());
            WatermarkStrategy strategy = desc.getWatermarkStrategy();
            if (strategy instanceof PeriodicWatermarkAssigner) {
                PeriodicWatermarkAssignerWrapper watermarkGenerator = new PeriodicWatermarkAssignerWrapper((PeriodicWatermarkAssigner)strategy, rowtimeFieldIdx);
                return ingestedTable.assignTimestampsAndWatermarks((org.apache.flink.api.common.eventtime.WatermarkStrategy)watermarkGenerator);
            }
            if (strategy instanceof PunctuatedWatermarkAssigner) {
                PunctuatedWatermarkAssignerWrapper watermarkGenerator = new PunctuatedWatermarkAssignerWrapper((PunctuatedWatermarkAssigner)strategy, rowtimeFieldIdx, this.tableSource.getProducedDataType());
                return ingestedTable.assignTimestampsAndWatermarks((org.apache.flink.api.common.eventtime.WatermarkStrategy)watermarkGenerator);
            }
            return ingestedTable;
        }).orElse(ingestedTable);
        return withWatermarks.getTransformation();
    }

    @Override
    protected <IN> Transformation<IN> createInput(StreamExecutionEnvironment env, InputFormat<IN, ? extends InputSplit> format, TypeInformation<IN> typeInfo) {
        return env.createInput(format, typeInfo).name(this.tableSource.explainSource()).getTransformation();
    }
}

