/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.guava33.com.google.common.collect.Lists;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.codegen.FunctionCallCodeGenerator;
import org.apache.flink.table.planner.codegen.LookupJoinCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DeltaJoinSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.DeltaJoinUtil;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.plan.utils.LookupJoinUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.collector.TableFunctionResultFuture;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.generated.GeneratedResultFuture;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.StreamingDeltaJoinOperatorFactory;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.deltajoin.AsyncDeltaJoinRunner;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExecNodeMetadata(name="stream-exec-delta-join", version=1, producedTransformations={"delta-join"}, consumedOptions={"table.exec.async-lookup.buffer-capacity", "table.exec.async-lookup.timeout"}, minPlanVersion=FlinkVersion.v2_1, minStateVersion=FlinkVersion.v2_1)
@JsonIgnoreProperties(ignoreUnknown=true)
public class StreamExecDeltaJoin
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    protected static final Logger LOG = LoggerFactory.getLogger(StreamExecDeltaJoin.class);
    public static final String DELTA_JOIN_TRANSFORMATION = "delta-join";
    private static final String FIELD_NAME_LEFT_JOIN_KEYS = "leftJoinKeys";
    private static final String FIELD_NAME_RIGHT_JOIN_KEYS = "rightJoinKeys";
    private static final String FIELD_NAME_LOOKUP_RIGHT_TABLE_JOIN_SPEC = "lookupRightTableJoinSpec";
    private static final String FIELD_NAME_LOOKUP_LEFT_TABLE_JOIN_SPEC = "lookupLeftTableJoinSpec";
    private static final String FIELD_NAME_LEFT_UPSERT_KEY = "leftUpsertKey";
    private static final String FIELD_NAME_RIGHT_UPSERT_KEY = "rightUpsertKey";
    private static final String FIELD_NAME_JOIN_TYPE = "joinType";
    public static final String FIELD_NAME_ASYNC_OPTIONS = "asyncOptions";
    @JsonProperty(value="joinType")
    private final FlinkJoinType flinkJoinType;
    @JsonProperty(value="asyncOptions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final FunctionCallUtil.AsyncOptions asyncLookupOptions;
    @JsonProperty(value="leftJoinKeys")
    private final int[] leftJoinKeys;
    @JsonProperty(value="leftUpsertKey")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private final int[] leftUpsertKeys;
    @JsonProperty(value="lookupRightTableJoinSpec")
    private final DeltaJoinSpec lookupRightTableJoinSpec;
    @JsonProperty(value="rightJoinKeys")
    private final int[] rightJoinKeys;
    @JsonProperty(value="rightUpsertKey")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private final int[] rightUpsertKeys;
    @JsonProperty(value="lookupLeftTableJoinSpec")
    private final DeltaJoinSpec lookupLeftTableJoinSpec;

    public StreamExecDeltaJoin(ReadableConfig tableConfig, FlinkJoinType flinkJoinType, int[] leftJoinKeys, @Nullable int[] leftUpsertKeys, DeltaJoinSpec lookupRightTableJoinSpec, int[] rightJoinKeys, @Nullable int[] rightUpsertKeys, DeltaJoinSpec lookupLeftTableJoinSpec, InputProperty leftInputProperty, InputProperty rightInputProperty, RowType outputType, String description, FunctionCallUtil.AsyncOptions asyncLookupOptions) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecDeltaJoin.class), ExecNodeContext.newPersistedConfig(StreamExecDeltaJoin.class, tableConfig), flinkJoinType, leftJoinKeys, leftUpsertKeys, lookupRightTableJoinSpec, rightJoinKeys, rightUpsertKeys, lookupLeftTableJoinSpec, Lists.newArrayList((Object[])new InputProperty[]{leftInputProperty, rightInputProperty}), outputType, description, asyncLookupOptions);
    }

    @JsonCreator
    public StreamExecDeltaJoin(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="joinType") FlinkJoinType flinkJoinType, @JsonProperty(value="leftJoinKeys") int[] leftJoinKeys, @JsonProperty(value="leftUpsertKey") @Nullable int[] leftUpsertKeys, @JsonProperty(value="lookupRightTableJoinSpec") DeltaJoinSpec lookupRightTableJoinSpec, @JsonProperty(value="rightJoinKeys") int[] rightJoinKeys, @JsonProperty(value="rightUpsertKey") @Nullable int[] rightUpsertKeys, @JsonProperty(value="lookupLeftTableJoinSpec") DeltaJoinSpec lookupLeftTableJoinSpec, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description, @JsonProperty(value="asyncOptions") FunctionCallUtil.AsyncOptions asyncLookupOptions) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        this.flinkJoinType = flinkJoinType;
        this.leftJoinKeys = leftJoinKeys;
        this.leftUpsertKeys = leftUpsertKeys;
        this.lookupRightTableJoinSpec = lookupRightTableJoinSpec;
        this.rightJoinKeys = rightJoinKeys;
        this.rightUpsertKeys = rightUpsertKeys;
        this.lookupLeftTableJoinSpec = lookupLeftTableJoinSpec;
        this.asyncLookupOptions = asyncLookupOptions;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        if (!DeltaJoinUtil.isJoinTypeSupported(this.flinkJoinType)) {
            throw new IllegalStateException(String.format("Unsupported join type [%s] for delta join.", this.flinkJoinType));
        }
        ExecEdge leftInputEdge = this.getInputEdges().get(0);
        ExecEdge rightInputEdge = this.getInputEdges().get(1);
        RowType leftStreamType = (RowType)leftInputEdge.getOutputType();
        RowType rightStreamType = (RowType)rightInputEdge.getOutputType();
        RelOptTable leftTemporalTable = this.lookupLeftTableJoinSpec.getLookupTable().getTemporalTable(planner.getFlinkContext(), ShortcutUtils.unwrapTypeFactory(planner));
        RelOptTable rightTemporalTable = this.lookupRightTableJoinSpec.getLookupTable().getTemporalTable(planner.getFlinkContext(), ShortcutUtils.unwrapTypeFactory(planner));
        Transformation<?> leftInputTransformation = leftInputEdge.translateToPlan(planner);
        Transformation<?> rightInputTransformation = rightInputEdge.translateToPlan(planner);
        ClassLoader classLoader = planner.getFlinkContext().getClassLoader();
        RowDataKeySelector leftJoinKeySelector = KeySelectorUtil.getRowDataSelector(classLoader, this.leftJoinKeys, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)leftStreamType));
        RowDataKeySelector leftUpsertKeySelector = this.getUpsertKeySelector(this.leftUpsertKeys, leftStreamType, classLoader);
        RowDataKeySelector rightJoinKeySelector = KeySelectorUtil.getRowDataSelector(classLoader, this.rightJoinKeys, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)rightStreamType));
        RowDataKeySelector rightUpsertKeySelector = this.getUpsertKeySelector(this.rightUpsertKeys, rightStreamType, classLoader);
        StreamOperatorFactory<RowData> operatorFactory = this.createAsyncLookupDeltaJoin(planner, config, leftTemporalTable, rightTemporalTable, this.lookupLeftTableJoinSpec.getLookupKeyMap(), this.lookupRightTableJoinSpec.getLookupKeyMap(), planner.createRelBuilder(), leftStreamType, rightStreamType, leftJoinKeySelector, leftUpsertKeySelector, rightJoinKeySelector, rightUpsertKeySelector, classLoader);
        TwoInputTransformation<?, ?, RowData> transform = ExecNodeUtil.createTwoInputTransformation(leftInputTransformation, rightInputTransformation, this.createTransformationMeta(DELTA_JOIN_TRANSFORMATION, config), operatorFactory, InternalTypeInfo.of((RowType)((RowType)this.getOutputType())), leftInputTransformation.getParallelism(), 0L, false);
        transform.setStateKeySelectors((KeySelector)leftJoinKeySelector, (KeySelector)rightJoinKeySelector);
        transform.setStateKeyType((TypeInformation)leftJoinKeySelector.getProducedType());
        return transform;
    }

    private StreamOperatorFactory<RowData> createAsyncLookupDeltaJoin(PlannerBase planner, ExecNodeConfig config, RelOptTable leftTempTable, RelOptTable rightTempTable, Map<Integer, FunctionCallUtil.FunctionParam> leftLookupKeys, Map<Integer, FunctionCallUtil.FunctionParam> rightLookupKeys, RelBuilder relBuilder, RowType leftStreamType, RowType rightStreamType, RowDataKeySelector leftJoinKeySelector, RowDataKeySelector leftUpsertKeySelector, RowDataKeySelector rightJoinKeySelector, RowDataKeySelector rightUpsertKeySelector, ClassLoader classLoader) {
        DataTypeFactory dataTypeFactory = ShortcutUtils.unwrapContext(relBuilder).getCatalogManager().getDataTypeFactory();
        AsyncDeltaJoinRunner leftLookupTableAsyncFunction = this.createAsyncDeltaJoinRunner(planner, config, classLoader, dataTypeFactory, leftTempTable, rightTempTable, leftStreamType, rightStreamType, leftLookupKeys, leftJoinKeySelector, leftUpsertKeySelector, rightJoinKeySelector, rightUpsertKeySelector, false);
        AsyncDeltaJoinRunner rightLookupTableAsyncFunction = this.createAsyncDeltaJoinRunner(planner, config, classLoader, dataTypeFactory, leftTempTable, rightTempTable, leftStreamType, rightStreamType, rightLookupKeys, leftJoinKeySelector, leftUpsertKeySelector, rightJoinKeySelector, rightUpsertKeySelector, true);
        Tuple2<Long, Long> leftRightCacheSize = this.getCacheSize(config);
        return new StreamingDeltaJoinOperatorFactory(rightLookupTableAsyncFunction, leftLookupTableAsyncFunction, leftJoinKeySelector, rightJoinKeySelector, this.asyncLookupOptions.asyncTimeout, this.asyncLookupOptions.asyncBufferCapacity, ((Long)leftRightCacheSize.f0).longValue(), ((Long)leftRightCacheSize.f1).longValue(), leftStreamType, rightStreamType);
    }

    private AsyncDeltaJoinRunner createAsyncDeltaJoinRunner(PlannerBase planner, ExecNodeConfig config, ClassLoader classLoader, DataTypeFactory dataTypeFactory, RelOptTable leftTempTable, RelOptTable rightTempTable, RowType leftStreamSideType, RowType rightStreamSideType, Map<Integer, FunctionCallUtil.FunctionParam> lookupKeys, RowDataKeySelector leftJoinKeySelector, RowDataKeySelector leftUpsertKeySelector, RowDataKeySelector rightJoinKeySelector, RowDataKeySelector rightUpsertKeySelector, boolean treatRightAsLookupTable) {
        GeneratedResultFuture<TableFunctionResultFuture<RowData>> lookupSideGeneratedResultFuture;
        RelOptTable lookupTable = treatRightAsLookupTable ? rightTempTable : leftTempTable;
        RowType streamSideType = treatRightAsLookupTable ? leftStreamSideType : rightStreamSideType;
        RowType lookupSideType = treatRightAsLookupTable ? rightStreamSideType : leftStreamSideType;
        AsyncTableFunction<?> lookupSideAsyncTableFunction = DeltaJoinUtil.getUnwrappedAsyncLookupFunction(lookupTable, lookupKeys.keySet(), classLoader);
        UserDefinedFunctionHelper.prepareInstance((ReadableConfig)config, lookupSideAsyncTableFunction);
        RowType lookupTableSourceRowType = FlinkTypeFactory.toLogicalRowType(lookupTable.getRowType());
        RowType resultRowType = (RowType)this.getOutputType();
        List<FunctionCallUtil.FunctionParam> convertedKeys = Arrays.stream(LookupJoinUtil.getOrderedLookupKeys(lookupKeys.keySet())).mapToObj(lookupKeys::get).collect(Collectors.toList());
        FunctionCallCodeGenerator.GeneratedTableFunctionWithDataType<AsyncFunction<RowData, Object>> lookupSideGeneratedFuncWithType = LookupJoinCodeGenerator.generateAsyncLookupFunction(config, classLoader, dataTypeFactory, (LogicalType)streamSideType, (LogicalType)lookupTableSourceRowType, (LogicalType)resultRowType, convertedKeys, lookupSideAsyncTableFunction, String.join((CharSequence)".", lookupTable.getQualifiedName()));
        DataStructureConverter lookupSideFetcherConverter = DataStructureConverters.getConverter((DataType)lookupSideGeneratedFuncWithType.dataType());
        if (treatRightAsLookupTable) {
            lookupSideGeneratedResultFuture = LookupJoinCodeGenerator.generateTableAsyncCollector(config, classLoader, "TableFunctionResultFuture", streamSideType, lookupTableSourceRowType, JavaScalaConversionUtil.toScala(this.lookupRightTableJoinSpec.getRemainingCondition()));
        } else {
            RexBuilder rexBuilder = new RexBuilder(planner.getTypeFactory());
            Optional<RexNode> newCond = this.lookupLeftTableJoinSpec.getRemainingCondition().map(con -> this.swapInputRefsInCondition(rexBuilder, (RexNode)con, leftStreamSideType, rightStreamSideType));
            lookupSideGeneratedResultFuture = LookupJoinCodeGenerator.generateTableAsyncCollector(config, classLoader, "TableFunctionResultFuture", streamSideType, lookupTableSourceRowType, JavaScalaConversionUtil.toScala(newCond));
        }
        GeneratedFunction<FlatMapFunction<RowData, RowData>> lookupSideGeneratedCalc = null;
        if (treatRightAsLookupTable && this.lookupRightTableJoinSpec.getProjectionOnTemporalTable().isPresent() || !treatRightAsLookupTable && this.lookupLeftTableJoinSpec.getProjectionOnTemporalTable().isPresent()) {
            List<RexNode> projectionOnTemporalTable = treatRightAsLookupTable ? this.lookupRightTableJoinSpec.getProjectionOnTemporalTable().get() : this.lookupLeftTableJoinSpec.getProjectionOnTemporalTable().get();
            RexNode filterOnTemporalTable = treatRightAsLookupTable ? (RexNode)this.lookupRightTableJoinSpec.getFilterOnTemporalTable().orElse(null) : (RexNode)this.lookupLeftTableJoinSpec.getFilterOnTemporalTable().orElse(null);
            lookupSideGeneratedCalc = LookupJoinCodeGenerator.generateCalcMapFunction((ReadableConfig)config, planner.getFlinkContext().getClassLoader(), JavaScalaConversionUtil.toScala(projectionOnTemporalTable), filterOnTemporalTable, lookupSideType, lookupTableSourceRowType);
        }
        return new AsyncDeltaJoinRunner(lookupSideGeneratedFuncWithType.tableFunc(), lookupSideFetcherConverter, lookupSideGeneratedCalc, lookupSideGeneratedResultFuture, InternalSerializers.create((RowType)lookupSideType), leftJoinKeySelector, leftUpsertKeySelector, rightJoinKeySelector, rightUpsertKeySelector, this.asyncLookupOptions.asyncBufferCapacity, treatRightAsLookupTable, this.enableCache(config));
    }

    private RexNode swapInputRefsInCondition(final RexBuilder rexBuilder, RexNode condition, RowType leftType, RowType rightType) {
        int leftFieldCount = leftType.getFieldCount();
        int rightFieldCount = rightType.getFieldCount();
        final int[] adjustments = new int[leftFieldCount + rightFieldCount];
        Arrays.fill(adjustments, 0, leftFieldCount, rightFieldCount);
        Arrays.fill(adjustments, leftFieldCount, leftFieldCount + rightFieldCount, leftFieldCount * -1);
        RexShuttle converter = new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef inputRef) {
                int srcIndex = inputRef.getIndex();
                int destIndex = srcIndex + adjustments[srcIndex];
                RelDataType type = inputRef.getType();
                return rexBuilder.makeInputRef(type, destIndex);
            }
        };
        return condition.accept(converter);
    }

    private RowDataKeySelector getUpsertKeySelector(@Nullable int[] upsertKey, RowType rowType, ClassLoader classLoader) {
        int[] rightUpsertKeys = upsertKey != null && upsertKey.length > 0 ? upsertKey : IntStream.range(0, rowType.getFields().size()).toArray();
        return KeySelectorUtil.getRowDataSelector(classLoader, rightUpsertKeys, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)rowType));
    }

    private boolean enableCache(ReadableConfig config) {
        return (Boolean)config.get(ExecutionConfigOptions.TABLE_EXEC_DELTA_JOIN_CACHE_ENABLED);
    }

    private Tuple2<Long, Long> getCacheSize(ReadableConfig config) {
        long leftCacheSize = (Long)config.get(ExecutionConfigOptions.TABLE_EXEC_DELTA_JOIN_LEFT_CACHE_SIZE);
        long rightCacheSize = (Long)config.get(ExecutionConfigOptions.TABLE_EXEC_DELTA_JOIN_RIGHT_CACHE_SIZE);
        if ((leftCacheSize <= 0L || rightCacheSize <= 0L) && this.enableCache(config)) {
            throw new IllegalArgumentException("Cache size in delta join must be positive when enabling cache.");
        }
        return Tuple2.of((Object)leftCacheSize, (Object)rightCacheSize);
    }
}

