/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.spec;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.VectorSearchTableSource;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSourceSpec;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;

@JsonIgnoreProperties(ignoreUnknown=true)
public class VectorSearchTableSourceSpec {
    public static final String FIELD_NAME_VECTOR_SEARCH_TABLE_SOURCE = "vectorSearchTableSource";
    public static final String FIELD_NAME_OUTPUT_TYPE = "outputType";
    @JsonProperty(value="vectorSearchTableSource")
    private final DynamicTableSourceSpec tableSourceSpec;
    @JsonProperty(value="outputType")
    private final RelDataType outputType;
    @JsonIgnore
    @Nullable
    private TableSourceTable searchTable;

    public VectorSearchTableSourceSpec(TableSourceTable searchTable) {
        this.searchTable = searchTable;
        this.outputType = searchTable.getRowType();
        this.tableSourceSpec = new DynamicTableSourceSpec(searchTable.contextResolvedTable(), Arrays.asList(searchTable.abilitySpecs()));
    }

    @JsonCreator
    public VectorSearchTableSourceSpec(@JsonProperty(value="vectorSearchTableSource") DynamicTableSourceSpec tableSourceSpec, @JsonProperty(value="outputType") RelDataType outputType) {
        this.tableSourceSpec = tableSourceSpec;
        this.outputType = outputType;
    }

    @JsonIgnore
    public TableSourceTable getSearchTable(FlinkContext context, FlinkTypeFactory typeFactory) {
        if (null != this.searchTable) {
            return this.searchTable;
        }
        if (null != this.tableSourceSpec && null != this.outputType) {
            VectorSearchTableSource vectorSearchTableSource = this.tableSourceSpec.getVectorSearchTableSource(context, typeFactory);
            SourceAbilitySpec[] sourceAbilitySpecs = null;
            if (null != this.tableSourceSpec.getSourceAbilities()) {
                sourceAbilitySpecs = this.tableSourceSpec.getSourceAbilities().toArray(new SourceAbilitySpec[0]);
            }
            return new TableSourceTable(null, this.outputType, FlinkStatistic.UNKNOWN(), (DynamicTableSource)vectorSearchTableSource, true, this.tableSourceSpec.getContextResolvedTable(), context, typeFactory, sourceAbilitySpecs);
        }
        throw new TableException("Can not obtain searchTable correctly!");
    }

    public DynamicTableSourceSpec getTableSourceSpec() {
        return this.tableSourceSpec;
    }

    public RelDataType getOutputType() {
        return this.outputType;
    }
}

