/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.spec;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.planner.plan.nodes.exec.spec.TemporalTableSourceSpec;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeltaJoinSpec {
    public static final String FIELD_NAME_LOOKUP_TABLE = "lookupTable";
    public static final String FIELD_NAME_LOOKUP_KEYS = "lookupKeys";
    public static final String FIELD_NAME_REMAINING_CONDITION = "remainingCondition";
    public static final String FIELD_NAME_PROJECTION_ON_TEMPORAL_TABLE = "projectionOnTemporalTable";
    public static final String FIELD_NAME_FILTER_ON_TEMPORAL_TABLE = "filterOnTemporalTable";
    @JsonProperty(value="lookupTable")
    private final TemporalTableSourceSpec lookupTable;
    @JsonProperty(value="lookupKeys")
    private final Map<Integer, FunctionCallUtil.FunctionParam> lookupKeyMap;
    @JsonProperty(value="remainingCondition")
    @Nullable
    private final RexNode remainingCondition;
    @JsonProperty(value="projectionOnTemporalTable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private final List<RexNode> projectionOnTemporalTable;
    @JsonProperty(value="filterOnTemporalTable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private final RexNode filterOnTemporalTable;

    @JsonCreator
    public DeltaJoinSpec(@JsonProperty(value="lookupTable") TemporalTableSourceSpec lookupTable, @JsonProperty(value="lookupKeys") Map<Integer, FunctionCallUtil.FunctionParam> lookupKeyMap, @JsonProperty(value="remainingCondition") @Nullable RexNode remainingCondition, @JsonProperty(value="projectionOnTemporalTable") @Nullable List<RexNode> projectionOnTemporalTable, @JsonProperty(value="filterOnTemporalTable") @Nullable RexNode filterOnTemporalTable) {
        this.lookupKeyMap = lookupKeyMap;
        this.lookupTable = lookupTable;
        this.remainingCondition = remainingCondition;
        this.projectionOnTemporalTable = projectionOnTemporalTable;
        this.filterOnTemporalTable = filterOnTemporalTable;
    }

    @JsonIgnore
    public TemporalTableSourceSpec getLookupTable() {
        return this.lookupTable;
    }

    @JsonIgnore
    public Map<Integer, FunctionCallUtil.FunctionParam> getLookupKeyMap() {
        return this.lookupKeyMap;
    }

    @JsonIgnore
    public Optional<RexNode> getRemainingCondition() {
        return Optional.ofNullable(this.remainingCondition);
    }

    @JsonIgnore
    public Optional<List<RexNode>> getProjectionOnTemporalTable() {
        return Optional.ofNullable(this.projectionOnTemporalTable);
    }

    @JsonIgnore
    public Optional<RexNode> getFilterOnTemporalTable() {
        return Optional.ofNullable(this.filterOnTemporalTable);
    }
}

