/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.api.TableException;

@Internal
final class RexWindowBoundJsonSerializer
extends StdSerializer<RexWindowBound> {
    static final String FIELD_NAME_KIND = "kind";
    static final String KIND_CURRENT_ROW = "CURRENT_ROW";
    static final String KIND_UNBOUNDED_PRECEDING = "UNBOUNDED_PRECEDING";
    static final String KIND_UNBOUNDED_FOLLOWING = "UNBOUNDED_FOLLOWING";
    static final String KIND_BOUNDED_WINDOW = "BOUNDED_WINDOW";
    static final String FIELD_NAME_IS_PRECEDING = "isPreceding";
    static final String FIELD_NAME_IS_FOLLOWING = "isFollowing";
    static final String FIELD_NAME_OFFSET = "offset";

    RexWindowBoundJsonSerializer() {
        super(RexWindowBound.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serialize(RexWindowBound rexWindowBound, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        gen.writeStartObject();
        if (rexWindowBound.isCurrentRow()) {
            gen.writeStringField(FIELD_NAME_KIND, KIND_CURRENT_ROW);
        } else if (rexWindowBound.isUnbounded()) {
            if (rexWindowBound.isPreceding()) {
                gen.writeStringField(FIELD_NAME_KIND, KIND_UNBOUNDED_PRECEDING);
            } else {
                if (!rexWindowBound.isFollowing()) throw new TableException("Unknown RexWindowBound: " + String.valueOf(rexWindowBound));
                gen.writeStringField(FIELD_NAME_KIND, KIND_UNBOUNDED_FOLLOWING);
            }
        } else {
            gen.writeStringField(FIELD_NAME_KIND, KIND_BOUNDED_WINDOW);
            if (rexWindowBound.isPreceding()) {
                gen.writeBooleanField(FIELD_NAME_IS_PRECEDING, true);
            } else {
                if (!rexWindowBound.isFollowing()) throw new TableException("Unknown RexWindowBound: " + String.valueOf(rexWindowBound));
                gen.writeBooleanField(FIELD_NAME_IS_FOLLOWING, true);
            }
            serializerProvider.defaultSerializeField(FIELD_NAME_OFFSET, (Object)rexWindowBound.getOffset(), gen);
        }
        gen.writeEndObject();
    }
}

