/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.time.Duration;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.logical.SessionGroupWindow;
import org.apache.flink.table.planner.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.planner.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.types.AtomicDataType;

@Internal
final class LogicalWindowJsonSerializer
extends StdSerializer<LogicalWindow> {
    private static final long serialVersionUID = 1L;
    static final String FIELD_NAME_KIND = "kind";
    static final String KIND_TUMBLING = "TUMBLING";
    static final String KIND_SLIDING = "SLIDING";
    static final String KIND_SESSION = "SESSION";
    static final String FIELD_NAME_ALIAS = "alias";
    static final String FIELD_NAME_TIME_FIELD = "timeField";
    static final String FIELD_NAME_FIELD_NAME = "fieldName";
    static final String FIELD_NAME_FIELD_INDEX = "fieldIndex";
    static final String FIELD_NAME_INPUT_INDEX = "inputIndex";
    static final String FIELD_NAME_FIELD_TYPE = "fieldType";
    static final String FIELD_NAME_SIZE = "size";
    static final String FIELD_NAME_IS_TIME_WINDOW = "isTimeWindow";
    static final String FIELD_NAME_SLIDE = "slide";
    static final String FIELD_NAME_GAP = "gap";

    LogicalWindowJsonSerializer() {
        super(LogicalWindow.class);
    }

    public void serialize(LogicalWindow logicalWindow, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        gen.writeStartObject();
        if (logicalWindow instanceof TumblingGroupWindow) {
            TumblingGroupWindow window = (TumblingGroupWindow)logicalWindow;
            gen.writeStringField(FIELD_NAME_KIND, KIND_TUMBLING);
            serializerProvider.defaultSerializeField(FIELD_NAME_ALIAS, (Object)window.aliasAttribute(), gen);
            FieldReferenceExpression timeField = logicalWindow.timeAttribute();
            this.serializeFieldReferenceExpression(timeField, gen, serializerProvider);
            ValueLiteralExpression size = window.size();
            if (AggregateUtil.hasTimeIntervalType(size)) {
                Duration duration = AggregateUtil.toDuration(size);
                gen.writeBooleanField(FIELD_NAME_IS_TIME_WINDOW, true);
                gen.writeObjectField(FIELD_NAME_SIZE, (Object)duration);
            } else {
                Long duration = AggregateUtil.toLong(size);
                gen.writeBooleanField(FIELD_NAME_IS_TIME_WINDOW, false);
                gen.writeNumberField(FIELD_NAME_SIZE, duration.longValue());
            }
        } else if (logicalWindow instanceof SlidingGroupWindow) {
            SlidingGroupWindow window = (SlidingGroupWindow)logicalWindow;
            gen.writeStringField(FIELD_NAME_KIND, KIND_SLIDING);
            serializerProvider.defaultSerializeField(FIELD_NAME_ALIAS, (Object)window.aliasAttribute(), gen);
            this.serializeFieldReferenceExpression(window.timeAttribute(), gen, serializerProvider);
            ValueLiteralExpression size = window.size();
            if (AggregateUtil.hasTimeIntervalType(size)) {
                Duration duration = AggregateUtil.toDuration(size);
                gen.writeBooleanField(FIELD_NAME_IS_TIME_WINDOW, true);
                gen.writeObjectField(FIELD_NAME_SIZE, (Object)duration);
                gen.writeObjectField(FIELD_NAME_SLIDE, (Object)AggregateUtil.toDuration(window.slide()));
            } else {
                Long duration = AggregateUtil.toLong(size);
                gen.writeBooleanField(FIELD_NAME_IS_TIME_WINDOW, false);
                gen.writeObjectField(FIELD_NAME_SIZE, (Object)duration);
                gen.writeObjectField(FIELD_NAME_SLIDE, (Object)AggregateUtil.toLong(window.slide()));
            }
        } else if (logicalWindow instanceof SessionGroupWindow) {
            gen.writeStringField(FIELD_NAME_KIND, KIND_SESSION);
            SessionGroupWindow window = (SessionGroupWindow)logicalWindow;
            serializerProvider.defaultSerializeField(FIELD_NAME_ALIAS, (Object)window.aliasAttribute(), gen);
            this.serializeFieldReferenceExpression(window.timeAttribute(), gen, serializerProvider);
            gen.writeObjectField(FIELD_NAME_GAP, (Object)AggregateUtil.toDuration(window.gap()));
        } else {
            throw new TableException("Unknown LogicalWindow: " + String.valueOf(logicalWindow));
        }
        gen.writeEndObject();
    }

    private void serializeFieldReferenceExpression(FieldReferenceExpression timeField, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        gen.writeObjectFieldStart(FIELD_NAME_TIME_FIELD);
        gen.writeStringField(FIELD_NAME_FIELD_NAME, timeField.getName());
        gen.writeNumberField(FIELD_NAME_FIELD_INDEX, timeField.getFieldIndex());
        gen.writeNumberField(FIELD_NAME_INPUT_INDEX, timeField.getInputIndex());
        if (!(timeField.getOutputDataType() instanceof AtomicDataType)) {
            throw new TableException("Unknown TimeField in LogicalWindow: " + String.valueOf(timeField));
        }
        serializerProvider.defaultSerializeField(FIELD_NAME_FIELD_TYPE, (Object)timeField.getOutputDataType().getLogicalType(), gen);
        gen.writeEndObject();
    }
}

