/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DatabindContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.ContextResolvedModel;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ResolvedCatalogModelJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;

@Internal
public class ContextResolvedModelJsonSerializer
extends StdSerializer<ContextResolvedModel> {
    private static final long serialVersionUID = 1L;
    public static final String FIELD_NAME_IDENTIFIER = "identifier";
    public static final String FIELD_NAME_CATALOG_MODEL = "resolvedModel";

    public ContextResolvedModelJsonSerializer() {
        super(ContextResolvedModel.class);
    }

    public void serialize(ContextResolvedModel contextResolvedModel, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        TableConfigOptions.CatalogPlanCompilation planCompilationOption = (TableConfigOptions.CatalogPlanCompilation)SerdeContext.get((DatabindContext)serializerProvider).getConfiguration().get(TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS);
        jsonGenerator.writeStartObject();
        jsonGenerator.writeObjectField(FIELD_NAME_IDENTIFIER, (Object)contextResolvedModel.getIdentifier());
        if (contextResolvedModel.isPermanent() && planCompilationOption != TableConfigOptions.CatalogPlanCompilation.IDENTIFIER) {
            try {
                jsonGenerator.writeFieldName(FIELD_NAME_CATALOG_MODEL);
                ResolvedCatalogModelJsonSerializer.serialize(contextResolvedModel.getResolvedModel(), planCompilationOption == TableConfigOptions.CatalogPlanCompilation.ALL, jsonGenerator, serializerProvider);
            }
            catch (ValidationException e) {
                throw new ValidationException(String.format("Error when trying to serialize model '%s'.", contextResolvedModel.getIdentifier()), (Throwable)e);
            }
        }
        jsonGenerator.writeEndObject();
    }
}

