/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cep.EventComparator;
import org.apache.flink.cep.functions.PatternProcessFunction;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.nfa.compiler.NFACompiler;
import org.apache.flink.cep.operator.CepOperator;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.Quantifier;
import org.apache.flink.cep.pattern.conditions.BooleanConditions;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.MatchCodeGenerator;
import org.apache.flink.table.planner.codegen.sort.ComparatorCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.MultipleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.MatchSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.plan.utils.RexDefaultVisitor;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.match.PatternProcessFunctionRunner;
import org.apache.flink.table.runtime.operators.match.RowDataEventComparator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;

public abstract class CommonExecMatch
extends ExecNodeBase<RowData>
implements ExecNode<RowData>,
MultipleTransformationTranslator<RowData> {
    public static final String MATCH_TRANSFORMATION = "match";
    public static final String FIELD_NAME_MATCH_SPEC = "matchSpec";
    public static final String TIMESTAMP_INSERTER_TRANSFORMATION = "timestamp-inserter";
    @JsonProperty(value="matchSpec")
    protected final MatchSpec matchSpec;

    public CommonExecMatch(int id, ExecNodeContext context, ReadableConfig persistedConfig, MatchSpec matchSpec, List<InputProperty> inputProperties, LogicalType outputType, String description) {
        super(id, context, persistedConfig, inputProperties, outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.matchSpec = (MatchSpec)Preconditions.checkNotNull((Object)matchSpec);
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        this.checkOrderKeys(inputRowType);
        EventComparator<RowData> eventComparator = this.createEventComparator(config, planner.getFlinkContext().getClassLoader(), inputRowType);
        Transformation<RowData> timestampedInputTransform = this.translateOrder(planner, inputTransform, inputRowType, inputEdge, config);
        Tuple2<Pattern<RowData, RowData>, List<String>> cepPatternAndNames = CommonExecMatch.translatePattern(this.matchSpec, config, planner.getFlinkContext().getClassLoader(), planner.createRelBuilder(), inputRowType);
        Pattern cepPattern = (Pattern)cepPatternAndNames.f0;
        if (NFACompiler.canProduceEmptyMatches((Pattern)cepPattern)) {
            throw new TableException("Patterns that can produce empty matches are not supported. There must be at least one non-optional state.");
        }
        if (cepPattern.getQuantifier().hasProperty(Quantifier.QuantifierProperty.GREEDY)) {
            throw new TableException("Greedy quantifiers are not allowed as the last element of a Pattern yet. Finish your pattern with either a simple variable or reluctant quantifier.");
        }
        if (this.matchSpec.isAllRows()) {
            throw new TableException("All rows per match mode is not supported yet.");
        }
        int[] partitionKeys = this.matchSpec.getPartition().getFieldIndices();
        InternalTypeInfo inputTypeInfo = (InternalTypeInfo)inputTransform.getOutputType();
        TypeSerializer inputSerializer = inputTypeInfo.createSerializer(planner.getExecEnv().getConfig().getSerializerConfig());
        NFACompiler.NFAFactory nfaFactory = NFACompiler.compileFactory((Pattern)cepPattern, (boolean)false);
        MatchCodeGenerator generator = new MatchCodeGenerator(new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader()), planner.createRelBuilder(), false, JavaScalaConversionUtil.toScala((List)cepPatternAndNames.f1), JavaScalaConversionUtil.toScala(Optional.empty()), CodeGenUtils.DEFAULT_COLLECTOR_TERM());
        generator.bindInput((LogicalType)inputRowType, CodeGenUtils.DEFAULT_INPUT1_TERM(), JavaScalaConversionUtil.toScala(Optional.empty()));
        PatternProcessFunctionRunner patternProcessFunction = generator.generateOneRowPerMatchExpression((RowType)this.getOutputType(), partitionKeys, this.matchSpec.getMeasures());
        CepOperator operator = new CepOperator(inputSerializer, this.isProcTime(inputRowType), nfaFactory, eventComparator, cepPattern.getAfterMatchSkipStrategy(), (PatternProcessFunction)patternProcessFunction, null);
        OneInputTransformation transform = ExecNodeUtil.createOneInputTransformation(timestampedInputTransform, this.createTransformationMeta(MATCH_TRANSFORMATION, config), operator, InternalTypeInfo.of((LogicalType)this.getOutputType()), timestampedInputTransform.getParallelism(), false);
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), partitionKeys, (InternalTypeInfo<RowData>)inputTypeInfo);
        transform.setStateKeySelector((KeySelector)selector);
        transform.setStateKeyType((TypeInformation)selector.getProducedType());
        transform.setChainingStrategy(ChainingStrategy.ALWAYS);
        if (this.inputsContainSingleton()) {
            transform.setParallelism(1);
            transform.setMaxParallelism(1);
        }
        return transform;
    }

    protected abstract void checkOrderKeys(RowType var1);

    private EventComparator<RowData> createEventComparator(ExecNodeConfig config, ClassLoader classLoader, RowType inputRowType) {
        SortSpec orderKeys = this.matchSpec.getOrderKeys();
        if (orderKeys.getFieldIndices().length > 1) {
            GeneratedRecordComparator rowComparator = ComparatorCodeGenerator.gen(config, classLoader, "RowDataComparator", inputRowType, orderKeys);
            return new RowDataEventComparator(rowComparator);
        }
        return null;
    }

    protected abstract Transformation<RowData> translateOrder(PlannerBase var1, Transformation<RowData> var2, RowType var3, ExecEdge var4, ExecNodeConfig var5);

    @VisibleForTesting
    public static Tuple2<Pattern<RowData, RowData>, List<String>> translatePattern(MatchSpec matchSpec, ReadableConfig config, ClassLoader classLoader, RelBuilder relBuilder, RowType inputRowType) {
        Pattern cepPattern;
        PatternVisitor patternVisitor = new PatternVisitor(config, classLoader, relBuilder, inputRowType, matchSpec);
        if (matchSpec.getInterval().isPresent()) {
            Duration interval = CommonExecMatch.translateTimeBound(matchSpec.getInterval().get());
            cepPattern = matchSpec.getPattern().accept(patternVisitor).within(interval);
        } else {
            cepPattern = matchSpec.getPattern().accept(patternVisitor);
        }
        return new Tuple2((Object)cepPattern, new ArrayList<String>(patternVisitor.names));
    }

    private static Duration translateTimeBound(RexNode interval) {
        RexLiteral l;
        if (interval instanceof RexLiteral && (l = (RexLiteral)interval).getTypeName().getFamily() == SqlTypeFamily.INTERVAL_DAY_TIME) {
            return Duration.ofMillis(l.getValueAs(Long.class));
        }
        throw new TableException("Only constant intervals with millisecond resolution are supported as time constraints of patterns.");
    }

    public boolean isProcTime(RowType inputRowType) {
        SortSpec.SortFieldSpec timeOrderField = this.matchSpec.getOrderKeys().getFieldSpec(0);
        LogicalType timeOrderFieldType = inputRowType.getTypeAt(timeOrderField.getFieldIndex());
        return TypeCheckUtils.isProcTime((LogicalType)timeOrderFieldType);
    }

    private static class PatternVisitor
    extends RexDefaultVisitor<Pattern<RowData, RowData>> {
        private final ReadableConfig config;
        private final ClassLoader classLoader;
        private final RelBuilder relBuilder;
        private final RowType inputRowType;
        private final MatchSpec matchSpec;
        private final LinkedHashSet<String> names;
        private Pattern<RowData, RowData> pattern;

        public PatternVisitor(ReadableConfig config, ClassLoader classLoader, RelBuilder relBuilder, RowType inputRowType, MatchSpec matchSpec) {
            this.config = config;
            this.classLoader = classLoader;
            this.relBuilder = relBuilder;
            this.inputRowType = inputRowType;
            this.matchSpec = matchSpec;
            this.names = new LinkedHashSet();
        }

        @Override
        public Pattern<RowData, RowData> visitLiteral(RexLiteral literal) {
            String patternName = literal.getValueAs(String.class);
            this.pattern = this.translateSingleVariable(this.pattern, patternName);
            RexNode patternDefinition = this.matchSpec.getPatternDefinitions().get(patternName);
            if (patternDefinition != null) {
                MatchCodeGenerator generator = new MatchCodeGenerator(new CodeGeneratorContext(this.config, this.classLoader), this.relBuilder, false, JavaScalaConversionUtil.toScala(new ArrayList<String>(this.names)), JavaScalaConversionUtil.toScala(Optional.of(patternName)), CodeGenUtils.DEFAULT_COLLECTOR_TERM());
                generator.bindInput((LogicalType)this.inputRowType, CodeGenUtils.DEFAULT_INPUT1_TERM(), JavaScalaConversionUtil.toScala(Optional.empty()));
                IterativeCondition<RowData> condition = generator.generateIterativeCondition(patternDefinition);
                return this.pattern.where(condition);
            }
            return this.pattern.where(BooleanConditions.trueFunction());
        }

        @Override
        public Pattern<RowData, RowData> visitCall(RexCall call) {
            SqlOperator operator = call.getOperator();
            if (operator == SqlStdOperatorTable.PATTERN_CONCAT) {
                this.pattern = ((RexNode)call.operands.get(0)).accept(this);
                this.pattern = ((RexNode)call.operands.get(1)).accept(this);
                return this.pattern;
            }
            if (operator == SqlStdOperatorTable.PATTERN_QUANTIFIER) {
                if (!(call.operands.get(0) instanceof RexLiteral)) {
                    throw new TableException(String.format("Expression not supported: %s Group patterns are not supported yet.", call.operands.get(0)));
                }
                RexLiteral name = (RexLiteral)call.operands.get(0);
                this.pattern = name.accept(this);
                int startNum = MathUtils.checkedDownCast((long)((RexLiteral)call.operands.get(1)).getValueAs(Long.class));
                int endNum = MathUtils.checkedDownCast((long)((RexLiteral)call.operands.get(2)).getValueAs(Long.class));
                boolean isGreedy = ((RexLiteral)call.operands.get(3)).getValueAs(Boolean.class) == false;
                return this.applyQuantifier(this.pattern, startNum, endNum, isGreedy);
            }
            if (operator == SqlStdOperatorTable.PATTERN_ALTER) {
                throw new TableException(String.format("Expression not supported: %s. Currently, CEP doesn't support branching patterns.", call));
            }
            if (operator == SqlStdOperatorTable.PATTERN_PERMUTE) {
                throw new TableException(String.format("Expression not supported: %s. Currently, CEP doesn't support PERMUTE patterns.", call));
            }
            if (operator == SqlStdOperatorTable.PATTERN_EXCLUDE) {
                throw new TableException(String.format("Expression not supported: %s. Currently, CEP doesn't support '{-' '-}' patterns.", call));
            }
            throw new TableException("This should not happen.");
        }

        @Override
        public Pattern<RowData, RowData> visitNode(RexNode rexNode) {
            throw new TableException(String.format("Unsupported expression within Pattern: [%s]", rexNode));
        }

        private Pattern<RowData, RowData> translateSingleVariable(Pattern<RowData, RowData> previousPattern, String patternName) {
            if (this.names.contains(patternName)) {
                throw new TableException("Pattern variables must be unique. That might change in the future.");
            }
            this.names.add(patternName);
            if (previousPattern != null) {
                return previousPattern.next(patternName);
            }
            return Pattern.begin((String)patternName, (AfterMatchSkipStrategy)this.translateSkipStrategy());
        }

        private AfterMatchSkipStrategy translateSkipStrategy() {
            switch (this.matchSpec.getAfter().getKind()) {
                case LITERAL: {
                    SqlMatchRecognize.AfterOption afterOption = ((RexLiteral)this.matchSpec.getAfter()).getValueAs(SqlMatchRecognize.AfterOption.class);
                    switch (afterOption) {
                        case SKIP_PAST_LAST_ROW: {
                            return AfterMatchSkipStrategy.skipPastLastEvent();
                        }
                        case SKIP_TO_NEXT_ROW: {
                            return AfterMatchSkipStrategy.skipToNext();
                        }
                    }
                    throw new TableException("This should not happen.");
                }
                case SKIP_TO_FIRST: {
                    return AfterMatchSkipStrategy.skipToFirst((String)this.getPatternTarget()).throwExceptionOnMiss();
                }
                case SKIP_TO_LAST: {
                    return AfterMatchSkipStrategy.skipToLast((String)this.getPatternTarget()).throwExceptionOnMiss();
                }
            }
            throw new TableException(String.format("Corrupted query tree. Unexpected %s for after match strategy.", this.matchSpec.getAfter()));
        }

        private String getPatternTarget() {
            return ((RexLiteral)((RexCall)this.matchSpec.getAfter()).getOperands().get(0)).getValueAs(String.class);
        }

        private Pattern<RowData, RowData> applyQuantifier(Pattern<RowData, RowData> pattern, int startNum, int endNum, boolean greedy) {
            boolean isOptional;
            boolean bl = isOptional = startNum == 0 && endNum == 1;
            Pattern newPattern = startNum == 0 && endNum == -1 ? pattern.oneOrMore().optional().consecutive() : (startNum == 1 && endNum == -1 ? pattern.oneOrMore().consecutive() : (isOptional ? pattern.optional() : (endNum != -1 ? pattern.times(startNum, endNum).consecutive() : pattern.timesOrMore(startNum).consecutive())));
            if (greedy && (isOptional || startNum == endNum)) {
                return newPattern;
            }
            if (greedy) {
                return newPattern.greedy();
            }
            if (isOptional) {
                throw new TableException("Reluctant optional variables are not supported yet.");
            }
            return newPattern;
        }
    }
}

