/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.abilities.sink.RowLevelDeleteSpec;
import org.apache.flink.table.planner.plan.abilities.sink.RowLevelUpdateSpec;
import org.apache.flink.table.planner.plan.abilities.sink.SinkAbilitySpec;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecSink;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSinkSpec;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@ExecNodeMetadata(name="batch-exec-sink", version=1, consumedOptions={"table.exec.sink.not-null-enforcer", "table.exec.sink.type-length-enforcer"}, producedTransformations={"constraint-validator", "partitioner", "sink"}, minPlanVersion=FlinkVersion.v2_0, minStateVersion=FlinkVersion.v2_0)
public class BatchExecSink
extends CommonExecSink
implements BatchExecNode<Object> {
    public BatchExecSink(ReadableConfig tableConfig, DynamicTableSinkSpec tableSinkSpec, InputProperty inputProperty, LogicalType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecSink.class), ExecNodeContext.newPersistedConfig(BatchExecSink.class, tableConfig), tableSinkSpec, ChangelogMode.insertOnly(), true, Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public BatchExecSink(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="dynamicTableSink") DynamicTableSinkSpec tableSinkSpec, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") LogicalType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, tableSinkSpec, ChangelogMode.insertOnly(), true, inputProperties, outputType, description);
    }

    @Override
    protected Transformation<Object> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        Transformation<?> inputTransform = this.getInputEdges().get(0).translateToPlan(planner);
        DynamicTableSink tableSink = this.tableSinkSpec.getTableSink(planner.getFlinkContext());
        return this.createSinkTransformation(planner.getExecEnv(), config, planner.getFlinkContext().getClassLoader(), inputTransform, tableSink, -1, false, null);
    }

    @Override
    protected RowType getPhysicalRowType(ResolvedSchema schema) {
        if (this.tableSinkSpec.getSinkAbilities() != null) {
            for (SinkAbilitySpec sinkAbilitySpec : this.tableSinkSpec.getSinkAbilities()) {
                if (sinkAbilitySpec instanceof RowLevelUpdateSpec) {
                    RowLevelUpdateSpec rowLevelUpdateSpec = (RowLevelUpdateSpec)sinkAbilitySpec;
                    return this.getPhysicalRowType(schema, rowLevelUpdateSpec.getRequiredPhysicalColumnIndices());
                }
                if (!(sinkAbilitySpec instanceof RowLevelDeleteSpec)) continue;
                RowLevelDeleteSpec rowLevelDeleteSpec = (RowLevelDeleteSpec)sinkAbilitySpec;
                return this.getPhysicalRowType(schema, rowLevelDeleteSpec.getRequiredPhysicalColumnIndices());
            }
        }
        return (RowType)schema.toPhysicalRowDataType().getLogicalType();
    }

    @Override
    protected Transformation<RowData> applyUpsertMaterialize(Transformation<RowData> inputTransform, int[] primaryKeys, int sinkParallelism, ExecNodeConfig config, ClassLoader classLoader, RowType physicalRowType, int[] inputUpsertKey) {
        return inputTransform;
    }

    @Override
    protected int[] getPrimaryKeyIndices(RowType sinkRowType, ResolvedSchema schema) {
        if (schema.getPrimaryKey().isPresent()) {
            UniqueConstraint uniqueConstraint = (UniqueConstraint)schema.getPrimaryKey().get();
            int[] primaryKeyIndices = new int[uniqueConstraint.getColumns().size()];
            for (int i = 0; i < uniqueConstraint.getColumns().size(); ++i) {
                int fieldIndex = sinkRowType.getFieldIndex((String)uniqueConstraint.getColumns().get(i));
                if (fieldIndex == -1) {
                    return new int[0];
                }
                primaryKeyIndices[i] = fieldIndex;
            }
            return primaryKeyIndices;
        }
        return new int[0];
    }

    private RowType getPhysicalRowType(ResolvedSchema schema, int[] columnIndices) {
        List columns = schema.getColumns();
        ArrayList<Column> requireColumns = new ArrayList<Column>();
        for (int columnIndex : columnIndices) {
            requireColumns.add((Column)columns.get(columnIndex));
        }
        return (RowType)ResolvedSchema.of(requireColumns).toPhysicalRowDataType().getLogicalType();
    }
}

