/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Arrays;
import java.util.List;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.NestedLoopJoinCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@ExecNodeMetadata(name="batch-exec-nested-loop-join", version=1, producedTransformations={"nested-loop-join"}, consumedOptions={"table.exec.resource.external-buffer-memory"}, minPlanVersion=FlinkVersion.v2_0, minStateVersion=FlinkVersion.v2_0)
public class BatchExecNestedLoopJoin
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String JOIN_TRANSFORMATION = "nested-loop-join";
    public static final String FIELD_NAME_JOIN_TYPE = "joinType";
    public static final String FIELD_NAME_LEFT_IS_BUILD = "leftIsBuild";
    public static final String FIELD_NAME_CONDITION = "condition";
    public static final String FIELD_NAME_SINGLE_ROW_JOIN = "singleRowJoin";
    @JsonProperty(value="joinType")
    private final FlinkJoinType joinType;
    @JsonProperty(value="condition")
    private final RexNode condition;
    @JsonProperty(value="leftIsBuild")
    private final boolean leftIsBuild;
    @JsonProperty(value="singleRowJoin")
    private final boolean singleRowJoin;

    public BatchExecNestedLoopJoin(ReadableConfig tableConfig, FlinkJoinType joinType, RexNode condition, boolean leftIsBuild, boolean singleRowJoin, InputProperty leftInputProperty, InputProperty rightInputProperty, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecNestedLoopJoin.class), ExecNodeContext.newPersistedConfig(BatchExecNestedLoopJoin.class, tableConfig), Arrays.asList(leftInputProperty, rightInputProperty), (LogicalType)outputType, description);
        this.joinType = (FlinkJoinType)Preconditions.checkNotNull((Object)joinType);
        this.condition = (RexNode)Preconditions.checkNotNull((Object)condition);
        this.leftIsBuild = leftIsBuild;
        this.singleRowJoin = singleRowJoin;
    }

    @JsonCreator
    public BatchExecNestedLoopJoin(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="joinType") FlinkJoinType joinType, @JsonProperty(value="condition") RexNode condition, @JsonProperty(value="leftIsBuild") boolean leftIsBuild, @JsonProperty(value="singleRowJoin") boolean singleRowJoin, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 2 ? 1 : 0) != 0);
        this.joinType = (FlinkJoinType)Preconditions.checkNotNull((Object)joinType);
        this.condition = (RexNode)Preconditions.checkNotNull((Object)condition);
        this.leftIsBuild = leftIsBuild;
        this.singleRowJoin = singleRowJoin;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge leftInputEdge = this.getInputEdges().get(0);
        ExecEdge rightInputEdge = this.getInputEdges().get(1);
        Transformation<?> leftInputTransform = leftInputEdge.translateToPlan(planner);
        Transformation<?> rightInputTransform = rightInputEdge.translateToPlan(planner);
        RowType leftType = (RowType)leftInputEdge.getOutputType();
        RowType rightType = (RowType)rightInputEdge.getOutputType();
        CodeGenOperatorFactory<RowData> operator = new NestedLoopJoinCodeGenerator(new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader()), this.singleRowJoin, this.leftIsBuild, leftType, rightType, (RowType)this.getOutputType(), this.joinType, this.condition).gen();
        int parallelism = leftInputTransform.getParallelism();
        if (this.leftIsBuild) {
            parallelism = rightInputTransform.getParallelism();
        }
        long manageMem = 0L;
        if (!this.singleRowJoin) {
            manageMem = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_EXTERNAL_BUFFER_MEMORY)).getBytes();
        }
        return ExecNodeUtil.createTwoInputTransformation(leftInputTransform, rightInputTransform, this.createTransformationMeta(JOIN_TRANSFORMATION, config), operator, InternalTypeInfo.of((LogicalType)this.getOutputType()), parallelism, manageMem, false);
    }
}

