/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.agg.batch.AggWithoutKeysCodeGenerator;
import org.apache.flink.table.planner.codegen.agg.batch.HashAggCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.fusion.OpFusionCodegenSpecGenerator;
import org.apache.flink.table.planner.plan.fusion.generator.OneInputOpFusionCodegenSpecGenerator;
import org.apache.flink.table.planner.plan.fusion.spec.HashAggFusionCodegenSpec;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedOperator;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@ExecNodeMetadata(name="batch-exec-hash-aggregate", version=1, producedTransformations={"hash-aggregate"}, consumedOptions={"table.exec.resource.hash-agg.memory", "table.exec.sort.max-num-file-handles", "table.exec.spill-compression.enabled", "table.exec.spill-compression.block-size"}, minPlanVersion=FlinkVersion.v2_0, minStateVersion=FlinkVersion.v2_0)
public class BatchExecHashAggregate
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String HASH_AGGREGATE_TRANSFORMATION = "hash-aggregate";
    public static final String FIELD_NAME_GROUPING = "grouping";
    public static final String FIELD_NAME_AUX_GROUPING = "auxGrouping";
    public static final String FIELD_NAME_AGG_CALLS = "aggCalls";
    public static final String FIELD_NAME_AGG_INPUT_ROW_TYPE = "aggInputRowType";
    public static final String FIELD_NAME_IS_MERGE = "isMerge";
    public static final String FIELD_NAME_IS_FINAL = "isFinal";
    public static final String FIELD_NAME_SUPPORT_ADAPTIVE_LOCAL_HASH_AGG = "supportAdaptiveLocalHashAgg";
    @JsonProperty(value="grouping")
    private final int[] grouping;
    @JsonProperty(value="auxGrouping")
    private final int[] auxGrouping;
    @JsonProperty(value="aggCalls")
    private final AggregateCall[] aggCalls;
    @JsonProperty(value="aggInputRowType")
    private final RowType aggInputRowType;
    @JsonProperty(value="isMerge")
    private final boolean isMerge;
    @JsonProperty(value="isFinal")
    private final boolean isFinal;
    @JsonProperty(value="supportAdaptiveLocalHashAgg")
    private final boolean supportAdaptiveLocalHashAgg;

    public BatchExecHashAggregate(ReadableConfig tableConfig, int[] grouping, int[] auxGrouping, AggregateCall[] aggCalls, RowType aggInputRowType, boolean isMerge, boolean isFinal, boolean supportAdaptiveLocalHashAgg, InputProperty inputProperty, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecHashAggregate.class), ExecNodeContext.newPersistedConfig(BatchExecHashAggregate.class, tableConfig), Collections.singletonList(inputProperty), (LogicalType)outputType, description);
        this.grouping = grouping;
        this.auxGrouping = auxGrouping;
        this.aggCalls = aggCalls;
        this.aggInputRowType = aggInputRowType;
        this.isMerge = isMerge;
        this.isFinal = isFinal;
        this.supportAdaptiveLocalHashAgg = supportAdaptiveLocalHashAgg;
    }

    @JsonCreator
    public BatchExecHashAggregate(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="grouping") int[] grouping, @JsonProperty(value="auxGrouping") int[] auxGrouping, @JsonProperty(value="aggCalls") AggregateCall[] aggCalls, @JsonProperty(value="aggInputRowType") RowType aggInputRowType, @JsonProperty(value="isMerge") boolean isMerge, @JsonProperty(value="isFinal") boolean isFinal, @JsonProperty(value="supportAdaptiveLocalHashAgg") boolean supportAdaptiveLocalHashAgg, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        this.grouping = grouping;
        this.auxGrouping = auxGrouping;
        this.aggCalls = aggCalls;
        this.aggInputRowType = aggInputRowType;
        this.isMerge = isMerge;
        this.isFinal = isFinal;
        this.supportAdaptiveLocalHashAgg = supportAdaptiveLocalHashAgg;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        GeneratedOperator<OneInputStreamOperator<RowData, RowData>> generatedOperator;
        long managedMemory;
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        RowType outputRowType = (RowType)this.getOutputType();
        CodeGeneratorContext ctx = new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader());
        AggregateInfoList aggInfos = AggregateUtil.transformToBatchAggregateInfoList(planner.getTypeFactory(), this.aggInputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), null, null);
        if (this.grouping.length == 0) {
            managedMemory = 0L;
            generatedOperator = AggWithoutKeysCodeGenerator.genWithoutKeys(ctx, planner.createRelBuilder(), aggInfos, inputRowType, outputRowType, this.isMerge, this.isFinal, "NoGrouping");
        } else {
            managedMemory = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_HASH_AGG_MEMORY)).getBytes();
            generatedOperator = HashAggCodeGenerator.genWithKeys(ctx, planner.createRelBuilder(), aggInfos, inputRowType, outputRowType, this.grouping, this.auxGrouping, this.isMerge, this.isFinal, this.supportAdaptiveLocalHashAgg, (Integer)config.get(ExecutionConfigOptions.TABLE_EXEC_SORT_MAX_NUM_FILE_HANDLES), (Boolean)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_ENABLED), (int)((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_BLOCK_SIZE)).getBytes());
        }
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(HASH_AGGREGATE_TRANSFORMATION, config), new CodeGenOperatorFactory(generatedOperator), InternalTypeInfo.of((RowType)outputRowType), inputTransform.getParallelism(), managedMemory, false);
    }

    @Override
    public boolean supportFusionCodegen() {
        return true;
    }

    @Override
    protected OpFusionCodegenSpecGenerator translateToFusionCodegenSpecInternal(PlannerBase planner, ExecNodeConfig config, CodeGeneratorContext parentCtx) {
        OpFusionCodegenSpecGenerator input = this.getInputEdges().get(0).translateToFusionCodegenSpec(planner, parentCtx);
        AggregateInfoList aggInfos = AggregateUtil.transformToBatchAggregateInfoList(planner.getTypeFactory(), this.aggInputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), null, null);
        long managedMemory = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_HASH_AGG_MEMORY)).getBytes();
        if (this.grouping.length == 0) {
            managedMemory = 0L;
        }
        OneInputOpFusionCodegenSpecGenerator hashAggSpecGenerator = new OneInputOpFusionCodegenSpecGenerator(input, managedMemory, (RowType)this.getOutputType(), new HashAggFusionCodegenSpec(new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader(), parentCtx), planner.createRelBuilder(), aggInfos, this.grouping, this.auxGrouping, this.isFinal, this.isMerge, this.supportAdaptiveLocalHashAgg, (Integer)config.get(ExecutionConfigOptions.TABLE_EXEC_SORT_MAX_NUM_FILE_HANDLES), (Boolean)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_ENABLED), (int)((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_BLOCK_SIZE)).getBytes()));
        input.addOutput(1, hashAggSpecGenerator);
        return hashAggSpecGenerator;
    }
}

