/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.sql.parser.ddl.SqlReplaceTableAs;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ReplaceTableAsOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.operations.SqlNodeToOperationConversion;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.operations.converters.table.AbstractCreateTableConverter;
import org.apache.flink.table.planner.operations.converters.table.MergeTableAsUtil;

public class SqlReplaceTableAsConverter
extends AbstractCreateTableConverter<SqlReplaceTableAs> {
    @Override
    public Operation convertSqlNode(SqlReplaceTableAs sqlReplaceTableAs, SqlNodeConverter.ConvertContext context) {
        CatalogManager catalogManager = context.getCatalogManager();
        FlinkPlannerImpl flinkPlanner = context.getFlinkPlanner();
        PlannerQueryOperation query = (PlannerQueryOperation)SqlNodeToOperationConversion.convert(flinkPlanner, catalogManager, sqlReplaceTableAs.getAsQuery()).orElseThrow(() -> new TableException("RTAS unsupported node type " + sqlReplaceTableAs.getAsQuery().getClass().getSimpleName()));
        ResolvedCatalogTable tableWithResolvedSchema = this.getResolvedCatalogTable(sqlReplaceTableAs, context, query.getResolvedSchema());
        query = new MergeTableAsUtil(context).maybeRewriteQuery(context.getCatalogManager(), flinkPlanner, query, sqlReplaceTableAs.getAsQuery(), tableWithResolvedSchema);
        ObjectIdentifier identifier = this.getIdentifier(sqlReplaceTableAs, context);
        CreateTableOperation createTableOperation = this.getCreateTableOperation(identifier, tableWithResolvedSchema, sqlReplaceTableAs);
        return new ReplaceTableAsOperation(createTableOperation, (QueryOperation)query, sqlReplaceTableAs.isCreateOrReplace());
    }

    @Override
    protected AbstractCreateTableConverter.MergeContext getMergeContext(final SqlReplaceTableAs sqlReplaceTableAs, final SqlNodeConverter.ConvertContext context) {
        return new AbstractCreateTableConverter.MergeContext(){
            private final MergeTableAsUtil mergeTableAsUtil;
            {
                this.mergeTableAsUtil = new MergeTableAsUtil(context);
            }

            @Override
            public Schema getMergedSchema(ResolvedSchema querySchema) {
                if (sqlReplaceTableAs.isSchemaWithColumnsIdentifiersOnly()) {
                    return this.mergeTableAsUtil.reorderSchema(sqlReplaceTableAs.getColumnList(), querySchema);
                }
                return this.mergeTableAsUtil.mergeSchemas(sqlReplaceTableAs.getColumnList(), sqlReplaceTableAs.getWatermark().orElse(null), sqlReplaceTableAs.getFullConstraints(), querySchema);
            }

            @Override
            public Map<String, String> getMergedTableOptions() {
                return SqlReplaceTableAsConverter.this.getDerivedTableOptions(sqlReplaceTableAs);
            }

            @Override
            public List<String> getMergedPartitionKeys() {
                return SqlReplaceTableAsConverter.this.getDerivedPartitionKeys(sqlReplaceTableAs);
            }

            @Override
            public Optional<TableDistribution> getMergedTableDistribution() {
                return SqlReplaceTableAsConverter.this.getDerivedTableDistribution(sqlReplaceTableAs);
            }
        };
    }
}

