/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.sql.parser.ddl.SqlCreateTableLike;
import org.apache.flink.sql.parser.ddl.SqlTableLike;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.operations.converters.table.AbstractCreateTableConverter;
import org.apache.flink.table.planner.operations.converters.table.MergeTableLikeUtil;
import org.apache.flink.table.planner.utils.OperationConverterUtils;

public class SqlCreateTableLikeConverter
extends AbstractCreateTableConverter<SqlCreateTableLike> {
    @Override
    public Operation convertSqlNode(SqlCreateTableLike sqlCreateTableLike, SqlNodeConverter.ConvertContext context) {
        ResolvedCatalogTable catalogTable = this.getResolvedCatalogTable(sqlCreateTableLike, context, null);
        ObjectIdentifier identifier = this.getIdentifier(sqlCreateTableLike, context);
        return this.getCreateTableOperation(identifier, catalogTable, sqlCreateTableLike);
    }

    private CatalogTable lookupLikeSourceTable(SqlTableLike sqlTableLike, CatalogManager catalogManager) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of(sqlTableLike.getSourceTable().names);
        ObjectIdentifier identifier = catalogManager.qualifyIdentifier(unresolvedIdentifier);
        ContextResolvedTable lookupResult = (ContextResolvedTable)catalogManager.getTable(identifier).orElseThrow(() -> new ValidationException(String.format("Source table '%s' of the LIKE clause not found in the catalog, at %s", identifier, sqlTableLike.getSourceTable().getParserPosition())));
        if (!(lookupResult.getResolvedTable() instanceof CatalogTable)) {
            throw new ValidationException(String.format("Source table '%s' of the LIKE clause can not be a VIEW, at %s", identifier, sqlTableLike.getSourceTable().getParserPosition()));
        }
        return (CatalogTable)lookupResult.getResolvedTable();
    }

    @Override
    protected AbstractCreateTableConverter.MergeContext getMergeContext(final SqlCreateTableLike sqlCreateTableLike, final SqlNodeConverter.ConvertContext context) {
        return new AbstractCreateTableConverter.MergeContext(){
            private final MergeTableLikeUtil mergeTableLikeUtil;
            private final SqlTableLike sqlTableLike;
            private final CatalogTable table;
            private final Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies;
            {
                this.mergeTableLikeUtil = new MergeTableLikeUtil(context);
                this.sqlTableLike = sqlCreateTableLike.getTableLike();
                this.table = SqlCreateTableLikeConverter.this.lookupLikeSourceTable(this.sqlTableLike, context.getCatalogManager());
                this.mergingStrategies = this.mergeTableLikeUtil.computeMergingStrategies(this.sqlTableLike.getOptions());
            }

            @Override
            public Schema getMergedSchema(ResolvedSchema schemaToMerge) {
                Optional<SqlTableConstraint> tableConstraint = sqlCreateTableLike.getFullConstraints().stream().filter(SqlTableConstraint::isPrimaryKey).findAny();
                return this.mergeTableLikeUtil.mergeTables(this.mergingStrategies, this.table.getUnresolvedSchema(), sqlCreateTableLike.getColumnList().getList(), sqlCreateTableLike.getWatermark().map(Collections::singletonList).orElseGet(Collections::emptyList), tableConstraint.orElse(null));
            }

            @Override
            public Map<String, String> getMergedTableOptions() {
                Map<String, String> derivedTableOptions = OperationConverterUtils.getProperties(sqlCreateTableLike.getPropertyList());
                return this.mergeTableLikeUtil.mergeOptions(this.mergingStrategies.get((Object)SqlTableLike.FeatureOption.OPTIONS), this.table.getOptions(), derivedTableOptions);
            }

            @Override
            public List<String> getMergedPartitionKeys() {
                return this.mergeTableLikeUtil.mergePartitions(this.mergingStrategies.get((Object)SqlTableLike.FeatureOption.PARTITIONS), this.table.getPartitionKeys(), SqlCreateTableLikeConverter.this.getDerivedPartitionKeys(sqlCreateTableLike));
            }

            @Override
            public Optional<TableDistribution> getMergedTableDistribution() {
                return this.mergeTableLikeUtil.mergeDistribution(this.mergingStrategies.get((Object)SqlTableLike.FeatureOption.DISTRIBUTION), this.table.getDistribution(), SqlCreateTableLikeConverter.this.getDerivedTableDistribution(sqlCreateTableLike));
            }
        };
    }
}

