/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import org.apache.flink.sql.parser.ddl.SqlAlterTableRename;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.AlterTableRenameOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.operations.converters.table.AbstractAlterTableConverter;

public class SqlAlterTableRenameConverter
extends AbstractAlterTableConverter<SqlAlterTableRename> {
    @Override
    protected Operation convertToOperation(SqlAlterTableRename sqlAlterTable, ResolvedCatalogTable oldTable, SqlNodeConverter.ConvertContext context) {
        ObjectIdentifier tableIdentifier = this.getIdentifier(sqlAlterTable, context);
        UnresolvedIdentifier newUnresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlAlterTable.fullNewTableName());
        ObjectIdentifier newTableIdentifier = context.getCatalogManager().qualifyIdentifier(newUnresolvedIdentifier);
        return new AlterTableRenameOperation(tableIdentifier, newTableIdentifier, sqlAlterTable.ifTableExists());
    }
}

