/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.position.SqlTableColumnPosition;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.planner.operations.converters.SchemaConverter;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.types.DataType;

public class SchemaModifyConverter
extends SchemaConverter {
    private final ResolvedCatalogTable oldTable;

    public SchemaModifyConverter(ResolvedCatalogTable oldTable, SqlNodeConverter.ConvertContext context) {
        super(oldTable, context);
        this.oldTable = oldTable;
    }

    @Override
    protected void updatePositionAndCollectColumnChange(SqlTableColumnPosition columnPosition, String columnName) {
        if (!this.sortedColumnNames.contains(columnName)) {
            throw new ValidationException(String.format("%sTry to modify a column `%s` which does not exist in the table.", "Failed to execute ALTER TABLE statement.\n", columnName));
        }
        Column oldColumn = (Column)this.unwrap(this.oldTable.getResolvedSchema().getColumn(columnName));
        if (columnPosition.isFirstColumn()) {
            this.sortedColumnNames.remove(columnName);
            this.sortedColumnNames.add(0, columnName);
            this.changeBuilders.add(schema -> SchemaModifyConverter.buildModifyColumnChange(oldColumn, (Column)this.unwrap(schema.getColumn(columnName)), TableChange.ColumnPosition.first()));
        } else if (columnPosition.isAfterReferencedColumn()) {
            String referenceName = this.getReferencedColumn(columnPosition);
            this.sortedColumnNames.remove(columnName);
            this.sortedColumnNames.add(this.sortedColumnNames.indexOf(referenceName) + 1, columnName);
            this.changeBuilders.add(schema -> SchemaModifyConverter.buildModifyColumnChange(oldColumn, (Column)this.unwrap(schema.getColumn(columnName)), TableChange.ColumnPosition.after((String)referenceName)));
        } else {
            this.changeBuilders.add(schema -> SchemaModifyConverter.buildModifyColumnChange(oldColumn, (Column)this.unwrap(schema.getColumn(columnName)), null));
        }
    }

    @Override
    protected void checkAndCollectPrimaryKeyChange() {
        if (this.primaryKey == null) {
            throw new ValidationException(String.format("%sThe base table does not define any primary key constraint. You might want to add a new one.", "Failed to execute ALTER TABLE statement.\n"));
        }
        this.changeBuilders.add(schema -> Collections.singletonList(TableChange.modify((UniqueConstraint)((UniqueConstraint)this.unwrap(schema.getPrimaryKey())))));
    }

    @Override
    protected void checkAndCollectDistributionChange(TableDistribution newDistribution) {
        if (this.distribution == null) {
            throw new ValidationException(String.format("%sThe base table does not define any distribution. You might want to add a new one.", "Failed to execute ALTER TABLE statement.\n"));
        }
        this.changesCollector.add(TableChange.modify((TableDistribution)newDistribution));
    }

    @Override
    protected void checkAndCollectWatermarkChange() {
        if (this.watermarkSpec == null) {
            throw new ValidationException(String.format("%sThe base table does not define any watermark. You might want to add a new one.", "Failed to execute ALTER TABLE statement.\n"));
        }
        this.changeBuilders.add(schema -> Collections.singletonList(TableChange.modify((WatermarkSpec)((WatermarkSpec)schema.getWatermarkSpecs().get(0)))));
    }

    @Override
    @Nullable
    protected String getComment(SqlTableColumn column) {
        String comment = super.getComment(column);
        return comment == null ? (String)((Schema.UnresolvedColumn)this.columns.get(column.getName().getSimple())).getComment().orElse(null) : comment;
    }

    private static List<TableChange> buildModifyColumnChange(Column oldColumn, Column newColumn, @Nullable TableChange.ColumnPosition columnPosition) {
        if (oldColumn.isPhysical() && newColumn.isPhysical()) {
            ArrayList<TableChange> changes = new ArrayList<TableChange>();
            String newComment = newColumn.getComment().orElse(oldColumn.getComment().orElse(null));
            if (!newColumn.getComment().equals(oldColumn.getComment())) {
                changes.add((TableChange)TableChange.modifyColumnComment((Column)oldColumn, (String)newComment));
            }
            if (!oldColumn.getDataType().getLogicalType().equals((Object)newColumn.getDataType().getLogicalType())) {
                changes.add((TableChange)TableChange.modifyPhysicalColumnType((Column)oldColumn.withComment(newComment), (DataType)newColumn.getDataType()));
            }
            if (!Objects.equals(newColumn.getName(), oldColumn.getName())) {
                changes.add((TableChange)TableChange.modifyColumnName((Column)oldColumn.withComment(newComment).copy(newColumn.getDataType()), (String)newColumn.getName()));
            }
            if (columnPosition != null) {
                changes.add((TableChange)TableChange.modifyColumnPosition((Column)newColumn, (TableChange.ColumnPosition)columnPosition));
            }
            return changes;
        }
        return Collections.singletonList(TableChange.modify((Column)oldColumn, (Column)newColumn, (TableChange.ColumnPosition)columnPosition));
    }
}

