/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.SqlFactory;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
public class PlannerQueryOperation
implements QueryOperation {
    private final RelNode calciteTree;
    private final ResolvedSchema resolvedSchema;
    private final Supplier<String> toSqlString;

    public PlannerQueryOperation(RelNode calciteTree, Supplier<String> toSqlString) {
        this.calciteTree = calciteTree;
        this.toSqlString = toSqlString;
        RelDataType rowType = calciteTree.getRowType();
        String[] fieldNames = rowType.getFieldNames().toArray(new String[0]);
        DataType[] fieldTypes = (DataType[])rowType.getFieldList().stream().map(field -> LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)FlinkTypeFactory.toLogicalType(field.getType()))).toArray(DataType[]::new);
        this.resolvedSchema = ResolvedSchema.physical((String[])fieldNames, (DataType[])fieldTypes);
    }

    public RelNode getCalciteTree() {
        return this.calciteTree;
    }

    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    public String asSummaryString() {
        return OperationUtils.formatWithChildren((String)"PlannerNode", Collections.emptyMap(), this.getChildren(), Operation::asSummaryString);
    }

    public String asSerializableString(SqlFactory sqlFactory) {
        try {
            return this.toSqlString.get();
        }
        catch (Exception e) {
            throw new TableException("Given plan is not serializable into SQL", (Throwable)e);
        }
    }

    public List<QueryOperation> getChildren() {
        return Collections.emptyList();
    }

    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return (T)visitor.visit((QueryOperation)this);
    }
}

