/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.planner.functions.casting.AbstractCharacterFamilyTargetRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.VarCharType;

class NumericToStringCastRule
extends AbstractCharacterFamilyTargetRule<Object> {
    static final NumericToStringCastRule INSTANCE = new NumericToStringCastRule();

    private NumericToStringCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeFamily.NUMERIC).target((LogicalType)VarCharType.STRING_TYPE).build());
    }

    @Override
    public String generateStringExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        return CastRuleUtils.stringConcat("\"\"", inputTerm);
    }
}

