/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.BoxedWrapperRowData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinaryMapData;
import org.apache.flink.table.data.binary.BinaryRawValueData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.BinaryRowDataUtil;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.legacy.types.logical.TypeInformationRawType;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.GenerateUtils$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.HashCodeGenerator$;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods$;
import org.apache.flink.table.runtime.dataview.StateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.FilterCondition;
import org.apache.flink.table.runtime.generated.GeneratedHashFunction;
import org.apache.flink.table.runtime.generated.HashFunction;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.TableAggsHandleFunction;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.runtime.util.MurmurHashUtil;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.types.ColumnList;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.types.variant.Variant;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class CodeGenUtils$ {
    public static CodeGenUtils$ MODULE$;
    private final String DEFAULT_LEGACY_CAST_BEHAVIOUR;
    private final String DEFAULT_TIMEZONE_TERM;
    private final String DEFAULT_INPUT_TERM;
    private final String DEFAULT_INPUT1_TERM;
    private final String DEFAULT_INPUT2_TERM;
    private final String DEFAULT_COLLECTOR_TERM;
    private final String DEFAULT_OUT_RECORD_TERM;
    private final String DEFAULT_OPERATOR_COLLECTOR_TERM;
    private final String DEFAULT_OUT_RECORD_WRITER_TERM;
    private final String DEFAULT_CONTEXT_TERM;
    private final String BINARY_ROW;
    private final String ARRAY_DATA;
    private final String BINARY_ARRAY;
    private final String GENERIC_ARRAY;
    private final String BINARY_RAW_VALUE;
    private final String BINARY_STRING;
    private final String MAP_DATA;
    private final String BINARY_MAP;
    private final String GENERIC_MAP;
    private final String ROW_DATA;
    private final String JOINED_ROW;
    private final String GENERIC_ROW;
    private final String ROW_KIND;
    private final String DECIMAL_UTIL;
    private final String SEGMENT;
    private final String AGGS_HANDLER_FUNCTION;
    private final String TABLE_AGGS_HANDLER_FUNCTION;
    private final String NAMESPACE_AGGS_HANDLER_FUNCTION;
    private final String STATE_DATA_VIEW_STORE;
    private final String BINARY_STRING_UTIL;
    private final String TIME_WINDOW_UTIL;
    private final String TIMESTAMP_DATA;
    private final String RUNTIME_CONTEXT;
    private final String FILTER_CONTEXT;
    private final AtomicLong nameCounter;

    static {
        new CodeGenUtils$();
    }

    public String DEFAULT_LEGACY_CAST_BEHAVIOUR() {
        return this.DEFAULT_LEGACY_CAST_BEHAVIOUR;
    }

    public String DEFAULT_TIMEZONE_TERM() {
        return this.DEFAULT_TIMEZONE_TERM;
    }

    public String DEFAULT_INPUT_TERM() {
        return this.DEFAULT_INPUT_TERM;
    }

    public String DEFAULT_INPUT1_TERM() {
        return this.DEFAULT_INPUT1_TERM;
    }

    public String DEFAULT_INPUT2_TERM() {
        return this.DEFAULT_INPUT2_TERM;
    }

    public String DEFAULT_COLLECTOR_TERM() {
        return this.DEFAULT_COLLECTOR_TERM;
    }

    public String DEFAULT_OUT_RECORD_TERM() {
        return this.DEFAULT_OUT_RECORD_TERM;
    }

    public String DEFAULT_OPERATOR_COLLECTOR_TERM() {
        return this.DEFAULT_OPERATOR_COLLECTOR_TERM;
    }

    public String DEFAULT_OUT_RECORD_WRITER_TERM() {
        return this.DEFAULT_OUT_RECORD_WRITER_TERM;
    }

    public String DEFAULT_CONTEXT_TERM() {
        return this.DEFAULT_CONTEXT_TERM;
    }

    public String BINARY_ROW() {
        return this.BINARY_ROW;
    }

    public String ARRAY_DATA() {
        return this.ARRAY_DATA;
    }

    public String BINARY_ARRAY() {
        return this.BINARY_ARRAY;
    }

    public String GENERIC_ARRAY() {
        return this.GENERIC_ARRAY;
    }

    public String BINARY_RAW_VALUE() {
        return this.BINARY_RAW_VALUE;
    }

    public String BINARY_STRING() {
        return this.BINARY_STRING;
    }

    public String MAP_DATA() {
        return this.MAP_DATA;
    }

    public String BINARY_MAP() {
        return this.BINARY_MAP;
    }

    public String GENERIC_MAP() {
        return this.GENERIC_MAP;
    }

    public String ROW_DATA() {
        return this.ROW_DATA;
    }

    public String JOINED_ROW() {
        return this.JOINED_ROW;
    }

    public String GENERIC_ROW() {
        return this.GENERIC_ROW;
    }

    public String ROW_KIND() {
        return this.ROW_KIND;
    }

    public String DECIMAL_UTIL() {
        return this.DECIMAL_UTIL;
    }

    public String SEGMENT() {
        return this.SEGMENT;
    }

    public String AGGS_HANDLER_FUNCTION() {
        return this.AGGS_HANDLER_FUNCTION;
    }

    public String TABLE_AGGS_HANDLER_FUNCTION() {
        return this.TABLE_AGGS_HANDLER_FUNCTION;
    }

    public String NAMESPACE_AGGS_HANDLER_FUNCTION() {
        return this.NAMESPACE_AGGS_HANDLER_FUNCTION;
    }

    public String STATE_DATA_VIEW_STORE() {
        return this.STATE_DATA_VIEW_STORE;
    }

    public String BINARY_STRING_UTIL() {
        return this.BINARY_STRING_UTIL;
    }

    public String TIME_WINDOW_UTIL() {
        return this.TIME_WINDOW_UTIL;
    }

    public String TIMESTAMP_DATA() {
        return this.TIMESTAMP_DATA;
    }

    public String RUNTIME_CONTEXT() {
        return this.RUNTIME_CONTEXT;
    }

    public String FILTER_CONTEXT() {
        return this.FILTER_CONTEXT;
    }

    private AtomicLong nameCounter() {
        return this.nameCounter;
    }

    public String newName(CodeGeneratorContext context, String name) {
        if (context == null || context.getNameCounter() == null) {
            return new StringBuilder(2).append(name).append("$i").append(this.nameCounter().getAndIncrement()).toString();
        }
        return new StringBuilder(1).append(name).append("$").append(context.getNameCounter().getAndIncrement()).toString();
    }

    public Seq<String> newNames(CodeGeneratorContext context, Seq<String> names) {
        Predef$.MODULE$.require(names.toSet().size() == names.length(), (Function0 & Serializable & scala.Serializable)() -> "Duplicated names");
        if (context == null || context.getNameCounter() == null) {
            long newId = this.nameCounter().getAndIncrement();
            return (Seq)names.map((Function1 & Serializable & scala.Serializable)name -> new StringBuilder(2).append((String)name).append("$i").append(newId).toString(), Seq$.MODULE$.canBuildFrom());
        }
        long newId = context.getNameCounter().getAndIncrement();
        return (Seq)names.map((Function1 & Serializable & scala.Serializable)name -> new StringBuilder(1).append((String)name).append("$").append(newId).toString(), Seq$.MODULE$.canBuildFrom());
    }

    public <T> String className(Manifest<T> m3) {
        String name = m3.runtimeClass().getCanonicalName();
        if (name == null) {
            throw new CodeGenException(new StringBuilder(79).append("Class '").append(m3.runtimeClass().getName()).append("' does not have a canonical name. ").append("Make sure it is statically accessible.").toString());
        }
        return name;
    }

    public String className(Class<?> c) {
        String name = c.getCanonicalName();
        if (name == null) {
            throw new CodeGenException(new StringBuilder(79).append("Class '").append(c.getName()).append("' does not have a canonical name. ").append("Make sure it is statically accessible.").toString());
        }
        return name;
    }

    public String typeTerm(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        Class<StringData> clazz3 = StringData.class;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            return this.BINARY_STRING();
        }
        Class<?> clazz4 = clazz;
        Class<RawValueData> clazz5 = RawValueData.class;
        if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
            return this.BINARY_RAW_VALUE();
        }
        String name = clazz.getCanonicalName();
        if (name == null) {
            throw new CodeGenException(new StringBuilder(79).append("Class '").append(clazz.getName()).append("' does not have a canonical name. ").append("Make sure it is statically accessible.").toString());
        }
        return name;
    }

    public String primitiveTypeTermForType(LogicalType t) {
        while (true) {
            LogicalTypeRoot logicalTypeRoot;
            if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot = t.getTypeRoot())) {
                return "boolean";
            }
            if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
                return "byte";
            }
            if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
                return "short";
            }
            if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)))) {
                return "int";
            }
            if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
                return "long";
            }
            if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
                return "float";
            }
            if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
                return "double";
            }
            if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
            t = ((DistinctType)t).getSourceType();
        }
        return this.boxedTypeTermForType(t);
    }

    public String primitiveLiteralForType(Object value) {
        Object object = value;
        if (object instanceof Boolean) {
            return value.toString();
        }
        if (object instanceof Byte) {
            return new StringBuilder(8).append("((byte)").append(value).append(")").toString();
        }
        if (object instanceof Short) {
            return new StringBuilder(9).append("((short)").append(value).append(")").toString();
        }
        if (object instanceof Integer) {
            return value.toString();
        }
        if (object instanceof Long) {
            return new StringBuilder(1).append(value.toString()).append("L").toString();
        }
        if (object instanceof Float) {
            Object object2 = value;
            if (BoxesRunTime.equals((Object)BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY), (Object)object2)) {
                return "java.lang.Float.NEGATIVE_INFINITY";
            }
            if (BoxesRunTime.equals((Object)BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY), (Object)object2)) {
                return "java.lang.Float.POSITIVE_INFINITY";
            }
            return new StringBuilder(1).append(value.toString()).append("f").toString();
        }
        if (object instanceof Double) {
            Object object3 = value;
            if (BoxesRunTime.equals((Object)BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY), (Object)object3)) {
                return "java.lang.Double.NEGATIVE_INFINITY";
            }
            if (BoxesRunTime.equals((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY), (Object)object3)) {
                return "java.lang.Double.POSITIVE_INFINITY";
            }
            return new StringBuilder(1).append(value.toString()).append("d").toString();
        }
        if (object instanceof StringData) {
            StringData stringData = (StringData)object;
            return new StringBuilder(4).append(this.qualifyMethod(BuiltInMethods$.MODULE$.BINARY_STRING_DATA_FROM_STRING())).append("(\"").append(EncodingUtils.escapeJava((String)stringData.toString())).append("\")").toString();
        }
        if (object instanceof TimestampData) {
            TimestampData timestampData = (TimestampData)object;
            return new StringBuilder(21).append(this.TIMESTAMP_DATA()).append(".fromEpochMillis(").append(timestampData.getMillisecond()).append("L, ").append(timestampData.getNanoOfMillisecond()).append(")").toString();
        }
        if (object instanceof DecimalData) {
            DecimalData decimalData = (DecimalData)object;
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(48).append(this.DECIMAL_UTIL()).append(".castFrom(\n         |\"").append(decimalData.toString()).append("\",\n         |").append(decimalData.precision()).append(",\n         |").append(decimalData.scale()).append(")").toString())).stripMargin();
        }
        throw new IllegalArgumentException(new StringBuilder(22).append("Illegal literal type: ").append(value.getClass()).toString());
    }

    public String boxedTypeTermForType(LogicalType t) {
        LogicalTypeRoot logicalTypeRoot;
        while (true) {
            if (LogicalTypeRoot.CHAR.equals(logicalTypeRoot = t.getTypeRoot()) ? true : LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot)) {
                return this.BINARY_STRING();
            }
            if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
                return this.className(ManifestFactory$.MODULE$.classType(Boolean.class));
            }
            if (LogicalTypeRoot.BINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot)) {
                return "byte[]";
            }
            if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
                return this.className(ManifestFactory$.MODULE$.classType(DecimalData.class));
            }
            if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
                return this.className(ManifestFactory$.MODULE$.classType(Byte.class));
            }
            if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
                return this.className(ManifestFactory$.MODULE$.classType(Short.class));
            }
            if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)))) {
                return this.className(ManifestFactory$.MODULE$.classType(Integer.class));
            }
            if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
                return this.className(ManifestFactory$.MODULE$.classType(Long.class));
            }
            if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
                return this.className(ManifestFactory$.MODULE$.classType(Float.class));
            }
            if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
                return this.className(ManifestFactory$.MODULE$.classType(Double.class));
            }
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
                return this.className(ManifestFactory$.MODULE$.classType(TimestampData.class));
            }
            if (LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE.equals(logicalTypeRoot)) {
                throw new UnsupportedOperationException(new StringBuilder(18).append("Unsupported type: ").append(t).toString());
            }
            if (LogicalTypeRoot.ARRAY.equals(logicalTypeRoot)) {
                return this.className(ManifestFactory$.MODULE$.classType(ArrayData.class));
            }
            if (LogicalTypeRoot.MULTISET.equals(logicalTypeRoot) ? true : LogicalTypeRoot.MAP.equals(logicalTypeRoot)) {
                return this.className(ManifestFactory$.MODULE$.classType(MapData.class));
            }
            if (LogicalTypeRoot.ROW.equals(logicalTypeRoot) ? true : LogicalTypeRoot.STRUCTURED_TYPE.equals(logicalTypeRoot)) {
                return this.className(ManifestFactory$.MODULE$.classType(RowData.class));
            }
            if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
            t = ((DistinctType)t).getSourceType();
        }
        if (LogicalTypeRoot.NULL.equals(logicalTypeRoot)) {
            return this.className(ManifestFactory$.MODULE$.Object());
        }
        if (LogicalTypeRoot.RAW.equals(logicalTypeRoot)) {
            return this.className(ManifestFactory$.MODULE$.classType(BinaryRawValueData.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        }
        if (LogicalTypeRoot.DESCRIPTOR.equals(logicalTypeRoot)) {
            return this.className(ManifestFactory$.MODULE$.classType(ColumnList.class));
        }
        if (LogicalTypeRoot.VARIANT.equals(logicalTypeRoot)) {
            return this.className(ManifestFactory$.MODULE$.classType(Variant.class));
        }
        if (LogicalTypeRoot.SYMBOL.equals(logicalTypeRoot) ? true : LogicalTypeRoot.UNRESOLVED.equals(logicalTypeRoot)) {
            throw new IllegalArgumentException(new StringBuilder(14).append("Illegal type: ").append(t).toString());
        }
        throw new MatchError((Object)logicalTypeRoot);
    }

    public boolean isPrimitiveNullable(LogicalType t) {
        while (true) {
            LogicalTypeRoot logicalTypeRoot;
            if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot = t.getTypeRoot()) ? true : (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot) ? true : LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot))))))))))) {
                return false;
            }
            if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
            t = ((DistinctType)t).getSourceType();
        }
        return true;
    }

    public String primitiveDefaultValue(LogicalType t) {
        while (true) {
            LogicalTypeRoot logicalTypeRoot;
            if (LogicalTypeRoot.CHAR.equals(logicalTypeRoot = t.getTypeRoot()) ? true : LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot)) {
                return new StringBuilder(11).append(this.BINARY_STRING()).append(".EMPTY_UTF8").toString();
            }
            if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
                return "false";
            }
            if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)))))) {
                return "-1";
            }
            if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
                return "-1L";
            }
            if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
                return "-1.0f";
            }
            if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
                return "-1.0d";
            }
            if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
            t = ((DistinctType)t).getSourceType();
        }
        return "null";
    }

    public String hashCodeForType(CodeGeneratorContext ctx, LogicalType t, String term) {
        LogicalTypeRoot logicalTypeRoot;
        while (true) {
            if (LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot = t.getTypeRoot()) ? true : LogicalTypeRoot.CHAR.equals(logicalTypeRoot)) {
                return new StringBuilder(11).append(term).append(".hashCode()").toString();
            }
            if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
                return new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Boolean.class))).append(".hashCode(").append(term).append(")").toString();
            }
            if (LogicalTypeRoot.BINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot)) {
                return new StringBuilder(52).append(this.className(ManifestFactory$.MODULE$.classType(MurmurHashUtil.class))).append(".hashUnsafeBytes(").append(term).append(",").append(" ").append(this.className(ManifestFactory$.MODULE$.classType(BinaryRowDataUtil.class))).append(".BYTE_ARRAY_BASE_OFFSET, ").append(term).append(".length)").toString();
            }
            if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
                return new StringBuilder(11).append(term).append(".hashCode()").toString();
            }
            if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
                return new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Byte.class))).append(".hashCode(").append(term).append(")").toString();
            }
            if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
                return new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Short.class))).append(".hashCode(").append(term).append(")").toString();
            }
            if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)))) {
                return new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Integer.class))).append(".hashCode(").append(term).append(")").toString();
            }
            if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
                return new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Long.class))).append(".hashCode(").append(term).append(")").toString();
            }
            if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
                return new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Float.class))).append(".hashCode(").append(term).append(")").toString();
            }
            if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
                return new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Double.class))).append(".hashCode(").append(term).append(")").toString();
            }
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
                return new StringBuilder(11).append(term).append(".hashCode()").toString();
            }
            if (LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE.equals(logicalTypeRoot)) {
                throw new UnsupportedOperationException(new StringBuilder(120).append("Unsupported type(").append(t).append(") to generate hash code,").append(" the type(").append(t).append(") is not supported as a GROUP_BY/PARTITION_BY/JOIN_EQUAL/UNION field.").toString());
            }
            if (LogicalTypeRoot.ARRAY.equals(logicalTypeRoot)) {
                CodeGeneratorContext subCtx = new CodeGeneratorContext(ctx.tableConfig(), ctx.classLoader(), ctx);
                GeneratedHashFunction genHash = HashCodeGenerator$.MODULE$.generateArrayHash(subCtx, ((ArrayType)t).getElementType(), "SubHashArray");
                return this.genHashFunction(ctx, subCtx, genHash, term);
            }
            if (LogicalTypeRoot.MULTISET.equals(logicalTypeRoot) ? true : LogicalTypeRoot.MAP.equals(logicalTypeRoot)) {
                Tuple2 tuple2;
                CodeGeneratorContext subCtx = new CodeGeneratorContext(ctx.tableConfig(), ctx.classLoader(), ctx);
                LogicalType logicalType = t;
                if (logicalType instanceof MultisetType) {
                    MultisetType multisetType = (MultisetType)logicalType;
                    tuple2 = new Tuple2((Object)multisetType.getElementType(), (Object)new IntType());
                } else if (logicalType instanceof MapType) {
                    MapType mapType = (MapType)logicalType;
                    tuple2 = new Tuple2((Object)mapType.getKeyType(), (Object)mapType.getValueType());
                } else {
                    throw new MatchError((Object)logicalType);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                LogicalType keyType = (LogicalType)tuple22._1();
                LogicalType valueType = (LogicalType)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)keyType, (Object)valueType);
                LogicalType keyType2 = (LogicalType)tuple23._1();
                LogicalType valueType2 = (LogicalType)tuple23._2();
                GeneratedHashFunction genHash = HashCodeGenerator$.MODULE$.generateMapHash(subCtx, keyType2, valueType2, "SubHashMap");
                return this.genHashFunction(ctx, subCtx, genHash, term);
            }
            if (LogicalTypeRoot.ROW.equals(logicalTypeRoot) ? true : LogicalTypeRoot.STRUCTURED_TYPE.equals(logicalTypeRoot)) {
                int fieldCount = LogicalTypeChecks.getFieldCount((LogicalType)t);
                CodeGeneratorContext subCtx = new CodeGeneratorContext(ctx.tableConfig(), ctx.classLoader(), ctx);
                GeneratedHashFunction genHash = HashCodeGenerator$.MODULE$.generateRowHash(subCtx, t, "SubHashRow", (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), fieldCount).toArray(ClassTag$.MODULE$.Int()));
                return this.genHashFunction(ctx, subCtx, genHash, term);
            }
            if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
            t = ((DistinctType)t).getSourceType();
        }
        if (LogicalTypeRoot.RAW.equals(logicalTypeRoot)) {
            TypeSerializer typeSerializer;
            LogicalType logicalType = t;
            if (logicalType instanceof RawType) {
                RawType rawType = (RawType)logicalType;
                typeSerializer = rawType.getTypeSerializer();
            } else if (logicalType instanceof TypeInformationRawType) {
                TypeInformationRawType typeInformationRawType = (TypeInformationRawType)logicalType;
                typeSerializer = typeInformationRawType.getTypeInformation().createSerializer((SerializerConfig)new SerializerConfigImpl());
            } else {
                throw new MatchError((Object)logicalType);
            }
            TypeSerializer serializer = typeSerializer;
            String serTerm = ctx.addReusableObject(serializer, "serializer", ctx.addReusableObject$default$3());
            return new StringBuilder(22).append(term).append(".toObject(").append(serTerm).append(").hashCode()").toString();
        }
        if (LogicalTypeRoot.NULL.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.SYMBOL.equals(logicalTypeRoot) ? true : LogicalTypeRoot.UNRESOLVED.equals(logicalTypeRoot))) {
            throw new IllegalArgumentException(new StringBuilder(14).append("Illegal type: ").append(t).toString());
        }
        throw new MatchError((Object)logicalTypeRoot);
    }

    public String genHashFunction(CodeGeneratorContext ctx, CodeGeneratorContext subCtx, GeneratedHashFunction genHash, String term) {
        ctx.addReusableInnerClass(genHash.getClassName(), genHash.getCode());
        String refs = ctx.addReusableObject(subCtx.references().toArray(ClassTag$.MODULE$.AnyRef()), "subRefs", ctx.addReusableObject$default$3());
        String hashFunc = this.newName(ctx, "hashFunc");
        ctx.addReusableMember(new StringBuilder(2).append(HashFunction.class.getCanonicalName()).append(" ").append(hashFunc).append(";").toString());
        ctx.addReusableInitStatement(new StringBuilder(10).append(hashFunc).append(" = new ").append(genHash.getClassName()).append("(").append(refs).append(");").toString());
        return new StringBuilder(11).append(hashFunc).append(".hashCode(").append(term).append(")").toString();
    }

    public String qualifyMethod(Method method) {
        return new StringBuilder(1).append(method.getDeclaringClass().getCanonicalName()).append(".").append(method.getName()).toString();
    }

    public String qualifyEnum(Enum<?> enum_) {
        return new StringBuilder(1).append(enum_.getClass().getCanonicalName()).append(".").append(enum_.name()).toString();
    }

    public boolean compareEnum(String term, Enum<?> enum_) {
        String string = term;
        String string2 = this.qualifyEnum(enum_);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public Enum<?> getEnum(GeneratedExpression genExpr) {
        return (Enum)genExpr.literalValue().map((Function1 & Serializable & scala.Serializable)x$2 -> (Enum)x$2).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new CodeGenException("Enum literal expected.");
        });
    }

    public void requireNumeric(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isNumeric((LogicalType)genExpr.resultType())) {
            throw new CodeGenException(new StringBuilder(45).append("Numeric expression type expected, but was ").append("'").append(genExpr.resultType()).append("'.").toString());
        }
    }

    public void requireComparable(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isComparable((LogicalType)genExpr.resultType())) {
            throw new CodeGenException(new StringBuilder(37).append("Comparable type expected, but was '").append(genExpr.resultType()).append("'.").toString());
        }
    }

    public void requireCharacterString(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isCharacterString((LogicalType)genExpr.resultType())) {
            throw new CodeGenException("String expression type expected.");
        }
    }

    public void requireBoolean(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isBoolean((LogicalType)genExpr.resultType())) {
            throw new CodeGenException("Boolean expression type expected.");
        }
    }

    public void requireTemporal(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isTemporal((LogicalType)genExpr.resultType())) {
            throw new CodeGenException("Temporal expression type expected.");
        }
    }

    public void requireTimeInterval(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isTimeInterval((LogicalType)genExpr.resultType())) {
            throw new CodeGenException("Interval expression type expected.");
        }
    }

    public void requireArray(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isArray((LogicalType)genExpr.resultType())) {
            throw new CodeGenException("Array expression type expected.");
        }
    }

    public void requireMap(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isMap((LogicalType)genExpr.resultType())) {
            throw new CodeGenException("Map expression type expected.");
        }
    }

    public void requireInteger(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isInteger((LogicalType)genExpr.resultType())) {
            throw new CodeGenException("Integer expression type expected.");
        }
    }

    public void requireNumericAndTimeInterval(GeneratedExpression left, GeneratedExpression right) {
        boolean timeIntervalAndTimeNumeric;
        boolean numericAndTimeInterval = TypeCheckUtils.isNumeric((LogicalType)left.resultType()) && TypeCheckUtils.isTimeInterval((LogicalType)right.resultType());
        boolean bl = timeIntervalAndTimeNumeric = TypeCheckUtils.isTimeInterval((LogicalType)left.resultType()) && TypeCheckUtils.isNumeric((LogicalType)right.resultType());
        if (!numericAndTimeInterval && !timeIntervalAndTimeNumeric) {
            throw new CodeGenException(new StringBuilder(108).append("Numeric and Temporal expression type, or Temporal and Numeric expression type expected.  But were ").append("'").append(left.resultType()).append("' and '").append(right.resultType()).append("'.").toString());
        }
    }

    public String udfFieldName(UserDefinedFunction udf) {
        return new StringBuilder(9).append("function_").append(udf.functionIdentifier().replace('.', '$')).toString();
    }

    public String genLogInfo(String logTerm, String format, String argTerm) {
        return new StringBuilder(12).append(logTerm).append(".info(\"").append(format).append("\", ").append(argTerm).append(");").toString();
    }

    public String rowFieldReadAccess(int index, String rowTerm, LogicalType fieldType) {
        return this.rowFieldReadAccess(Integer.toString(index), rowTerm, fieldType);
    }

    public String rowFieldReadAccess(String indexTerm, String rowTerm, LogicalType t) {
        LogicalTypeRoot logicalTypeRoot;
        while (true) {
            if (LogicalTypeRoot.CHAR.equals(logicalTypeRoot = t.getTypeRoot()) ? true : LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot)) {
                return new StringBuilder(17).append("((").append(this.BINARY_STRING()).append(") ").append(rowTerm).append(".getString(").append(indexTerm).append("))").toString();
            }
            if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
                return new StringBuilder(13).append(rowTerm).append(".getBoolean(").append(indexTerm).append(")").toString();
            }
            if (LogicalTypeRoot.BINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot)) {
                return new StringBuilder(12).append(rowTerm).append(".getBinary(").append(indexTerm).append(")").toString();
            }
            if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
                return new StringBuilder(17).append(rowTerm).append(".getDecimal(").append(indexTerm).append(", ").append(LogicalTypeChecks.getPrecision((LogicalType)t)).append(", ").append(LogicalTypeChecks.getScale((LogicalType)t)).append(")").toString();
            }
            if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
                return new StringBuilder(10).append(rowTerm).append(".getByte(").append(indexTerm).append(")").toString();
            }
            if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
                return new StringBuilder(11).append(rowTerm).append(".getShort(").append(indexTerm).append(")").toString();
            }
            if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)))) {
                return new StringBuilder(9).append(rowTerm).append(".getInt(").append(indexTerm).append(")").toString();
            }
            if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
                return new StringBuilder(10).append(rowTerm).append(".getLong(").append(indexTerm).append(")").toString();
            }
            if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
                return new StringBuilder(11).append(rowTerm).append(".getFloat(").append(indexTerm).append(")").toString();
            }
            if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
                return new StringBuilder(12).append(rowTerm).append(".getDouble(").append(indexTerm).append(")").toString();
            }
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
                return new StringBuilder(17).append(rowTerm).append(".getTimestamp(").append(indexTerm).append(", ").append(LogicalTypeChecks.getPrecision((LogicalType)t)).append(")").toString();
            }
            if (LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE.equals(logicalTypeRoot)) {
                throw new UnsupportedOperationException(new StringBuilder(18).append("Unsupported type: ").append(t).toString());
            }
            if (LogicalTypeRoot.ARRAY.equals(logicalTypeRoot)) {
                return new StringBuilder(11).append(rowTerm).append(".getArray(").append(indexTerm).append(")").toString();
            }
            if (LogicalTypeRoot.MULTISET.equals(logicalTypeRoot) ? true : LogicalTypeRoot.MAP.equals(logicalTypeRoot)) {
                return new StringBuilder(9).append(rowTerm).append(".getMap(").append(indexTerm).append(")").toString();
            }
            if (LogicalTypeRoot.ROW.equals(logicalTypeRoot) ? true : LogicalTypeRoot.STRUCTURED_TYPE.equals(logicalTypeRoot)) {
                return new StringBuilder(11).append(rowTerm).append(".getRow(").append(indexTerm).append(", ").append(LogicalTypeChecks.getFieldCount((LogicalType)t)).append(")").toString();
            }
            if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
            t = ((DistinctType)t).getSourceType();
        }
        if (LogicalTypeRoot.RAW.equals(logicalTypeRoot)) {
            return new StringBuilder(19).append("((").append(this.BINARY_RAW_VALUE()).append(") ").append(rowTerm).append(".getRawValue(").append(indexTerm).append("))").toString();
        }
        if (LogicalTypeRoot.VARIANT.equals(logicalTypeRoot)) {
            return new StringBuilder(13).append(rowTerm).append(".getVariant(").append(indexTerm).append(")").toString();
        }
        if (LogicalTypeRoot.NULL.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.SYMBOL.equals(logicalTypeRoot) ? true : LogicalTypeRoot.UNRESOLVED.equals(logicalTypeRoot))) {
            throw new IllegalArgumentException(new StringBuilder(14).append("Illegal type: ").append(t).toString());
        }
        throw new MatchError((Object)logicalTypeRoot);
    }

    public String rowSetField(CodeGeneratorContext ctx, Class<? extends RowData> rowClass, String rowTerm, String indexTerm, GeneratedExpression fieldExpr, Option<String> binaryRowWriterTerm) {
        block8: {
            String setNullField;
            String fieldTerm;
            LogicalType fieldType;
            block7: {
                fieldType = fieldExpr.resultType();
                fieldTerm = fieldExpr.resultTerm();
                Class<? extends RowData> clazz = rowClass;
                Class<BinaryRowData> clazz2 = BinaryRowData.class;
                if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                    Option<String> option = binaryRowWriterTerm;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String writer = (String)some.value();
                        String writeField = this.binaryWriterWriteField(ctx, indexTerm, fieldTerm, writer, fieldType);
                        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(124).append("\n             |").append(fieldExpr.code()).append("\n             |if (").append(fieldExpr.nullTerm()).append(") {\n             |  ").append(this.binaryWriterWriteNull(indexTerm, writer, fieldType)).append(";\n             |} else {\n             |  ").append(writeField).append(";\n             |}\n           ").toString())).stripMargin();
                    }
                    if (None$.MODULE$.equals(option)) {
                        String writeField = this.binaryRowFieldSetAccess(indexTerm, rowTerm, fieldType, fieldTerm);
                        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(124).append("\n             |").append(fieldExpr.code()).append("\n             |if (").append(fieldExpr.nullTerm()).append(") {\n             |  ").append(this.binaryRowSetNull(indexTerm, rowTerm, fieldType)).append(";\n             |} else {\n             |  ").append(writeField).append(";\n             |}\n           ").toString())).stripMargin();
                    }
                    throw new MatchError(option);
                }
                Class<? extends RowData> clazz3 = rowClass;
                Class<GenericRowData> clazz4 = GenericRowData.class;
                if (!(clazz3 == null ? clazz4 != null : !clazz3.equals(clazz4))) break block7;
                Class<? extends RowData> clazz5 = rowClass;
                Class<BoxedWrapperRowData> clazz6 = BoxedWrapperRowData.class;
                if (clazz5 != null ? !clazz5.equals(clazz6) : clazz6 != null) break block8;
            }
            Class<? extends RowData> clazz = rowClass;
            Class<GenericRowData> clazz7 = GenericRowData.class;
            String writeField = !(clazz != null ? !clazz.equals(clazz7) : clazz7 != null) ? new StringBuilder(13).append(rowTerm).append(".setField(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString() : this.boxedWrapperRowFieldSetAccess(rowTerm, indexTerm, fieldTerm, fieldType);
            Class<? extends RowData> clazz8 = rowClass;
            Class<GenericRowData> clazz9 = GenericRowData.class;
            String string = !(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null) ? new StringBuilder(17).append(rowTerm).append(".setField(").append(indexTerm).append(", null)").toString() : (setNullField = new StringBuilder(12).append(rowTerm).append(".setNullAt(").append(indexTerm).append(")").toString());
            if (fieldType.isNullable()) {
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("\n           |").append(fieldExpr.code()).append("\n           |if (").append(fieldExpr.nullTerm()).append(") {\n           |  ").append(setNullField).append(";\n           |} else {\n           |  ").append(writeField).append(";\n           |}\n          ").toString())).stripMargin();
            }
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(37).append("\n           |").append(fieldExpr.code()).append("\n           |").append(writeField).append(";\n         ").toString())).stripMargin();
        }
        throw new UnsupportedOperationException(new StringBuilder(26).append("Not support set field for ").append(rowClass).toString());
    }

    public String binaryRowSetNull(int index, String rowTerm, LogicalType t) {
        return this.binaryRowSetNull(Integer.toString(index), rowTerm, t);
    }

    public String binaryRowSetNull(String indexTerm, String rowTerm, LogicalType t) {
        while (true) {
            LogicalTypeRoot logicalTypeRoot;
            if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot = t.getTypeRoot()) && !DecimalData.isCompact((int)LogicalTypeChecks.getPrecision((LogicalType)t))) {
                return new StringBuilder(21).append(rowTerm).append(".setDecimal(").append(indexTerm).append(", null, ").append(LogicalTypeChecks.getPrecision((LogicalType)t)).append(")").toString();
            }
            if ((LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) && !TimestampData.isCompact((int)LogicalTypeChecks.getPrecision((LogicalType)t))) {
                return new StringBuilder(23).append(rowTerm).append(".setTimestamp(").append(indexTerm).append(", null, ").append(LogicalTypeChecks.getPrecision((LogicalType)t)).append(")").toString();
            }
            if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
            t = ((DistinctType)t).getSourceType();
        }
        return new StringBuilder(12).append(rowTerm).append(".setNullAt(").append(indexTerm).append(")").toString();
    }

    public String binaryRowFieldSetAccess(int index, String binaryRowTerm, LogicalType fieldType, String fieldValTerm) {
        return this.binaryRowFieldSetAccess(Integer.toString(index), binaryRowTerm, fieldType, fieldValTerm);
    }

    public String binaryRowFieldSetAccess(String index, String binaryRowTerm, LogicalType t, String fieldValTerm) {
        while (true) {
            LogicalTypeRoot logicalTypeRoot;
            if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot = t.getTypeRoot())) {
                return new StringBuilder(15).append(binaryRowTerm).append(".setBoolean(").append(index).append(", ").append(fieldValTerm).append(")").toString();
            }
            if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
                return new StringBuilder(17).append(binaryRowTerm).append(".setDecimal(").append(index).append(", ").append(fieldValTerm).append(", ").append(LogicalTypeChecks.getPrecision((LogicalType)t)).append(")").toString();
            }
            if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
                return new StringBuilder(12).append(binaryRowTerm).append(".setByte(").append(index).append(", ").append(fieldValTerm).append(")").toString();
            }
            if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
                return new StringBuilder(13).append(binaryRowTerm).append(".setShort(").append(index).append(", ").append(fieldValTerm).append(")").toString();
            }
            if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)))) {
                return new StringBuilder(11).append(binaryRowTerm).append(".setInt(").append(index).append(", ").append(fieldValTerm).append(")").toString();
            }
            if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
                return new StringBuilder(12).append(binaryRowTerm).append(".setLong(").append(index).append(", ").append(fieldValTerm).append(")").toString();
            }
            if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
                return new StringBuilder(13).append(binaryRowTerm).append(".setFloat(").append(index).append(", ").append(fieldValTerm).append(")").toString();
            }
            if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
                return new StringBuilder(14).append(binaryRowTerm).append(".setDouble(").append(index).append(", ").append(fieldValTerm).append(")").toString();
            }
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
                return new StringBuilder(19).append(binaryRowTerm).append(".setTimestamp(").append(index).append(", ").append(fieldValTerm).append(", ").append(LogicalTypeChecks.getPrecision((LogicalType)t)).append(")").toString();
            }
            if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
            t = ((DistinctType)t).getSourceType();
        }
        throw new CodeGenException(new StringBuilder(60).append("Fail to find binary row field setter method of LogicalType ").append(t).append(".").toString());
    }

    public String boxedWrapperRowFieldSetAccess(String rowTerm, String indexTerm, String fieldTerm, LogicalType t) {
        while (true) {
            LogicalTypeRoot logicalTypeRoot;
            if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot = t.getTypeRoot())) {
                return new StringBuilder(15).append(rowTerm).append(".setBoolean(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString();
            }
            if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
                return new StringBuilder(12).append(rowTerm).append(".setByte(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString();
            }
            if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
                return new StringBuilder(13).append(rowTerm).append(".setShort(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString();
            }
            if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)))) {
                return new StringBuilder(11).append(rowTerm).append(".setInt(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString();
            }
            if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
                return new StringBuilder(12).append(rowTerm).append(".setLong(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString();
            }
            if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
                return new StringBuilder(13).append(rowTerm).append(".setFloat(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString();
            }
            if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
                return new StringBuilder(14).append(rowTerm).append(".setDouble(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString();
            }
            if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
            t = ((DistinctType)t).getSourceType();
        }
        return new StringBuilder(25).append(rowTerm).append(".setNonPrimitiveValue(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString();
    }

    public String binaryArraySetNull(int index, String arrayTerm, LogicalType t) {
        LogicalTypeRoot logicalTypeRoot;
        do {
            if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot = t.getTypeRoot())) {
                return new StringBuilder(17).append(arrayTerm).append(".setNullBoolean(").append(index).append(")").toString();
            }
            if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
                return new StringBuilder(14).append(arrayTerm).append(".setNullByte(").append(index).append(")").toString();
            }
            if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
                return new StringBuilder(15).append(arrayTerm).append(".setNullShort(").append(index).append(")").toString();
            }
            if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)))) {
                return new StringBuilder(13).append(arrayTerm).append(".setNullInt(").append(index).append(")").toString();
            }
            if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
                return new StringBuilder(15).append(arrayTerm).append(".setNullFloat(").append(index).append(")").toString();
            }
            if (!LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) continue;
            return new StringBuilder(16).append(arrayTerm).append(".setNullDouble(").append(index).append(")").toString();
        } while (LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot));
        return new StringBuilder(14).append(arrayTerm).append(".setNullLong(").append(index).append(")").toString();
    }

    public String binaryWriterWriteNull(int index, String writerTerm, LogicalType t) {
        return this.binaryWriterWriteNull(Integer.toString(index), writerTerm, t);
    }

    public String binaryWriterWriteNull(String indexTerm, String writerTerm, LogicalType t) {
        while (true) {
            LogicalTypeRoot logicalTypeRoot;
            if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot = t.getTypeRoot()) && !DecimalData.isCompact((int)LogicalTypeChecks.getPrecision((LogicalType)t))) {
                return new StringBuilder(23).append(writerTerm).append(".writeDecimal(").append(indexTerm).append(", null, ").append(LogicalTypeChecks.getPrecision((LogicalType)t)).append(")").toString();
            }
            if ((LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) && !TimestampData.isCompact((int)LogicalTypeChecks.getPrecision((LogicalType)t))) {
                return new StringBuilder(25).append(writerTerm).append(".writeTimestamp(").append(indexTerm).append(", null, ").append(LogicalTypeChecks.getPrecision((LogicalType)t)).append(")").toString();
            }
            if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
            t = ((DistinctType)t).getSourceType();
        }
        return new StringBuilder(12).append(writerTerm).append(".setNullAt(").append(indexTerm).append(")").toString();
    }

    public String binaryWriterWriteField(CodeGeneratorContext ctx, int index, String fieldValTerm, String writerTerm, LogicalType fieldType) {
        return this.binaryWriterWriteField((Function1<LogicalType, String>)(Function1 & Serializable & scala.Serializable)t -> ctx.addReusableTypeSerializer((LogicalType)t), Integer.toString(index), fieldValTerm, writerTerm, fieldType);
    }

    public String binaryWriterWriteField(CodeGeneratorContext ctx, String indexTerm, String fieldValTerm, String writerTerm, LogicalType t2) {
        return this.binaryWriterWriteField((Function1<LogicalType, String>)(Function1 & Serializable & scala.Serializable)t -> ctx.addReusableTypeSerializer((LogicalType)t), indexTerm, fieldValTerm, writerTerm, t2);
    }

    public String binaryWriterWriteField(Function1<LogicalType, String> addSerializer, String indexTerm, String fieldValTerm, String writerTerm, LogicalType t) {
        LogicalTypeRoot logicalTypeRoot;
        while (true) {
            if (LogicalTypeRoot.CHAR.equals(logicalTypeRoot = t.getTypeRoot()) ? true : LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot)) {
                return new StringBuilder(16).append(writerTerm).append(".writeString(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
            }
            if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
                return new StringBuilder(17).append(writerTerm).append(".writeBoolean(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
            }
            if (LogicalTypeRoot.BINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot)) {
                return new StringBuilder(16).append(writerTerm).append(".writeBinary(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
            }
            if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
                return new StringBuilder(19).append(writerTerm).append(".writeDecimal(").append(indexTerm).append(", ").append(fieldValTerm).append(", ").append(LogicalTypeChecks.getPrecision((LogicalType)t)).append(")").toString();
            }
            if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
                return new StringBuilder(14).append(writerTerm).append(".writeByte(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
            }
            if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
                return new StringBuilder(15).append(writerTerm).append(".writeShort(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
            }
            if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)))) {
                return new StringBuilder(13).append(writerTerm).append(".writeInt(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
            }
            if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
                return new StringBuilder(14).append(writerTerm).append(".writeLong(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
            }
            if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
                return new StringBuilder(15).append(writerTerm).append(".writeFloat(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
            }
            if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
                return new StringBuilder(16).append(writerTerm).append(".writeDouble(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
            }
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
                return new StringBuilder(21).append(writerTerm).append(".writeTimestamp(").append(indexTerm).append(", ").append(fieldValTerm).append(", ").append(LogicalTypeChecks.getPrecision((LogicalType)t)).append(")").toString();
            }
            if (LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE.equals(logicalTypeRoot)) {
                throw new UnsupportedOperationException(new StringBuilder(18).append("Unsupported type: ").append(t).toString());
            }
            if (LogicalTypeRoot.ARRAY.equals(logicalTypeRoot)) {
                String ser = (String)addSerializer.apply((Object)t);
                return new StringBuilder(17).append(writerTerm).append(".writeArray(").append(indexTerm).append(", ").append(fieldValTerm).append(", ").append(ser).append(")").toString();
            }
            if (LogicalTypeRoot.MULTISET.equals(logicalTypeRoot) ? true : LogicalTypeRoot.MAP.equals(logicalTypeRoot)) {
                String ser = (String)addSerializer.apply((Object)t);
                return new StringBuilder(15).append(writerTerm).append(".writeMap(").append(indexTerm).append(", ").append(fieldValTerm).append(", ").append(ser).append(")").toString();
            }
            if (LogicalTypeRoot.ROW.equals(logicalTypeRoot) ? true : LogicalTypeRoot.STRUCTURED_TYPE.equals(logicalTypeRoot)) {
                String ser = (String)addSerializer.apply((Object)t);
                return new StringBuilder(15).append(writerTerm).append(".writeRow(").append(indexTerm).append(", ").append(fieldValTerm).append(", ").append(ser).append(")").toString();
            }
            if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
            t = ((DistinctType)t).getSourceType();
        }
        if (LogicalTypeRoot.RAW.equals(logicalTypeRoot)) {
            String ser = (String)addSerializer.apply((Object)t);
            return new StringBuilder(20).append(writerTerm).append(".writeRawValue(").append(indexTerm).append(", ").append(fieldValTerm).append(", ").append(ser).append(")").toString();
        }
        if (LogicalTypeRoot.VARIANT.equals(logicalTypeRoot)) {
            return new StringBuilder(17).append(writerTerm).append(".writeVariant(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
        }
        if (LogicalTypeRoot.NULL.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.SYMBOL.equals(logicalTypeRoot) ? true : LogicalTypeRoot.UNRESOLVED.equals(logicalTypeRoot))) {
            throw new IllegalArgumentException(new StringBuilder(14).append("Illegal type: ").append(t).toString());
        }
        throw new MatchError((Object)logicalTypeRoot);
    }

    public Function1<String, String> genToInternalConverter(CodeGeneratorContext ctx, DataType sourceDataType) {
        if (LogicalTypeChecks.hasLegacyTypes((LogicalType)sourceDataType.getLogicalType())) {
            return this.genToInternalConverterWithLegacy(ctx, sourceDataType);
        }
        if (DataTypeUtils.isInternal((DataType)sourceDataType)) {
            return (Function1 & Serializable & scala.Serializable)externalTerm -> String.valueOf(externalTerm);
        }
        String internalTypeTerm = this.boxedTypeTermForType(sourceDataType.getLogicalType());
        String externalTypeTerm = this.typeTerm(sourceDataType.getConversionClass());
        String converterTerm = ctx.addReusableConverter(sourceDataType, ctx.addReusableConverter$default$2());
        return (Function1 & Serializable & scala.Serializable)externalTerm -> new StringBuilder(25).append("(").append(internalTypeTerm).append(") ").append(converterTerm).append(".toInternalOrNull((").append(externalTypeTerm).append(") ").append((String)externalTerm).append(")").toString();
    }

    public String genToInternalConverter(CodeGeneratorContext ctx, DataType sourceDataType, String externalTerm) {
        return (String)this.genToInternalConverter(ctx, sourceDataType).apply((Object)externalTerm);
    }

    public GeneratedExpression genToInternalConverterAll(CodeGeneratorContext ctx, DataType sourceDataType, String externalTerm) {
        String internalResultTerm;
        if (LogicalTypeChecks.hasLegacyTypes((LogicalType)sourceDataType.getLogicalType())) {
            return this.genToInternalConverterAllWithLegacy(ctx, sourceDataType, externalTerm);
        }
        LogicalType sourceType = sourceDataType.getLogicalType();
        Class sourceClass = sourceDataType.getConversionClass();
        String string = internalResultTerm = DataTypeUtils.isInternal((DataType)sourceDataType) ? String.valueOf(externalTerm) : (String)this.genToInternalConverter(ctx, sourceDataType).apply((Object)externalTerm);
        if (sourceClass.isPrimitive()) {
            return GenerateUtils$.MODULE$.generateNonNullField(sourceType, internalResultTerm);
        }
        return GenerateUtils$.MODULE$.generateInputFieldUnboxing(ctx, sourceType, externalTerm, internalResultTerm);
    }

    public String genToExternalConverter(CodeGeneratorContext ctx, DataType targetDataType, String internalTerm) {
        if (LogicalTypeChecks.hasLegacyTypes((LogicalType)targetDataType.getLogicalType())) {
            return this.genToExternalConverterWithLegacy(ctx, targetDataType, internalTerm);
        }
        if (DataTypeUtils.isInternal((DataType)targetDataType)) {
            return String.valueOf(internalTerm);
        }
        String internalTypeTerm = this.boxedTypeTermForType(targetDataType.getLogicalType());
        String externalTypeTerm = this.typeTerm(targetDataType.getConversionClass());
        String converterTerm = ctx.addReusableConverter(targetDataType, ctx.addReusableConverter$default$2());
        return new StringBuilder(19).append("(").append(externalTypeTerm).append(") ").append(converterTerm).append(".toExternal((").append(internalTypeTerm).append(") ").append(internalTerm).append(")").toString();
    }

    public String genToExternalConverterAll(CodeGeneratorContext ctx, DataType targetDataType, GeneratedExpression internalExpr) {
        String externalResultTerm;
        if (LogicalTypeChecks.hasLegacyTypes((LogicalType)targetDataType.getLogicalType())) {
            return this.genToExternalConverterAllWithLegacy(ctx, targetDataType, internalExpr);
        }
        LogicalType targetType = targetDataType.getLogicalType();
        String targetTypeTerm = this.boxedTypeTermForType(targetType);
        if (internalExpr.resultType().is(LogicalTypeRoot.NULL)) {
            return new StringBuilder(7).append("(").append(targetTypeTerm).append(") null").toString();
        }
        String string = externalResultTerm = DataTypeUtils.isInternal((DataType)targetDataType) ? new StringBuilder(3).append("(").append(targetTypeTerm).append(") ").append(internalExpr.resultTerm()).toString() : this.genToExternalConverter(ctx, targetDataType, internalExpr.resultTerm());
        if (targetDataType.getConversionClass().isPrimitive()) {
            return externalResultTerm;
        }
        return new StringBuilder(12).append(internalExpr.nullTerm()).append(" ? null : (").append(externalResultTerm).append(")").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInternalClass(DataType t) {
        Class clazz;
        Class clazz2 = clazz = t.getConversionClass();
        Class<Object> clazz3 = Object.class;
        if (clazz2 == null) {
            if (clazz3 == null) return false;
        } else if (clazz2.equals(clazz3)) return false;
        Class clazz4 = clazz;
        Class<Row> clazz5 = Row.class;
        if (clazz4 == null) {
            if (clazz5 == null) return false;
        } else if (clazz4.equals(clazz5)) return false;
        if (RowData.class.isAssignableFrom(clazz)) return true;
        Class clazz6 = clazz;
        Class clazz7 = LogicalTypeUtils.toInternalConversionClass((LogicalType)LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)t));
        if (clazz6 != null) {
            if (!clazz6.equals(clazz7)) return false;
            return true;
        }
        if (clazz7 == null) return true;
        return false;
    }

    private boolean isConverterIdentity(DataType t) {
        return DataFormatConverters.getConverterForDataType((DataType)t) instanceof DataFormatConverters.IdentityConverter;
    }

    private Function1<String, String> genToInternalConverterWithLegacy(CodeGeneratorContext ctx, DataType t) {
        if (this.isConverterIdentity(t)) {
            return (Function1 & Serializable & scala.Serializable)term -> String.valueOf(term);
        }
        String iTerm = this.boxedTypeTermForType(LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)t));
        String eTerm = this.typeTerm(t.getConversionClass());
        String converter = ctx.addReusableObject(DataFormatConverters.getConverterForDataType((DataType)t), "converter", ctx.addReusableObject$default$3());
        return (Function1 & Serializable & scala.Serializable)term -> new StringBuilder(19).append("(").append(iTerm).append(") ").append(converter).append(".toInternal((").append(eTerm).append(") ").append((String)term).append(")").toString();
    }

    private GeneratedExpression genToInternalConverterAllWithLegacy(CodeGeneratorContext ctx, DataType sourceDataType, String externalTerm) {
        String internalResultTerm;
        LogicalType sourceType = sourceDataType.getLogicalType();
        Class sourceClass = sourceDataType.getConversionClass();
        String string = internalResultTerm = this.isInternalClass(sourceDataType) ? String.valueOf(externalTerm) : (String)this.genToInternalConverterWithLegacy(ctx, sourceDataType).apply((Object)externalTerm);
        if (sourceClass.isPrimitive()) {
            return GenerateUtils$.MODULE$.generateNonNullField(sourceType, internalResultTerm);
        }
        return GenerateUtils$.MODULE$.generateInputFieldUnboxing(ctx, sourceType, externalTerm, internalResultTerm);
    }

    public String genToExternalConverterWithLegacy(CodeGeneratorContext ctx, DataType targetType, String internalTerm) {
        if (this.isConverterIdentity(targetType)) {
            return String.valueOf(internalTerm);
        }
        String iTerm = this.boxedTypeTermForType(LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)targetType));
        String eTerm = this.typeTerm(targetType.getConversionClass());
        String converter = ctx.addReusableObject(DataFormatConverters.getConverterForDataType((DataType)targetType), "converter", ctx.addReusableObject$default$3());
        return new StringBuilder(19).append("(").append(eTerm).append(") ").append(converter).append(".toExternal((").append(iTerm).append(") ").append(internalTerm).append(")").toString();
    }

    private String genToExternalConverterAllWithLegacy(CodeGeneratorContext ctx, DataType targetDataType, GeneratedExpression internalExpr) {
        String externalResultTerm;
        LogicalType targetType = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)targetDataType);
        String targetTypeTerm = this.boxedTypeTermForType(targetType);
        if (internalExpr.resultType().is(LogicalTypeRoot.NULL)) {
            return new StringBuilder(7).append("(").append(targetTypeTerm).append(") null").toString();
        }
        String string = externalResultTerm = this.isInternalClass(targetDataType) ? new StringBuilder(3).append("(").append(targetTypeTerm).append(") ").append(internalExpr.resultTerm()).toString() : this.genToExternalConverterWithLegacy(ctx, targetDataType, internalExpr.resultTerm());
        if (targetDataType.getConversionClass().isPrimitive()) {
            return externalResultTerm;
        }
        return new StringBuilder(12).append(internalExpr.nullTerm()).append(" ? null : (").append(externalResultTerm).append(")").toString();
    }

    public int[] fieldIndices(LogicalType t) {
        if (LogicalTypeChecks.isCompositeType((LogicalType)t)) {
            return (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), LogicalTypeChecks.getFieldCount((LogicalType)t)).toArray(ClassTag$.MODULE$.Int());
        }
        return new int[]{0};
    }

    public Seq<GeneratedExpression> getReuseRowFieldExprs(CodeGeneratorContext ctx, RowType inputType, String inputRowTerm) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.fieldIndices((LogicalType)inputType))).map((Function1 & Serializable & scala.Serializable)index -> CodeGenUtils$.$anonfun$getReuseRowFieldExprs$1(ctx, inputType, inputRowTerm, BoxesRunTime.unboxToInt((Object)index)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeneratedExpression.class))))).toSeq();
    }

    public GeneratedExpression getFieldExpr(CodeGeneratorContext ctx, String inputTerm, RowType inputType, int index) {
        Option<GeneratedExpression> option = ctx.getReusableInputUnboxingExprs(inputTerm, index);
        if (option instanceof Some) {
            Some some = (Some)option;
            GeneratedExpression expr = (GeneratedExpression)some.value();
            return expr;
        }
        if (None$.MODULE$.equals(option)) {
            return GenerateUtils$.MODULE$.generateFieldAccess(ctx, (LogicalType)inputType, inputTerm, index);
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ GeneratedExpression $anonfun$getReuseRowFieldExprs$1(CodeGeneratorContext ctx$3, RowType inputType$1, String inputRowTerm$1, int index) {
        GeneratedExpression expr = GenerateUtils$.MODULE$.generateFieldAccess(ctx$3, (LogicalType)inputType$1, inputRowTerm$1, index);
        ctx$3.addReusableInputUnboxingExprs(inputRowTerm$1, index, expr);
        return expr;
    }

    private CodeGenUtils$() {
        MODULE$ = this;
        this.DEFAULT_LEGACY_CAST_BEHAVIOUR = "legacyCastBehaviour";
        this.DEFAULT_TIMEZONE_TERM = "timeZone";
        this.DEFAULT_INPUT_TERM = "in";
        this.DEFAULT_INPUT1_TERM = "in1";
        this.DEFAULT_INPUT2_TERM = "in2";
        this.DEFAULT_COLLECTOR_TERM = "c";
        this.DEFAULT_OUT_RECORD_TERM = "out";
        this.DEFAULT_OPERATOR_COLLECTOR_TERM = "output";
        this.DEFAULT_OUT_RECORD_WRITER_TERM = "outWriter";
        this.DEFAULT_CONTEXT_TERM = "ctx";
        this.BINARY_ROW = this.className(ManifestFactory$.MODULE$.classType(BinaryRowData.class));
        this.ARRAY_DATA = this.className(ManifestFactory$.MODULE$.classType(ArrayData.class));
        this.BINARY_ARRAY = this.className(ManifestFactory$.MODULE$.classType(BinaryArrayData.class));
        this.GENERIC_ARRAY = this.className(ManifestFactory$.MODULE$.classType(GenericArrayData.class));
        this.BINARY_RAW_VALUE = this.className(ManifestFactory$.MODULE$.classType(BinaryRawValueData.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        this.BINARY_STRING = this.className(ManifestFactory$.MODULE$.classType(BinaryStringData.class));
        this.MAP_DATA = this.className(ManifestFactory$.MODULE$.classType(MapData.class));
        this.BINARY_MAP = this.className(ManifestFactory$.MODULE$.classType(BinaryMapData.class));
        this.GENERIC_MAP = this.className(ManifestFactory$.MODULE$.classType(GenericMapData.class));
        this.ROW_DATA = this.className(ManifestFactory$.MODULE$.classType(RowData.class));
        this.JOINED_ROW = this.className(ManifestFactory$.MODULE$.classType(JoinedRowData.class));
        this.GENERIC_ROW = this.className(ManifestFactory$.MODULE$.classType(GenericRowData.class));
        this.ROW_KIND = this.className(ManifestFactory$.MODULE$.classType(RowKind.class));
        this.DECIMAL_UTIL = this.className(ManifestFactory$.MODULE$.classType(DecimalDataUtils.class));
        this.SEGMENT = this.className(ManifestFactory$.MODULE$.classType(MemorySegment.class));
        this.AGGS_HANDLER_FUNCTION = this.className(ManifestFactory$.MODULE$.classType(AggsHandleFunction.class));
        this.TABLE_AGGS_HANDLER_FUNCTION = this.className(ManifestFactory$.MODULE$.classType(TableAggsHandleFunction.class));
        this.NAMESPACE_AGGS_HANDLER_FUNCTION = this.className(ManifestFactory$.MODULE$.classType(NamespaceAggsHandleFunction.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        this.STATE_DATA_VIEW_STORE = this.className(ManifestFactory$.MODULE$.classType(StateDataViewStore.class));
        this.BINARY_STRING_UTIL = this.className(ManifestFactory$.MODULE$.classType(BinaryStringDataUtil.class));
        this.TIME_WINDOW_UTIL = this.className(ManifestFactory$.MODULE$.classType(TimeWindowUtil.class));
        this.TIMESTAMP_DATA = this.className(ManifestFactory$.MODULE$.classType(TimestampData.class));
        this.RUNTIME_CONTEXT = this.className(ManifestFactory$.MODULE$.classType(RuntimeContext.class));
        this.FILTER_CONTEXT = this.className(ManifestFactory$.MODULE$.classType(FilterCondition.Context.class));
        this.nameCounter = new AtomicLong();
    }
}

