/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.type;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.flink.table.calcite.ExtendedRelTypeFactory;

public class SqlStructuredTypeNameSpec
extends SqlTypeNameSpec {
    private final SqlNode className;
    private final List<SqlIdentifier> fieldNames;
    private final List<SqlDataTypeSpec> fieldTypes;
    private final List<SqlCharStringLiteral> comments;

    public SqlStructuredTypeNameSpec(SqlParserPos pos, SqlNode className, List<SqlIdentifier> fieldNames, List<SqlDataTypeSpec> fieldTypes, List<SqlCharStringLiteral> comments) {
        super(new SqlIdentifier(SqlTypeName.STRUCTURED.getName(), pos), pos);
        this.className = className;
        this.fieldNames = fieldNames;
        this.fieldTypes = fieldTypes;
        this.comments = comments;
    }

    public List<SqlIdentifier> getFieldNames() {
        return this.fieldNames;
    }

    public List<SqlDataTypeSpec> getFieldTypes() {
        return this.fieldTypes;
    }

    public List<SqlCharStringLiteral> getComments() {
        return this.comments;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.print("STRUCTURED");
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "<", ">");
        writer.sep(",");
        this.className.unparse(writer, leftPrec, rightPrec);
        int i = 0;
        for (Pair<SqlIdentifier, SqlDataTypeSpec> p : Pair.zip(this.fieldNames, this.fieldTypes)) {
            assert (p.left != null);
            assert (p.right != null);
            writer.sep(",");
            ((SqlIdentifier)p.left).unparse(writer, 0, 0);
            ((SqlDataTypeSpec)p.right).unparse(writer, leftPrec, rightPrec);
            if (((SqlDataTypeSpec)p.right).getNullable() != null && !((SqlDataTypeSpec)p.right).getNullable().booleanValue()) {
                writer.keyword("NOT NULL");
            }
            if (this.comments.get(i) != null) {
                this.comments.get(i).unparse(writer, leftPrec, rightPrec);
            }
            ++i;
        }
        writer.endList(frame);
    }

    @Override
    public boolean equalsDeep(SqlTypeNameSpec spec, Litmus litmus) {
        int i;
        if (!(spec instanceof SqlStructuredTypeNameSpec)) {
            return litmus.fail("{} != {}", this, spec);
        }
        SqlStructuredTypeNameSpec that = (SqlStructuredTypeNameSpec)spec;
        if (!this.className.equalsDeep(that.className, litmus)) {
            return litmus.fail("{} != {}", this, spec);
        }
        if (this.fieldNames.size() != that.fieldNames.size()) {
            return litmus.fail("{} != {}", this, spec);
        }
        for (i = 0; i < this.fieldNames.size(); ++i) {
            if (this.fieldNames.get(i).equalsDeep((SqlNode)that.fieldNames.get(i), litmus)) continue;
            return litmus.fail("{} != {}", this, spec);
        }
        if (this.fieldTypes.size() != that.fieldTypes.size()) {
            return litmus.fail("{} != {}", this, spec);
        }
        for (i = 0; i < this.fieldTypes.size(); ++i) {
            if (this.fieldTypes.get(i).equalsDeep((SqlNode)that.fieldTypes.get(i), litmus)) continue;
            return litmus.fail("{} != {}", this, spec);
        }
        return litmus.succeed();
    }

    @Override
    public RelDataType deriveType(SqlValidator sqlValidator) {
        ExtendedRelTypeFactory typeFactory = (ExtendedRelTypeFactory)sqlValidator.getTypeFactory();
        return typeFactory.createStructuredType(((NlsString)SqlLiteral.value(this.className)).getValue(), this.fieldTypes.stream().map(dt -> dt.deriveType(sqlValidator)).collect(Collectors.toList()), this.fieldNames.stream().map(SqlIdentifier::toString).collect(Collectors.toList()));
    }
}

