/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.dql;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public abstract class SqlShowCall
extends SqlCall {
    private final String preposition;
    private final SqlIdentifier sqlIdentifier;
    private final String likeType;
    private final SqlCharStringLiteral likeLiteral;
    private final boolean notLike;

    public SqlShowCall(SqlParserPos pos, String preposition, SqlIdentifier databaseName, String likeType, SqlCharStringLiteral likeLiteral, boolean notLike) {
        super(pos);
        this.preposition = preposition;
        this.sqlIdentifier = preposition != null ? databaseName : null;
        this.likeType = likeType;
        this.likeLiteral = likeType == null ? null : likeLiteral;
        this.notLike = likeType != null && notLike;
    }

    @Override
    public abstract SqlOperator getOperator();

    @Override
    public List<SqlNode> getOperandList() {
        return Objects.isNull(this.sqlIdentifier) ? Collections.emptyList() : Collections.singletonList(this.sqlIdentifier);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        String keyword = this.getOperationName();
        if (this.preposition == null) {
            writer.keyword(keyword);
        } else if (this.sqlIdentifier != null) {
            writer.keyword(keyword + " " + this.preposition);
            this.sqlIdentifier.unparse(writer, leftPrec, rightPrec);
        }
        if (this.isWithLike()) {
            String notPrefix = this.isNotLike() ? "NOT " : "";
            writer.keyword(String.format("%s%s '%s'", notPrefix, this.likeType, this.getLikeSqlPattern()));
        }
    }

    public String getPreposition() {
        return this.preposition;
    }

    public List<String> getSqlIdentifierNameList() {
        return Objects.isNull(this.sqlIdentifier) ? Collections.emptyList() : this.sqlIdentifier.names;
    }

    public boolean isWithLike() {
        return this.likeType != null;
    }

    public String getLikeType() {
        return this.likeType;
    }

    public String getLikeSqlPattern() {
        return Objects.isNull(this.likeLiteral) ? null : this.likeLiteral.getValueAs(String.class);
    }

    public boolean isNotLike() {
        return this.notLike;
    }

    abstract String getOperationName();
}

