/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlUseModules
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("USE MODULES", SqlKind.OTHER);
    private final List<SqlIdentifier> moduleNames;

    public SqlUseModules(SqlParserPos pos, List<SqlIdentifier> moduleNames) {
        super(pos);
        this.moduleNames = Objects.requireNonNull(moduleNames, "moduleNames cannot be null");
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.copyOf(this.moduleNames);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("USE MODULES");
        for (int i = 0; i < this.moduleNames.size(); ++i) {
            this.moduleNames.get(i).unparse(writer, leftPrec, rightPrec);
            if (i >= this.moduleNames.size() - 1) continue;
            writer.keyword(",");
        }
    }

    public List<String> moduleNames() {
        return this.moduleNames.stream().map(SqlIdentifier::getSimple).collect(Collectors.toList());
    }
}

