/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlDropModel
extends SqlDrop {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("DROP MODEL", SqlKind.OTHER_DDL);
    private SqlIdentifier modelName;
    private boolean ifExists;
    private boolean isTemporary;

    public SqlDropModel(SqlParserPos pos, SqlIdentifier modelName, boolean ifExists, boolean isTemporary) {
        super(OPERATOR, pos, ifExists);
        this.modelName = modelName;
        this.ifExists = ifExists;
        this.isTemporary = isTemporary;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.modelName);
    }

    public SqlIdentifier getModelName() {
        return this.modelName;
    }

    public void setModelName(SqlIdentifier modelName) {
        this.modelName = modelName;
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    public boolean getIsTemporary() {
        return this.isTemporary;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP");
        writer.keyword("MODEL");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.modelName.unparse(writer, leftPrec, rightPrec);
    }

    public String[] fullModelName() {
        return this.modelName.names.toArray(new String[0]);
    }
}

