/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.AbstractList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;

public class SqlRowOperator
extends SqlSpecialOperator {
    public SqlRowOperator(String name) {
        super(name, SqlKind.ROW, 200, false, null, InferTypes.RETURN_TYPE, OperandTypes.VARIADIC);
    }

    @Override
    public RelDataType inferReturnType(final SqlOperatorBinding opBinding) {
        final int fieldCount = opBinding.getOperandCount();
        return opBinding.getTypeFactory().createStructType(StructKind.PEEK_FIELDS_NO_EXPAND, (List<RelDataType>)new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                return opBinding.getOperandType(index);
            }

            @Override
            public int size() {
                return fieldCount;
            }
        }, (List<String>)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return SqlUtil.deriveAliasFromOrdinal(index);
            }

            @Override
            public int size() {
                return fieldCount;
            }
        });
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlUtil.unparseFunctionSyntax(this, writer, call, false);
    }

    @Override
    public boolean requiresDecimalExpansion() {
        return false;
    }
}

