/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.ddl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.Symbolizable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;

public class SqlCreateTableLike
extends SqlCreate {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE TABLE LIKE", SqlKind.CREATE_TABLE_LIKE);
    public final SqlIdentifier name;
    public final SqlIdentifier sourceTable;
    public final SqlNodeList includingOptions;
    public final SqlNodeList excludingOptions;

    public SqlCreateTableLike(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, SqlIdentifier sourceTable, SqlNodeList includingOptions, SqlNodeList excludingOptions) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = name;
        this.sourceTable = sourceTable;
        this.includingOptions = includingOptions;
        this.excludingOptions = excludingOptions;
        if (includingOptions.contains(LikeOption.ALL.symbol(SqlParserPos.ZERO))) {
            Preconditions.checkArgument(includingOptions.size() == 1 && excludingOptions.isEmpty(), "ALL cannot be used with other options");
        } else if (excludingOptions.contains(LikeOption.ALL.symbol(SqlParserPos.ZERO))) {
            Preconditions.checkArgument(excludingOptions.size() == 1 && includingOptions.isEmpty(), "ALL cannot be used with other options");
        }
        includingOptions.forEach((Consumer<? super SqlNode>)((Consumer<SqlNode>)option -> Preconditions.checkArgument(!excludingOptions.contains(option), "Cannot include and exclude option %s at same time", (Object)option.toString())));
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.sourceTable, this.includingOptions, this.excludingOptions);
    }

    public Set<LikeOption> options() {
        return this.includingOptions.stream().map(c -> ((SqlLiteral)c).symbolValue(LikeOption.class)).collect(Collectors.toSet());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        LikeOption likeOption;
        writer.keyword("CREATE");
        writer.keyword("TABLE");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        writer.keyword("LIKE");
        this.sourceTable.unparse(writer, leftPrec, rightPrec);
        for (SqlNode c : new HashSet<SqlNode>(this.includingOptions)) {
            likeOption = ((SqlLiteral)c).getValueAs(LikeOption.class);
            writer.newlineAndIndent();
            writer.keyword("INCLUDING");
            writer.keyword(likeOption.name());
        }
        for (SqlNode c : new HashSet<SqlNode>(this.excludingOptions)) {
            likeOption = ((SqlLiteral)c).getValueAs(LikeOption.class);
            writer.newlineAndIndent();
            writer.keyword("EXCLUDING");
            writer.keyword(likeOption.name());
        }
    }

    public static enum LikeOption implements Symbolizable
    {
        ALL,
        DEFAULTS,
        GENERATED;

    }
}

