/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.Sample;
import org.apache.calcite.rel.rules.ImmutableSampleToFilterRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.immutables.value.Value;

@Value.Enclosing
public class SampleToFilterRule
extends RelRule<Config>
implements TransformationRule {
    protected SampleToFilterRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sample sample = (Sample)call.rel(0);
        RelBuilder relBuilder = call.builder();
        relBuilder.push(sample.getInput());
        RexNode randFunc = sample.getSamplingParameters().isRepeatable() ? relBuilder.call((SqlOperator)SqlStdOperatorTable.RAND, relBuilder.literal(sample.getSamplingParameters().getRepeatableSeed())) : relBuilder.call((SqlOperator)SqlStdOperatorTable.RAND, new RexNode[0]);
        relBuilder.filter(relBuilder.lessThan(randFunc, relBuilder.literal(sample.getSamplingParameters().sampleRate)));
        call.transformTo(relBuilder.build());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSampleToFilterRule.Config.of().withOperandFor(Sample.class);

        @Override
        default public SampleToFilterRule toRule() {
            return new SampleToFilterRule(this);
        }

        default public Config withOperandFor(Class<? extends Sample> sampleClass) {
            return this.withOperandSupplier(b -> b.operand(sampleClass).predicate(sample -> sample.getSamplingParameters().isBernoulli()).anyInputs()).as(Config.class);
        }
    }
}

