/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.calcite.linq4j.function.Deterministic;
import org.apache.calcite.linq4j.function.NonDeterministic;
import org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.calcite.linq4j.tree.ClassDeclarationFinder;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.FieldDeclaration;
import org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.calcite.linq4j.tree.MemberExpression;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.TernaryExpression;
import org.apache.calcite.linq4j.tree.TypeBinaryExpression;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSet;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class DeterministicCodeOptimizer
extends ClassDeclarationFinder {
    protected final IdentityHashMap<Expression, Boolean> constants = new IdentityHashMap();
    protected final Map<Expression, ParameterExpression> dedup = new HashMap<Expression, ParameterExpression>();
    protected final Map<String, ParameterExpression> fieldsByName = new HashMap<String, ParameterExpression>();
    private static final Pattern NON_ASCII = Pattern.compile("[^0-9a-zA-Z$]+");
    private static final String FIELD_PREFIX = "$L4J$C$";
    private static final Pattern PREFIX_PATTERN = Pattern.compile(Pattern.quote("$L4J$C$"));
    private static final Set<Class> DETERMINISTIC_CLASSES = ImmutableSet.of(Byte.class, Boolean.class, Short.class, Integer.class, Long.class, BigInteger.class, new Class[]{BigDecimal.class, String.class, Math.class});

    public DeterministicCodeOptimizer(ClassDeclarationFinder parent) {
        super(parent);
    }

    @Override
    protected Expression tryOptimizeNewInstance(NewExpression newExpression) {
        if (newExpression.type instanceof Class && this.isConstant(newExpression.arguments) && this.isConstructorDeterministic(newExpression)) {
            return this.createField(newExpression);
        }
        return newExpression;
    }

    @Override
    public Expression visit(BinaryExpression binaryExpression, Expression expression0, Expression expression1) {
        Expression result = super.visit(binaryExpression, expression0, expression1);
        if (binaryExpression.getNodeType().modifiesLvalue) {
            return result;
        }
        if (this.isConstant(expression0) && this.isConstant(expression1)) {
            return this.createField(result);
        }
        return result;
    }

    @Override
    public Expression visit(TernaryExpression ternaryExpression, Expression expression0, Expression expression1, Expression expression2) {
        Expression result = super.visit(ternaryExpression, expression0, expression1, expression2);
        if (this.isConstant(expression0) && this.isConstant(expression1) && this.isConstant(expression2)) {
            return this.createField(result);
        }
        return result;
    }

    @Override
    public Expression visit(UnaryExpression unaryExpression, Expression expression) {
        Expression result = super.visit(unaryExpression, expression);
        if (this.isConstant(expression)) {
            this.constants.put(result, true);
            if (result.getNodeType() != ExpressionType.Convert) {
                return this.createField(result);
            }
        }
        return result;
    }

    @Override
    public Expression visit(TypeBinaryExpression typeBinaryExpression, Expression expression) {
        Expression result = super.visit(typeBinaryExpression, expression);
        if (this.isConstant(expression)) {
            this.constants.put(result, true);
        }
        return result;
    }

    protected Expression tryOptimizeMethodCall(MethodCallExpression methodCallExpression) {
        if (this.isConstant(methodCallExpression.targetExpression) && this.isConstant(methodCallExpression.expressions) && this.isMethodDeterministic(methodCallExpression.method)) {
            return this.createField(methodCallExpression);
        }
        return methodCallExpression;
    }

    @Override
    public Expression visit(MethodCallExpression methodCallExpression, @Nullable Expression targetExpression, List<Expression> expressions) {
        Expression result = super.visit(methodCallExpression, targetExpression, expressions);
        result = this.tryOptimizeMethodCall((MethodCallExpression)result);
        return result;
    }

    @Override
    public Expression visit(MemberExpression memberExpression, @Nullable Expression expression) {
        Expression result = super.visit(memberExpression, expression);
        if (this.isConstant(expression) && Modifier.isFinal(memberExpression.field.getModifiers())) {
            this.constants.put(result, true);
        }
        return result;
    }

    @Override
    public MemberDeclaration visit(FieldDeclaration fieldDeclaration, @Nullable Expression initializer) {
        if (Modifier.isStatic(fieldDeclaration.modifier)) {
            return fieldDeclaration;
        }
        return super.visit(fieldDeclaration, initializer);
    }

    @Override
    protected void learnFinalStaticDeclarations(List<MemberDeclaration> memberDeclarations) {
        for (MemberDeclaration decl : memberDeclarations) {
            if (!(decl instanceof FieldDeclaration)) continue;
            FieldDeclaration field = (FieldDeclaration)decl;
            if (!Modifier.isStatic(field.modifier) || !Modifier.isFinal(field.modifier) || field.initializer == null) continue;
            this.constants.put(field.parameter, true);
            this.fieldsByName.put(field.parameter.name, field.parameter);
            this.dedup.put(field.initializer, field.parameter);
        }
    }

    @Override
    protected @Nullable ParameterExpression findDeclaredExpression(Expression expression) {
        ParameterExpression pe;
        if (!this.dedup.isEmpty() && (pe = this.dedup.get(expression)) != null) {
            return pe;
        }
        return this.parent == null ? null : this.parent.findDeclaredExpression(expression);
    }

    protected Expression createField(Expression expression) {
        ParameterExpression pe = this.findDeclaredExpression(expression);
        if (pe != null) {
            return pe;
        }
        String name = this.inventFieldName(expression);
        pe = Expressions.parameter(expression.getType(), name);
        FieldDeclaration decl = Expressions.fieldDecl(24, pe, expression);
        this.dedup.put(expression, pe);
        this.addedDeclarations.add(decl);
        this.constants.put(pe, true);
        this.fieldsByName.put(name, pe);
        return pe;
    }

    protected String inventFieldName(Expression expression) {
        String exprText = expression.toString();
        exprText = PREFIX_PATTERN.matcher(exprText).replaceAll("");
        exprText = FIELD_PREFIX + NON_ASCII.matcher(exprText).replaceAll("_");
        if (exprText.length() > 70) {
            exprText = exprText.substring(0, 70) + Integer.toHexString(exprText.hashCode());
        }
        String fieldName = exprText;
        int i = 0;
        while (this.hasField(fieldName)) {
            fieldName = exprText + i;
            ++i;
        }
        return fieldName;
    }

    @Override
    protected boolean isConstant(@Nullable Expression expression) {
        return expression == null || expression instanceof ConstantExpression || !this.constants.isEmpty() && this.constants.containsKey(expression) || this.parent != null && this.parent.isConstant(expression);
    }

    protected boolean isMethodDeterministic(Method method) {
        return this.allMethodsDeterministic(method.getDeclaringClass()) && !method.isAnnotationPresent(NonDeterministic.class) || method.isAnnotationPresent(Deterministic.class);
    }

    protected boolean isConstructorDeterministic(NewExpression newExpression) {
        Class klass = (Class)newExpression.type;
        Constructor constructor = DeterministicCodeOptimizer.getConstructor(klass);
        return this.allMethodsDeterministic(klass) || constructor != null && constructor.isAnnotationPresent(Deterministic.class);
    }

    private static <C> @Nullable Constructor<C> getConstructor(Class<C> klass) {
        try {
            return klass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    protected boolean allMethodsDeterministic(Class klass) {
        return DETERMINISTIC_CLASSES.contains(klass) || "org.apache.calcite.avatica.util.DateTimeUtils".equals(klass.getCanonicalName()) || klass.isAnnotationPresent(Deterministic.class);
    }

    @Override
    protected boolean hasField(String name) {
        return !this.fieldsByName.isEmpty() && this.fieldsByName.containsKey(name) || this.parent != null && this.parent.hasField(name);
    }

    @Override
    protected DeterministicCodeOptimizer goDeeper() {
        return new DeterministicCodeOptimizer(this);
    }
}

