/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import java.text.DecimalFormat;
import java.util.Formatter;
import java.util.ResourceBundle;

public class Messages {
    private static final String CODE = "WFOPENSSL";
    public static Messages MESSAGES = new Messages();
    private static final String MSG1 = Messages.formatCode(1);
    private static final String MSG2 = Messages.formatCode(2);
    private static final String MSG3 = Messages.formatCode(3);
    private static final String MSG4 = Messages.formatCode(4);
    private static final String MSG5 = Messages.formatCode(5);
    private static final String MSG6 = Messages.formatCode(6);
    private static final String MSG7 = Messages.formatCode(7);
    private static final String MSG8 = Messages.formatCode(8);
    private static final String MSG9 = Messages.formatCode(9);
    private static final String MSG10 = Messages.formatCode(10);
    private static final String MSG11 = Messages.formatCode(11);
    private static final String MSG12 = Messages.formatCode(12);
    private static final String MSG13 = Messages.formatCode(13);
    private static final String MSG14 = Messages.formatCode(14);
    private static final String MSG15 = Messages.formatCode(15);
    private static final String MSG16 = Messages.formatCode(16);
    private static final String MSG17 = Messages.formatCode(17);
    private static final String MSG18 = Messages.formatCode(18);
    private static final String MSG19 = Messages.formatCode(19);
    private static final String MSG20 = Messages.formatCode(20);
    private static final String MSG21 = Messages.formatCode(21);
    private static final String MSG22 = Messages.formatCode(22);
    private static final String MSG23 = Messages.formatCode(23);
    private static final String MSG24 = Messages.formatCode(24);
    private static final String MSG25 = Messages.formatCode(25);
    private static final String MSG26 = Messages.formatCode(26);
    private static final String MSG27 = Messages.formatCode(27);
    private static final String MSG28 = Messages.formatCode(28);
    private static final String MSG29 = Messages.formatCode(29);
    private static final String MSG30 = Messages.formatCode(30);
    private static final String MSG31 = Messages.formatCode(31);
    private static final String MSG32 = Messages.formatCode(32);
    private static final String MSG33 = Messages.formatCode(33);
    private static final String MSG34 = Messages.formatCode(34);
    private static final String MSG35 = Messages.formatCode(35);
    private static final String MSG36 = Messages.formatCode(36);
    private static final String MSG37 = Messages.formatCode(37);
    private static final String MSG38 = Messages.formatCode(38);
    private ResourceBundle properties = ResourceBundle.getBundle("org.wildfly.openssl.OpenSSLMessages");

    private static String formatCode(int i) {
        return CODE + new DecimalFormat("0000").format(i);
    }

    private Messages() {
    }

    private String interpolate(String messageid, Object ... arguments) {
        StringBuilder sb = new StringBuilder(messageid);
        sb.append(' ');
        new Formatter(sb).format(this.properties.getString(messageid), arguments);
        return sb.toString();
    }

    public String couldNotFindLibSSL(String systemProperty, String attempted) {
        return this.interpolate(MSG1, systemProperty, attempted);
    }

    public String openSSLVersion(String version) {
        return this.interpolate(MSG2, version);
    }

    public String couldNotFindLibCrypto(String systemProperty, String attempted) {
        return this.interpolate(MSG3, systemProperty, attempted);
    }

    public String noSslContext() {
        return this.interpolate(MSG4, new Object[0]);
    }

    public String sslWriteFailed(int sslWrote) {
        return this.interpolate(MSG5, sslWrote);
    }

    public String bufferIsNull() {
        return this.interpolate(MSG6, new Object[0]);
    }

    public String invalidOffset(int offset, int length, int arrayLength) {
        return this.interpolate(MSG7, offset, length, arrayLength);
    }

    public String readFromSSLFailed(long error, int lastPrimingReadResult, String err) {
        return this.interpolate(MSG8, error, lastPrimingReadResult, err);
    }

    public String inboundIsClosed() {
        return this.interpolate(MSG9, new Object[0]);
    }

    public String nullCipherSuites() {
        return this.interpolate(MSG10, new Object[0]);
    }

    public String emptyCipherSuiteList() {
        return this.interpolate(MSG11, new Object[0]);
    }

    public String failedCipherSuite(String cipherSuiteSpec) {
        return this.interpolate(MSG12, cipherSuiteSpec);
    }

    public String unsupportedProtocol(String p) {
        return this.interpolate(MSG13, p);
    }

    public String failedToInitializeCiphers() {
        return this.interpolate(MSG14, new Object[0]);
    }

    public String failedToMakeSslContext() {
        return this.interpolate(MSG15, new Object[0]);
    }

    public String failedToInitializeSslContext() {
        return this.interpolate(MSG16, new Object[0]);
    }

    public String ignoringSecondInit() {
        return this.interpolate(MSG17, new Object[0]);
    }

    public String couldNotFileSuitableKeyManager() {
        return this.interpolate(MSG18, new Object[0]);
    }

    public String keyManagerDoesNotContainValidCertificates() {
        return this.interpolate(MSG19, new Object[0]);
    }

    public String keyManagerIsMissing() {
        return this.interpolate(MSG20, new Object[0]);
    }

    public String trustManagerIsMissing() {
        return this.interpolate(MSG21, new Object[0]);
    }

    public String engineIsClosed() {
        return this.interpolate(MSG22, new Object[0]);
    }

    public String renegotiationNotSupported() {
        return this.interpolate(MSG23, new Object[0]);
    }

    public String oversidedPacket() {
        return this.interpolate(MSG24, new Object[0]);
    }

    public String bufferAlreadyFreed() {
        return this.interpolate(MSG25, new Object[0]);
    }

    public String bufferLeakDetected() {
        return this.interpolate(MSG26, new Object[0]);
    }

    public String nameWasNull() {
        return this.interpolate(MSG27, new Object[0]);
    }

    public String valueWasNull() {
        return this.interpolate(MSG28, new Object[0]);
    }

    public String unverifiedPeer() {
        return this.interpolate(MSG29, new Object[0]);
    }

    public String runningHandshakeWithBufferedData() {
        return this.interpolate(MSG30, new Object[0]);
    }

    public String connectionClosed() {
        return this.interpolate(MSG31, new Object[0]);
    }

    public String bufferOverflow() {
        return this.interpolate(MSG32, new Object[0]);
    }

    public String bufferUnderflow() {
        return this.interpolate(MSG33, new Object[0]);
    }

    public String unsupportedAddressType() {
        return this.interpolate(MSG34, new Object[0]);
    }

    public String streamIsClosed() {
        return this.interpolate(MSG35, new Object[0]);
    }

    public String unableToObtainPrivateKey() {
        return this.interpolate(MSG36, new Object[0]);
    }

    public String directBufferDeallocatorInitializationFailed() {
        return this.interpolate(MSG37, new Object[0]);
    }

    public String directBufferDeallocationFailed() {
        return this.interpolate(MSG38, new Object[0]);
    }
}

