/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import javax.annotation.Nullable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.impl.ActiveOperationContext;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

public class S3AOpContext
extends ActiveOperationContext {
    final boolean isS3GuardEnabled;
    final Invoker invoker;
    @Nullable
    final FileSystem.Statistics stats;
    @Nullable
    final Invoker s3guardInvoker;
    protected final FileStatus dstFileStatus;

    public S3AOpContext(boolean isS3GuardEnabled, Invoker invoker, @Nullable Invoker s3guardInvoker, @Nullable FileSystem.Statistics stats, S3AStatisticsContext instrumentation, FileStatus dstFileStatus) {
        super(S3AOpContext.newOperationId(), instrumentation, null);
        Preconditions.checkNotNull(invoker, "Null invoker arg");
        Preconditions.checkNotNull(instrumentation, "Null instrumentation arg");
        Preconditions.checkNotNull(dstFileStatus, "Null dstFileStatus arg");
        this.isS3GuardEnabled = isS3GuardEnabled;
        Preconditions.checkArgument(!isS3GuardEnabled || s3guardInvoker != null, "S3Guard invoker required: S3Guard is enabled.");
        this.invoker = invoker;
        this.s3guardInvoker = s3guardInvoker;
        this.stats = stats;
        this.dstFileStatus = dstFileStatus;
    }

    public S3AOpContext(boolean isS3GuardEnabled, Invoker invoker, @Nullable FileSystem.Statistics stats, S3AStatisticsContext instrumentation, FileStatus dstFileStatus) {
        this(isS3GuardEnabled, invoker, null, stats, instrumentation, dstFileStatus);
    }

    public boolean isS3GuardEnabled() {
        return this.isS3GuardEnabled;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    @Nullable
    public FileSystem.Statistics getStats() {
        return this.stats;
    }

    @Nullable
    public Invoker getS3guardInvoker() {
        return this.s3guardInvoker;
    }

    public FileStatus getDstFileStatus() {
        return this.dstFileStatus;
    }
}

