/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common.token;

import com.amazonaws.services.securitytoken.model.Credentials;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.security.token.DelegationTokenReceiver;
import org.apache.flink.fs.s3.common.token.DynamicTemporaryAWSCredentialsProvider;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractS3DelegationTokenReceiver
implements DelegationTokenReceiver {
    public static final String PROVIDER_CONFIG_NAME = "fs.s3a.aws.credentials.provider";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractS3DelegationTokenReceiver.class);
    @Nullable
    @VisibleForTesting
    static volatile Credentials credentials;
    @Nullable
    @VisibleForTesting
    static volatile String region;

    public static void updateHadoopConfig(org.apache.hadoop.conf.Configuration hadoopConfig) {
        LOG.info("Updating Hadoop configuration");
        Object providers = hadoopConfig.get(PROVIDER_CONFIG_NAME, "");
        if (!((String)providers).contains(DynamicTemporaryAWSCredentialsProvider.NAME)) {
            if (((String)providers).isEmpty()) {
                LOG.debug("Setting provider");
                providers = DynamicTemporaryAWSCredentialsProvider.NAME;
            } else {
                providers = DynamicTemporaryAWSCredentialsProvider.NAME + "," + (String)providers;
                LOG.debug("Prepending provider, new providers value: {}", providers);
            }
            hadoopConfig.set(PROVIDER_CONFIG_NAME, (String)providers);
        } else {
            LOG.debug("Provider already exists");
        }
        if (!StringUtils.isNullOrWhitespaceOnly((String)region)) {
            LOG.debug("Setting region");
            hadoopConfig.set("fs.s3a.endpoint.region", region);
        }
        LOG.info("Updated Hadoop configuration successfully");
    }

    public void init(Configuration configuration) {
        region = configuration.getString(String.format("%s.%s.region", "security.delegation.token.provider", this.serviceName()), null);
        if (!StringUtils.isNullOrWhitespaceOnly((String)region)) {
            LOG.debug("Region: " + region);
        }
    }

    public void onNewTokensObtained(byte[] tokens) throws Exception {
        LOG.info("Updating session credentials");
        credentials = (Credentials)InstantiationUtil.deserializeObject((byte[])tokens, (ClassLoader)AbstractS3DelegationTokenReceiver.class.getClassLoader());
        LOG.info("Session credentials updated successfully with access key: {} expiration: {}", (Object)credentials.getAccessKeyId(), (Object)credentials.getExpiration());
    }

    @Nullable
    public static Credentials getCredentials() {
        return credentials;
    }
}

