/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kms.model.RotationsListEntry;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListKeyRotationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<RotationsListEntry> rotations;
    private String nextMarker;
    private Boolean truncated;

    public List<RotationsListEntry> getRotations() {
        if (this.rotations == null) {
            this.rotations = new SdkInternalList();
        }
        return this.rotations;
    }

    public void setRotations(Collection<RotationsListEntry> rotations) {
        if (rotations == null) {
            this.rotations = null;
            return;
        }
        this.rotations = new SdkInternalList<RotationsListEntry>(rotations);
    }

    public ListKeyRotationsResult withRotations(RotationsListEntry ... rotations) {
        if (this.rotations == null) {
            this.setRotations(new SdkInternalList<RotationsListEntry>(rotations.length));
        }
        for (RotationsListEntry ele : rotations) {
            this.rotations.add(ele);
        }
        return this;
    }

    public ListKeyRotationsResult withRotations(Collection<RotationsListEntry> rotations) {
        this.setRotations(rotations);
        return this;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public ListKeyRotationsResult withNextMarker(String nextMarker) {
        this.setNextMarker(nextMarker);
        return this;
    }

    public void setTruncated(Boolean truncated) {
        this.truncated = truncated;
    }

    public Boolean getTruncated() {
        return this.truncated;
    }

    public ListKeyRotationsResult withTruncated(Boolean truncated) {
        this.setTruncated(truncated);
        return this;
    }

    public Boolean isTruncated() {
        return this.truncated;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRotations() != null) {
            sb.append("Rotations: ").append(this.getRotations()).append(",");
        }
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: ").append(this.getNextMarker()).append(",");
        }
        if (this.getTruncated() != null) {
            sb.append("Truncated: ").append(this.getTruncated());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeyRotationsResult)) {
            return false;
        }
        ListKeyRotationsResult other = (ListKeyRotationsResult)obj;
        if (other.getRotations() == null ^ this.getRotations() == null) {
            return false;
        }
        if (other.getRotations() != null && !other.getRotations().equals(this.getRotations())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.getTruncated() == null ^ this.getTruncated() == null) {
            return false;
        }
        return other.getTruncated() == null || other.getTruncated().equals(this.getTruncated());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRotations() == null ? 0 : this.getRotations().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode = 31 * hashCode + (this.getTruncated() == null ? 0 : this.getTruncated().hashCode());
        return hashCode;
    }

    public ListKeyRotationsResult clone() {
        try {
            return (ListKeyRotationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

