/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.gs.writer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.fs.gs.writer.GSCommitRecoverable;
import org.apache.flink.fs.gs.writer.GSCommitRecoverableSerializer;
import org.apache.flink.fs.gs.writer.GSResumeRecoverable;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GSResumeRecoverableSerializer
implements SimpleVersionedSerializer<GSResumeRecoverable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GSResumeRecoverableSerializer.class);
    private static final int SERIALIZER_VERSION = 1;
    public static final GSResumeRecoverableSerializer INSTANCE = new GSResumeRecoverableSerializer();

    private GSResumeRecoverableSerializer() {
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(GSResumeRecoverable recoverable) throws IOException {
        LOGGER.trace("Serializing recoverable {}", (Object)recoverable);
        Preconditions.checkNotNull((Object)recoverable);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            try (DataOutputStream dataOutputStream = new DataOutputStream(outputStream);){
                GSCommitRecoverableSerializer.serializeCommitRecoverable(recoverable, dataOutputStream);
                dataOutputStream.writeLong(recoverable.position);
                dataOutputStream.writeBoolean(recoverable.closed);
            }
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    public GSResumeRecoverable deserialize(int version, byte[] serialized) throws IOException {
        Preconditions.checkArgument((version > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)serialized);
        if (version > 1) {
            throw new IOException(String.format("Serialized data with version %d cannot be read by serializer with version %d", version, 1));
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(serialized);){
            GSResumeRecoverable gSResumeRecoverable;
            try (DataInputStream dataInputStream = new DataInputStream(inputStream);){
                GSCommitRecoverable commitRecoverable = GSCommitRecoverableSerializer.deserializeCommitRecoverable(dataInputStream);
                long position = dataInputStream.readLong();
                boolean closed = dataInputStream.readBoolean();
                GSResumeRecoverable resumeRecoverable = new GSResumeRecoverable(commitRecoverable.finalBlobIdentifier, commitRecoverable.componentObjectIds, position, closed);
                LOGGER.trace("Deserialized resume recoverable {}", (Object)resumeRecoverable);
                gSResumeRecoverable = resumeRecoverable;
            }
            return gSResumeRecoverable;
        }
    }
}

