/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.List;
import java.util.stream.Collectors;

final class ApiFutureUtils {
    private ApiFutureUtils() {
    }

    static <T> T await(ApiFuture<T> future) {
        try {
            return Futures.getUnchecked(future);
        }
        catch (UncheckedExecutionException exception) {
            if (exception.getCause() instanceof RuntimeException) {
                throw (RuntimeException)exception.getCause();
            }
            throw exception;
        }
    }

    static <T> ApiFuture<T> just(T value) {
        return ApiFutures.immediateFuture(value);
    }

    static <T> ApiFuture<List<T>> quietAllAsList(List<ApiFuture<T>> futures) {
        List pending = futures.stream().map(ApiFutureUtils::smuggleThrowable).collect(Collectors.toList());
        ApiFuture futureValues = ApiFutures.allAsList(pending);
        return ApiFutureUtils.unwrapSmuggling(futureValues);
    }

    private static <T> ApiFuture<T> smuggleThrowable(ApiFuture<T> future) {
        return ApiFutures.catchingAsync(future, Throwable.class, throwable -> ApiFutures.immediateFailedFuture(new SmugglingException((Throwable)throwable)), MoreExecutors.directExecutor());
    }

    private static <T> ApiFuture<T> unwrapSmuggling(ApiFuture<T> future) {
        return ApiFutures.catchingAsync(future, SmugglingException.class, smuggled -> ApiFutures.immediateFailedFuture(((SmugglingException)smuggled).smuggledCause), MoreExecutors.directExecutor());
    }

    private static final class SmugglingException
    extends RuntimeException {
        private final Throwable smuggledCause;

        private SmugglingException(Throwable smuggledCause) {
            super("");
            this.smuggledCause = smuggledCause;
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object other) {
            return other.getClass().equals(this.getClass());
        }
    }

    @FunctionalInterface
    static interface OnFailureApiFutureCallback<T>
    extends ApiFutureCallback<T> {
        @Override
        default public void onSuccess(T result) {
        }
    }

    @FunctionalInterface
    static interface OnSuccessApiFutureCallback<T>
    extends ApiFutureCallback<T> {
        @Override
        default public void onFailure(Throwable t) {
        }
    }
}

