/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageTracingFields;
import com.google.cloud.hadoop.gcsio.GrpcStreamType;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.GoogleLogger;
import com.google.gson.Gson;
import com.google.protobuf.MessageLite;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.StartResumableWriteResponse;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientStreamTracer;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import javax.annotation.Nonnull;

@VisibleForTesting
public class GoogleCloudStorageClientGrpcTracingInterceptor
implements ClientInterceptor {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String IDEMPOTENCY_TOKEN_HEADER = "x-goog-gcs-idempotency-token";
    private static final String DEFAULT_INVOCATION_ID = "NOT-FOUND";
    private static final Metadata.Key<String> idempotencyKey = Metadata.Key.of("x-goog-gcs-idempotency-token", Metadata.ASCII_STRING_MARSHALLER);

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        String rpcMethodName = method.getBareMethodName();
        final TrackingStreamTracer streamTracer = this.getStreamTracer(rpcMethodName);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions.withStreamTracerFactory(new ClientStreamTracer.Factory(){

            @Override
            public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
                return streamTracer;
            }
        }))){

            @Override
            public void sendMessage(ReqT message) {
                try {
                    streamTracer.traceRequestMessage((MessageLite)message);
                }
                finally {
                    super.sendMessage(message);
                }
            }

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    @Override
                    public void onMessage(RespT message) {
                        try {
                            streamTracer.traceResponseMessage((MessageLite)message);
                        }
                        finally {
                            super.onMessage(message);
                        }
                    }

                    @Override
                    public void onClose(Status status, Metadata trailers) {
                        try {
                            streamTracer.statusOnClose(status);
                        }
                        finally {
                            super.onClose(status, trailers);
                        }
                    }
                }, headers);
            }
        };
    }

    private TrackingStreamTracer getStreamTracer(String rpcMethodName) {
        GrpcStreamType type = GrpcStreamType.getTypeFromName(rpcMethodName);
        switch (type) {
            case START_RESUMABLE_WRITE: {
                return new StartResumableUploadStreamTracer(rpcMethodName);
            }
            case WRITE_OBJECT: {
                return new WriteObjectStreamTracer(rpcMethodName);
            }
            case READ_OBJECT: {
                return new ReadObjectStreamTracer(rpcMethodName);
            }
        }
        return new TrackingStreamTracer(rpcMethodName);
    }

    private class ReadObjectStreamTracer
    extends TrackingStreamTracer {
        private StorageResourceId resourceId;
        private long readOffset;
        private long readLimit;
        private long totalBytesRead;

        ReadObjectStreamTracer(String rpcMethod) {
            super(rpcMethod);
            this.totalBytesRead = 0L;
        }

        private void updateReadRequestContext(ReadObjectRequest request) {
            this.resourceId = new StorageResourceId(request.getBucket(), request.getObject(), request.getGeneration());
            this.readOffset = request.getReadOffset();
            this.readLimit = request.getReadLimit();
        }

        @Override
        public void logRequestMessage(MessageLite message) {
            ReadObjectRequest request = (ReadObjectRequest)message;
            this.updateReadRequestContext(request);
            ((GoogleLogger.Api)logger.atInfo()).log("%s", this.toJson(this.getRequestTrackingInfo().put(GoogleCloudStorageTracingFields.RESOURCE.name, this.resourceId).put(GoogleCloudStorageTracingFields.READ_OFFSET.name, this.readOffset).put(GoogleCloudStorageTracingFields.READ_LIMIT.name, this.readLimit).build()));
        }

        @Override
        public void logResponseMessage(MessageLite message) {
            ReadObjectResponse response = (ReadObjectResponse)message;
            int bytesRead = response.getChecksummedData().getContent().size();
            ((GoogleLogger.Api)logger.atInfo()).log("%s", this.toJson(this.getResponseTrackingInfo().put(GoogleCloudStorageTracingFields.RESOURCE.name, this.resourceId).put(GoogleCloudStorageTracingFields.READ_OFFSET.name, this.readOffset).put(GoogleCloudStorageTracingFields.READ_LIMIT.name, this.readLimit).put(GoogleCloudStorageTracingFields.REQUEST_START_OFFSET.name, this.totalBytesRead).put(GoogleCloudStorageTracingFields.BYTES_READ.name, bytesRead).build()));
            this.totalBytesRead += (long)bytesRead;
        }
    }

    private class WriteObjectStreamTracer
    extends TrackingStreamTracer {
        private String streamUploadId;

        WriteObjectStreamTracer(String rpcMethod) {
            super(rpcMethod);
            this.streamUploadId = null;
        }

        @Override
        public void logRequestMessage(MessageLite message) {
            WriteObjectRequest request = (WriteObjectRequest)message;
            String uploadId = request.getUploadId();
            if (!Strings.isNullOrEmpty(uploadId)) {
                this.updateUploadId(request.getUploadId());
            }
            ((GoogleLogger.Api)logger.atInfo()).log("%s", this.toJson(this.getRequestTrackingInfo().put(GoogleCloudStorageTracingFields.UPLOAD_ID.name, request.getUploadId()).put(GoogleCloudStorageTracingFields.WRITE_OFFSET.name, request.getWriteOffset()).put(GoogleCloudStorageTracingFields.FINALIZE_WRITE.name, request.getFinishWrite()).put(GoogleCloudStorageTracingFields.CONTENT_LENGTH.name, request.getChecksummedData().getContent().size()).build()));
        }

        @Override
        public void logResponseMessage(MessageLite message) {
            WriteObjectResponse response = (WriteObjectResponse)message;
            ((GoogleLogger.Api)logger.atInfo()).log("%s", this.toJson(this.getResponseTrackingInfo().put(GoogleCloudStorageTracingFields.UPLOAD_ID.name, this.streamUploadId).put(GoogleCloudStorageTracingFields.PERSISTED_SIZE.name, response.getPersistedSize()).build()));
        }

        private void updateUploadId(@Nonnull String uploadId) {
            if (this.streamUploadId == null) {
                this.streamUploadId = uploadId;
            }
            Preconditions.checkState(uploadId.equals(this.streamUploadId), String.format("Write stream should have unique uploadId associated with each chunk request. Expected was %s got %s", this.streamUploadId, uploadId));
        }
    }

    private class StartResumableUploadStreamTracer
    extends TrackingStreamTracer {
        private StorageResourceId resourceId;

        StartResumableUploadStreamTracer(String rpcMethod) {
            super(rpcMethod);
        }

        @Override
        public void logRequestMessage(MessageLite message) {
            StartResumableWriteRequest request = (StartResumableWriteRequest)message;
            this.resourceId = new StorageResourceId(request.getWriteObjectSpec().getResource().getBucket(), request.getWriteObjectSpec().getResource().getName(), request.getWriteObjectSpec().getIfGenerationMatch());
            ((GoogleLogger.Api)logger.atInfo()).log("%s", this.toJson(this.getRequestTrackingInfo().put(GoogleCloudStorageTracingFields.RESOURCE.name, this.resourceId).build()));
        }

        @Override
        public void logResponseMessage(MessageLite message) {
            StartResumableWriteResponse response = (StartResumableWriteResponse)message;
            ((GoogleLogger.Api)logger.atInfo()).log("%s", this.toJson(this.getResponseTrackingInfo().put(GoogleCloudStorageTracingFields.RESOURCE.name, this.resourceId).put(GoogleCloudStorageTracingFields.UPLOAD_ID.name, response.getUploadId()).build()));
        }
    }

    private class TrackingStreamTracer
    extends ClientStreamTracer {
        private final Gson gson = new Gson();
        private final String rpcMethod;
        private Metadata headers;
        protected int requestMessageCounter = 0;
        protected int responseMessageCounter = 0;

        TrackingStreamTracer(String rpcMethod) {
            this.rpcMethod = rpcMethod;
        }

        private void updateRequestCounter() {
            ++this.requestMessageCounter;
        }

        private void updateResponseCounter() {
            ++this.responseMessageCounter;
        }

        public void traceRequestMessage(MessageLite message) {
            this.logRequestMessage(message);
            this.updateRequestCounter();
        }

        public void traceResponseMessage(MessageLite message) {
            this.logResponseMessage(message);
            this.updateResponseCounter();
        }

        public void logRequestMessage(MessageLite message) {
        }

        public void logResponseMessage(MessageLite message) {
        }

        public void statusOnClose(Status status) {
            ((GoogleLogger.Api)logger.atInfo()).log("%s", this.toJson(this.getRequestContext().put(GoogleCloudStorageTracingFields.STATUS.name, status).put(GoogleCloudStorageTracingFields.STREAM_OPERATION.name, "onClose").build()));
        }

        @Override
        public void streamCreated(Attributes transportAttrs, Metadata headers) {
            this.headers = headers;
            super.streamCreated(transportAttrs, headers);
        }

        protected ImmutableMap.Builder<String, Object> getRequestTrackingInfo() {
            return this.getRequestContext().put(GoogleCloudStorageTracingFields.REQUEST_COUNTER.name, this.requestMessageCounter).put(GoogleCloudStorageTracingFields.STREAM_OPERATION.name, "request");
        }

        protected ImmutableMap.Builder<String, Object> getResponseTrackingInfo() {
            return this.getRequestContext().put(GoogleCloudStorageTracingFields.RESPONSE_COUNTER.name, this.responseMessageCounter).put(GoogleCloudStorageTracingFields.STREAM_OPERATION.name, "response");
        }

        protected String toJson(ImmutableMap<String, Object> eventDetails) {
            return this.gson.toJson(eventDetails);
        }

        protected String getInvocationId() {
            return this.headers != null ? (String)this.headers.get(idempotencyKey) : GoogleCloudStorageClientGrpcTracingInterceptor.DEFAULT_INVOCATION_ID;
        }

        private ImmutableMap.Builder<String, Object> getRequestContext() {
            return new ImmutableMap.Builder<String, String>().put(GoogleCloudStorageTracingFields.RPC_METHOD.name, this.rpcMethod).put(GoogleCloudStorageTracingFields.IDEMPOTENCY_TOKEN.name, this.getInvocationId());
        }
    }
}

