/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseHandler;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.parser.RequestMarshallers;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.ExceptionFactory;
import com.aliyun.oss.internal.OSSOperation;
import com.aliyun.oss.internal.OSSRequestMessageBuilder;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.ResponseParsers;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.AccessMonitor;
import com.aliyun.oss.model.AddBucketCnameRequest;
import com.aliyun.oss.model.AddBucketCnameResult;
import com.aliyun.oss.model.AddBucketReplicationRequest;
import com.aliyun.oss.model.AsyncFetchTaskConfiguration;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.BucketInfo;
import com.aliyun.oss.model.BucketList;
import com.aliyun.oss.model.BucketLoggingResult;
import com.aliyun.oss.model.BucketMetadata;
import com.aliyun.oss.model.BucketProcess;
import com.aliyun.oss.model.BucketQosInfo;
import com.aliyun.oss.model.BucketReferer;
import com.aliyun.oss.model.BucketReplicationProgress;
import com.aliyun.oss.model.BucketStat;
import com.aliyun.oss.model.BucketVersioningConfiguration;
import com.aliyun.oss.model.BucketWebsiteResult;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CnameConfiguration;
import com.aliyun.oss.model.CompleteBucketWormRequest;
import com.aliyun.oss.model.CreateBucketCnameTokenRequest;
import com.aliyun.oss.model.CreateBucketCnameTokenResult;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.CreateBucketVpcipRequest;
import com.aliyun.oss.model.CreateVpcipRequest;
import com.aliyun.oss.model.CreateVpcipResult;
import com.aliyun.oss.model.DeleteBucketCnameRequest;
import com.aliyun.oss.model.DeleteBucketInventoryConfigurationRequest;
import com.aliyun.oss.model.DeleteBucketReplicationRequest;
import com.aliyun.oss.model.DeleteBucketVpcipRequest;
import com.aliyun.oss.model.DeleteVpcipRequest;
import com.aliyun.oss.model.DescribeRegionsRequest;
import com.aliyun.oss.model.DescribeRegionsResult;
import com.aliyun.oss.model.DoMetaQueryRequest;
import com.aliyun.oss.model.DoMetaQueryResult;
import com.aliyun.oss.model.ExtendBucketWormRequest;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.GetAsyncFetchTaskRequest;
import com.aliyun.oss.model.GetAsyncFetchTaskResult;
import com.aliyun.oss.model.GetBucketCallbackPolicyResult;
import com.aliyun.oss.model.GetBucketCnameTokenRequest;
import com.aliyun.oss.model.GetBucketCnameTokenResult;
import com.aliyun.oss.model.GetBucketImageResult;
import com.aliyun.oss.model.GetBucketInventoryConfigurationRequest;
import com.aliyun.oss.model.GetBucketInventoryConfigurationResult;
import com.aliyun.oss.model.GetBucketPolicyResult;
import com.aliyun.oss.model.GetBucketReplicationProgressRequest;
import com.aliyun.oss.model.GetBucketRequestPaymentResult;
import com.aliyun.oss.model.GetBucketResourceGroupResult;
import com.aliyun.oss.model.GetBucketWormResult;
import com.aliyun.oss.model.GetImageStyleResult;
import com.aliyun.oss.model.GetMetaQueryStatusResult;
import com.aliyun.oss.model.ImageProcess;
import com.aliyun.oss.model.InitiateBucketWormRequest;
import com.aliyun.oss.model.InitiateBucketWormResult;
import com.aliyun.oss.model.LifecycleRule;
import com.aliyun.oss.model.ListBucketInventoryConfigurationsRequest;
import com.aliyun.oss.model.ListBucketInventoryConfigurationsResult;
import com.aliyun.oss.model.ListBucketsRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.ListObjectsV2Request;
import com.aliyun.oss.model.ListObjectsV2Result;
import com.aliyun.oss.model.ListVersionsRequest;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.Payer;
import com.aliyun.oss.model.PutBucketAccessMonitorRequest;
import com.aliyun.oss.model.PutBucketImageRequest;
import com.aliyun.oss.model.PutImageStyleRequest;
import com.aliyun.oss.model.ReplicationRule;
import com.aliyun.oss.model.ServerSideEncryptionConfiguration;
import com.aliyun.oss.model.SetAsyncFetchTaskRequest;
import com.aliyun.oss.model.SetAsyncFetchTaskResult;
import com.aliyun.oss.model.SetBucketAclRequest;
import com.aliyun.oss.model.SetBucketCallbackPolicyRequest;
import com.aliyun.oss.model.SetBucketEncryptionRequest;
import com.aliyun.oss.model.SetBucketInventoryConfigurationRequest;
import com.aliyun.oss.model.SetBucketLifecycleRequest;
import com.aliyun.oss.model.SetBucketLoggingRequest;
import com.aliyun.oss.model.SetBucketPolicyRequest;
import com.aliyun.oss.model.SetBucketProcessRequest;
import com.aliyun.oss.model.SetBucketQosInfoRequest;
import com.aliyun.oss.model.SetBucketRefererRequest;
import com.aliyun.oss.model.SetBucketRequestPaymentRequest;
import com.aliyun.oss.model.SetBucketResourceGroupRequest;
import com.aliyun.oss.model.SetBucketStorageCapacityRequest;
import com.aliyun.oss.model.SetBucketTaggingRequest;
import com.aliyun.oss.model.SetBucketTransferAccelerationRequest;
import com.aliyun.oss.model.SetBucketVersioningRequest;
import com.aliyun.oss.model.SetBucketWebsiteRequest;
import com.aliyun.oss.model.Style;
import com.aliyun.oss.model.TagSet;
import com.aliyun.oss.model.TransferAcceleration;
import com.aliyun.oss.model.UserQos;
import com.aliyun.oss.model.UserQosInfo;
import com.aliyun.oss.model.VersionListing;
import com.aliyun.oss.model.VoidResult;
import com.aliyun.oss.model.VpcPolicy;
import com.aliyun.oss.model.Vpcip;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OSSBucketOperation
extends OSSOperation {
    public OSSBucketOperation(ServiceClient client, CredentialsProvider credsProvider) {
        super(client, credsProvider);
    }

    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(createBucketRequest, "createBucketRequest");
        String bucketName = createBucketRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameCreationValid(bucketName);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addOptionalACLHeader(headers, createBucketRequest.getCannedACL());
        OSSBucketOperation.addOptionalHnsHeader(headers, createBucketRequest.getHnsStatus());
        OSSBucketOperation.addOptionalResourceGroupIdHeader(headers, createBucketRequest.getResourceGroupId());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(createBucketRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setHeaders(headers).setInputStreamWithLength(RequestMarshallers.createBucketRequestMarshaller.marshall(createBucketRequest)).setOriginalRequest(createBucketRequest).build();
        ResponseMessage result = this.doOperation(request, emptyResponseParser, bucketName, null);
        return new Bucket(bucketName, result.getRequestId());
    }

    public VoidResult deleteBucket(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.DELETE).setBucket(bucketName).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public List<Bucket> listBuckets() throws OSSException, ClientException {
        BucketList bucketList = this.listBuckets(new ListBucketsRequest(null, null, null));
        List<Bucket> buckets = bucketList.getBucketList();
        while (bucketList.isTruncated()) {
            bucketList = this.listBuckets(new ListBucketsRequest(null, bucketList.getNextMarker(), null));
            buckets.addAll(bucketList.getBucketList());
        }
        return buckets;
    }

    public BucketList listBuckets(ListBucketsRequest listBucketRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(listBucketRequest, "listBucketRequest");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (listBucketRequest.getPrefix() != null) {
            params.put("prefix", listBucketRequest.getPrefix());
        }
        if (listBucketRequest.getMarker() != null) {
            params.put("marker", listBucketRequest.getMarker());
        }
        if (listBucketRequest.getMaxKeys() != null) {
            params.put("max-keys", Integer.toString(listBucketRequest.getMaxKeys()));
        }
        if (listBucketRequest.getBid() != null) {
            params.put("bid", listBucketRequest.getBid());
        }
        if (listBucketRequest.getTagKey() != null && listBucketRequest.getTagValue() != null) {
            params.put("tag-key", listBucketRequest.getTagKey());
            params.put("tag-value", listBucketRequest.getTagValue());
        }
        if (listBucketRequest.getParameters() != null && listBucketRequest.getParameters().containsKey("regionList")) {
            params.put("regionList", listBucketRequest.getParameters().get("regionList"));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addOptionalResourceGroupIdHeader(headers, listBucketRequest.getResourceGroupId());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(listBucketRequest)).setMethod(HttpMethod.GET).setHeaders(headers).setParameters(params).setOriginalRequest(listBucketRequest).build();
        return this.doOperation(request, ResponseParsers.listBucketResponseParser, null, null, true);
    }

    public VoidResult setBucketAcl(SetBucketAclRequest setBucketAclRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketAclRequest, "setBucketAclRequest");
        String bucketName = setBucketAclRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addOptionalACLHeader(headers, setBucketAclRequest.getCannedACL());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("acl", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setBucketAclRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setHeaders(headers).setParameters(params).setOriginalRequest(setBucketAclRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public AccessControlList getBucketAcl(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("acl", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketAclResponseParser, bucketName, null, true);
    }

    public BucketMetadata getBucketMetadata(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.HEAD).setBucket(bucketName).setOriginalRequest(genericRequest).build();
        ArrayList<ResponseHandler> reponseHandlers = new ArrayList<ResponseHandler>();
        reponseHandlers.add(new ResponseHandler(){

            @Override
            public void handle(ResponseMessage response) throws ServiceException, ClientException {
                if (response.getStatusCode() == 404) {
                    OSSUtils.safeCloseResponse(response);
                    throw ExceptionFactory.createOSSException(response.getHeaders().get("x-oss-request-id"), "NoSuchBucket", OSSUtils.OSS_RESOURCE_MANAGER.getString("NoSuchBucket"));
                }
            }
        });
        return this.doOperation(request, ResponseParsers.getBucketMetadataResponseParser, bucketName, null, true, null, reponseHandlers);
    }

    public VoidResult setBucketReferer(SetBucketRefererRequest setBucketRefererRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketRefererRequest, "setBucketRefererRequest");
        String bucketName = setBucketRefererRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        BucketReferer referer = setBucketRefererRequest.getReferer();
        if (referer == null) {
            referer = new BucketReferer();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("referer", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setBucketRefererRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.bucketRefererMarshaller.marshall(referer)).setOriginalRequest(setBucketRefererRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public BucketReferer getBucketReferer(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("referer", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketRefererResponseParser, bucketName, null, true);
    }

    public String getBucketLocation(GenericRequest genericRequest) {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("location", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketLocationResponseParser, bucketName, null, true);
    }

    public boolean doesBucketExists(GenericRequest genericRequest) throws OSSException, ClientException {
        block2: {
            CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
            String bucketName = genericRequest.getBucketName();
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            OSSUtils.ensureBucketNameValid(bucketName);
            try {
                this.getBucketAcl(new GenericRequest(bucketName));
            }
            catch (OSSException oe) {
                if (!oe.getErrorCode().equals("NoSuchBucket")) break block2;
                return false;
            }
        }
        return true;
    }

    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(listObjectsRequest, "listObjectsRequest");
        String bucketName = listObjectsRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        OSSBucketOperation.populateListObjectsRequestParameters(listObjectsRequest, params);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.populateRequestPayerHeader(headers, listObjectsRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(listObjectsRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setHeaders(headers).setParameters(params).setOriginalRequest(listObjectsRequest).build();
        return this.doOperation(request, ResponseParsers.listObjectsReponseParser, bucketName, null, true);
    }

    public ListObjectsV2Result listObjectsV2(ListObjectsV2Request listObjectsV2Request) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(listObjectsV2Request, "listObjectsRequest");
        String bucketName = listObjectsV2Request.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        OSSBucketOperation.populateListObjectsV2RequestParameters(listObjectsV2Request, params);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.populateRequestPayerHeader(headers, listObjectsV2Request.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(listObjectsV2Request)).setMethod(HttpMethod.GET).setBucket(bucketName).setHeaders(headers).setParameters(params).setOriginalRequest(listObjectsV2Request).build();
        return this.doOperation(request, ResponseParsers.listObjectsV2ResponseParser, bucketName, null, true);
    }

    public VersionListing listVersions(ListVersionsRequest listVersionsRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(listVersionsRequest, "listVersionsRequest");
        String bucketName = listVersionsRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        OSSBucketOperation.populateListVersionsRequestParameters(listVersionsRequest, params);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.populateRequestPayerHeader(headers, listVersionsRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(listVersionsRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setHeaders(headers).setParameters(params).setOriginalRequest(listVersionsRequest).build();
        return this.doOperation(request, ResponseParsers.listVersionsReponseParser, bucketName, null, true);
    }

    public VoidResult setBucketLogging(SetBucketLoggingRequest setBucketLoggingRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketLoggingRequest, "setBucketLoggingRequest");
        String bucketName = setBucketLoggingRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("logging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setBucketLoggingRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.setBucketLoggingRequestMarshaller.marshall(setBucketLoggingRequest)).setOriginalRequest(setBucketLoggingRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public VoidResult putBucketImage(PutBucketImageRequest putBucketImageRequest) {
        CodingUtils.assertParameterNotNull(putBucketImageRequest, "putBucketImageRequest");
        String bucketName = putBucketImageRequest.GetBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("img", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(putBucketImageRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setOriginalRequest(putBucketImageRequest).setInputStreamWithLength(RequestMarshallers.putBucketImageRequestMarshaller.marshall(putBucketImageRequest)).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public GetBucketImageResult getBucketImage(String bucketName, GenericRequest genericRequest) {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("img", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketImageResponseParser, bucketName, null, true);
    }

    public VoidResult deleteBucketImage(String bucketName, GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("img", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public VoidResult putImageStyle(PutImageStyleRequest putImageStyleRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(putImageStyleRequest, "putImageStyleRequest");
        String bucketName = putImageStyleRequest.GetBucketName();
        String styleName = putImageStyleRequest.GetStyleName();
        CodingUtils.assertParameterNotNull(styleName, "styleName");
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("style", null);
        params.put("styleName", styleName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(putImageStyleRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setOriginalRequest(putImageStyleRequest).setInputStreamWithLength(RequestMarshallers.putImageStyleRequestMarshaller.marshall(putImageStyleRequest)).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public VoidResult deleteImageStyle(String bucketName, String styleName, GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(styleName, "styleName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("style", null);
        params.put("styleName", styleName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public GetImageStyleResult getImageStyle(String bucketName, String styleName, GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(styleName, "styleName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("style", null);
        params.put("styleName", styleName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getImageStyleResponseParser, bucketName, null, true);
    }

    public List<Style> listImageStyle(String bucketName, GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("style", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.listImageStyleResponseParser, bucketName, null, true);
    }

    public VoidResult setBucketProcess(SetBucketProcessRequest setBucketProcessRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketProcessRequest, "setBucketProcessRequest");
        ImageProcess imageProcessConf = setBucketProcessRequest.getImageProcess();
        CodingUtils.assertParameterNotNull(imageProcessConf, "imageProcessConf");
        String bucketName = setBucketProcessRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processConfiguration", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setBucketProcessRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.bucketImageProcessConfMarshaller.marshall(imageProcessConf)).setOriginalRequest(setBucketProcessRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public BucketProcess getBucketProcess(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processConfiguration", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketImageProcessConfResponseParser, bucketName, null, true);
    }

    public BucketLoggingResult getBucketLogging(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("logging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketLoggingResponseParser, bucketName, null, true);
    }

    public VoidResult deleteBucketLogging(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("logging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public VoidResult setBucketWebsite(SetBucketWebsiteRequest setBucketWebSiteRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketWebSiteRequest, "setBucketWebSiteRequest");
        String bucketName = setBucketWebSiteRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        if (setBucketWebSiteRequest.getIndexDocument() == null && setBucketWebSiteRequest.getErrorDocument() == null && setBucketWebSiteRequest.getRoutingRules().size() == 0) {
            throw new IllegalArgumentException(String.format("IndexDocument/ErrorDocument/RoutingRules must have one", new Object[0]));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("website", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setBucketWebSiteRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.setBucketWebsiteRequestMarshaller.marshall(setBucketWebSiteRequest)).setOriginalRequest(setBucketWebSiteRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public BucketWebsiteResult getBucketWebsite(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("website", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketWebsiteResponseParser, bucketName, null, true);
    }

    public VoidResult deleteBucketWebsite(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("website", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public VoidResult setBucketLifecycle(SetBucketLifecycleRequest setBucketLifecycleRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketLifecycleRequest, "setBucketLifecycleRequest");
        String bucketName = setBucketLifecycleRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lifecycle", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setBucketLifecycleRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.setBucketLifecycleRequestMarshaller.marshall(setBucketLifecycleRequest)).setOriginalRequest(setBucketLifecycleRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public List<LifecycleRule> getBucketLifecycle(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lifecycle", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketLifecycleResponseParser, bucketName, null, true);
    }

    public VoidResult deleteBucketLifecycle(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lifecycle", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public VoidResult setBucketTagging(SetBucketTaggingRequest setBucketTaggingRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketTaggingRequest, "setBucketTaggingRequest");
        String bucketName = setBucketTaggingRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tagging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setBucketTaggingRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.setBucketTaggingRequestMarshaller.marshall(setBucketTaggingRequest)).setOriginalRequest(setBucketTaggingRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public TagSet getBucketTagging(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tagging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getTaggingResponseParser, bucketName, null, true);
    }

    public VoidResult deleteBucketTagging(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tagging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public BucketVersioningConfiguration getBucketVersioning(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("versioning", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketVersioningResponseParser, bucketName, null, true);
    }

    public VoidResult setBucketVersioning(SetBucketVersioningRequest setBucketVersioningRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketVersioningRequest, "setBucketVersioningRequest");
        CodingUtils.assertParameterNotNull(setBucketVersioningRequest.getVersioningConfiguration(), "versioningConfiguration");
        String bucketName = setBucketVersioningRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("versioning", null);
        byte[] rawContent = RequestMarshallers.setBucketVersioningRequestMarshaller.marshall(setBucketVersioningRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setBucketVersioningRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(setBucketVersioningRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public VoidResult addBucketReplication(AddBucketReplicationRequest addBucketReplicationRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(addBucketReplicationRequest, "addBucketReplicationRequest");
        CodingUtils.assertParameterNotNull(addBucketReplicationRequest.getTargetBucketName(), "targetBucketName");
        String bucketName = addBucketReplicationRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("replication", null);
        params.put("comp", "add");
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(addBucketReplicationRequest)).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.addBucketReplicationRequestMarshaller.marshall(addBucketReplicationRequest)).setOriginalRequest(addBucketReplicationRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public List<ReplicationRule> getBucketReplication(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("replication", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketReplicationResponseParser, bucketName, null, true);
    }

    public VoidResult deleteBucketReplication(DeleteBucketReplicationRequest deleteBucketReplicationRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(deleteBucketReplicationRequest, "deleteBucketReplicationRequest");
        CodingUtils.assertParameterNotNull(deleteBucketReplicationRequest.getReplicationRuleID(), "replicationRuleID");
        String bucketName = deleteBucketReplicationRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("replication", null);
        params.put("comp", "delete");
        byte[] rawContent = RequestMarshallers.deleteBucketReplicationRequestMarshaller.marshall(deleteBucketReplicationRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(deleteBucketReplicationRequest)).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(deleteBucketReplicationRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    private static void addRequestRequiredHeaders(Map<String, String> headers, byte[] rawContent) {
        headers.put("Content-Length", String.valueOf(rawContent.length));
        byte[] md5 = BinaryUtil.calculateMd5(rawContent);
        String md5Base64 = BinaryUtil.toBase64String(md5);
        headers.put("Content-MD5", md5Base64);
    }

    public BucketReplicationProgress getBucketReplicationProgress(GetBucketReplicationProgressRequest getBucketReplicationProgressRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(getBucketReplicationProgressRequest, "getBucketReplicationProgressRequest");
        CodingUtils.assertParameterNotNull(getBucketReplicationProgressRequest.getReplicationRuleID(), "replicationRuleID");
        String bucketName = getBucketReplicationProgressRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("replicationProgress", null);
        params.put("rule-id", getBucketReplicationProgressRequest.getReplicationRuleID());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(getBucketReplicationProgressRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(getBucketReplicationProgressRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketReplicationProgressResponseParser, bucketName, null, true);
    }

    public List<String> getBucketReplicationLocation(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("replicationLocation", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketReplicationLocationResponseParser, bucketName, null, true);
    }

    public AddBucketCnameResult addBucketCname(AddBucketCnameRequest addBucketCnameRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(addBucketCnameRequest, "addBucketCnameRequest");
        CodingUtils.assertParameterNotNull(addBucketCnameRequest.getDomain(), "addBucketCnameRequest.domain");
        String bucketName = addBucketCnameRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", null);
        params.put("comp", "add");
        byte[] rawContent = RequestMarshallers.addBucketCnameRequestMarshaller.marshall(addBucketCnameRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(addBucketCnameRequest)).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(addBucketCnameRequest).build();
        return this.doOperation(request, ResponseParsers.addBucketCnameResponseParser, bucketName, null);
    }

    public List<CnameConfiguration> getBucketCname(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketCnameResponseParser, bucketName, null, true);
    }

    public VoidResult deleteBucketCname(DeleteBucketCnameRequest deleteBucketCnameRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(deleteBucketCnameRequest, "deleteBucketCnameRequest");
        CodingUtils.assertParameterNotNull(deleteBucketCnameRequest.getDomain(), "deleteBucketCnameRequest.domain");
        String bucketName = deleteBucketCnameRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", null);
        params.put("comp", "delete");
        byte[] rawContent = RequestMarshallers.deleteBucketCnameRequestMarshaller.marshall(deleteBucketCnameRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(deleteBucketCnameRequest)).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(deleteBucketCnameRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public CreateBucketCnameTokenResult createBucketCnameToken(CreateBucketCnameTokenRequest createBucketCnameTokenRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(createBucketCnameTokenRequest, "createBucketCnameTokenRequest");
        CodingUtils.assertParameterNotNull(createBucketCnameTokenRequest.getDomain(), "createBucketCnameTokenRequest.domain");
        String bucketName = createBucketCnameTokenRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", null);
        params.put("comp", "token");
        byte[] rawContent = RequestMarshallers.createBucketCnameTokenRequestMarshaller.marshall(createBucketCnameTokenRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(createBucketCnameTokenRequest)).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(createBucketCnameTokenRequest).build();
        return this.doOperation(request, ResponseParsers.createBucketCnameTokenResponseParser, bucketName, null, true);
    }

    public GetBucketCnameTokenResult getBucketCnameToken(GetBucketCnameTokenRequest getBucketCnameTokenRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(getBucketCnameTokenRequest, "getBucketCnameTokenRequest");
        CodingUtils.assertParameterNotNull(getBucketCnameTokenRequest.getDomain(), "getBucketCnameTokenRequest.domain");
        String bucketName = getBucketCnameTokenRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(getBucketCnameTokenRequest.getDomain(), "bucketName");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", getBucketCnameTokenRequest.getDomain());
        params.put("comp", "token");
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(getBucketCnameTokenRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(getBucketCnameTokenRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketCnameTokenResponseParser, bucketName, null, true);
    }

    public BucketInfo getBucketInfo(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("bucketInfo", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketInfoResponseParser, bucketName, null, true);
    }

    public BucketStat getBucketStat(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("stat", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketStatResponseParser, bucketName, null, true);
    }

    public VoidResult setBucketStorageCapacity(SetBucketStorageCapacityRequest setBucketStorageCapacityRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketStorageCapacityRequest, "setBucketStorageCapacityRequest");
        CodingUtils.assertParameterNotNull(setBucketStorageCapacityRequest.getUserQos(), "setBucketStorageCapacityRequest.userQos");
        String bucketName = setBucketStorageCapacityRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        UserQos userQos = setBucketStorageCapacityRequest.getUserQos();
        CodingUtils.assertParameterNotNull(userQos.getStorageCapacity(), "StorageCapacity");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("qos", null);
        byte[] rawContent = RequestMarshallers.setBucketQosRequestMarshaller.marshall(userQos);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setBucketStorageCapacityRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(setBucketStorageCapacityRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public UserQos getBucketStorageCapacity(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("qos", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketQosResponseParser, bucketName, null, true);
    }

    public VoidResult setBucketEncryption(SetBucketEncryptionRequest setBucketEncryptionRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketEncryptionRequest, "setBucketEncryptionRequest");
        String bucketName = setBucketEncryptionRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("encryption", null);
        byte[] rawContent = RequestMarshallers.setBucketEncryptionRequestMarshaller.marshall(setBucketEncryptionRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setBucketEncryptionRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(setBucketEncryptionRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public ServerSideEncryptionConfiguration getBucketEncryption(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("encryption", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketEncryptionResponseParser, bucketName, null, true);
    }

    public VoidResult deleteBucketEncryption(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("encryption", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public VoidResult setBucketPolicy(SetBucketPolicyRequest setBucketPolicyRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketPolicyRequest, "setBucketPolicyRequest");
        String bucketName = setBucketPolicyRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        byte[] rawContent = RequestMarshallers.setBucketPolicyRequestMarshaller.marshall(setBucketPolicyRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setBucketPolicyRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(setBucketPolicyRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public GetBucketPolicyResult getBucketPolicy(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketPolicyResponseParser, bucketName, null, true);
    }

    public VoidResult deleteBucketPolicy(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public VoidResult setBucketRequestPayment(SetBucketRequestPaymentRequest setBucketRequestPaymentRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketRequestPaymentRequest, "setBucketRequestPaymentRequest");
        CodingUtils.assertParameterNotNull((Object)setBucketRequestPaymentRequest.getPayer(), "setBucketRequestPaymentRequest.payer");
        String bucketName = setBucketRequestPaymentRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("requestPayment", null);
        Payer payer = setBucketRequestPaymentRequest.getPayer();
        byte[] rawContent = RequestMarshallers.setBucketRequestPaymentRequestMarshaller.marshall(payer.toString());
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setBucketRequestPaymentRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(setBucketRequestPaymentRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public GetBucketRequestPaymentResult getBucketRequestPayment(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("requestPayment", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketRequestPaymentResponseParser, bucketName, null, true);
    }

    public VoidResult setBucketQosInfo(SetBucketQosInfoRequest setBucketQosInfoRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketQosInfoRequest, "setBucketQosInfoRequest");
        CodingUtils.assertParameterNotNull(setBucketQosInfoRequest.getBucketQosInfo(), "setBucketQosInfoRequest.getBucketQosInfo");
        String bucketName = setBucketQosInfoRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("qosInfo", null);
        byte[] rawContent = RequestMarshallers.setBucketQosInfoRequestMarshaller.marshall(setBucketQosInfoRequest.getBucketQosInfo());
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setBucketQosInfoRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(setBucketQosInfoRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public BucketQosInfo getBucketQosInfo(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("qosInfo", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketQosInfoResponseParser, bucketName, null, true);
    }

    public VoidResult deleteBucketQosInfo(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("qosInfo", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public UserQosInfo getUserQosInfo() throws OSSException, ClientException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("qosInfo", null);
        GenericRequest gGenericRequest = new GenericRequest();
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setParameters(params).setOriginalRequest(gGenericRequest).build();
        return this.doOperation(request, ResponseParsers.getUSerQosInfoResponseParser, null, null, true);
    }

    public SetAsyncFetchTaskResult setAsyncFetchTask(SetAsyncFetchTaskRequest setAsyncFetchTaskRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setAsyncFetchTaskRequest, "setAsyncFetchTaskRequest");
        String bucketName = setAsyncFetchTaskRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        AsyncFetchTaskConfiguration taskConfiguration = setAsyncFetchTaskRequest.getAsyncFetchTaskConfiguration();
        CodingUtils.assertParameterNotNull(taskConfiguration, "taskConfiguration");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("asyncFetch", null);
        byte[] rawContent = RequestMarshallers.setAsyncFetchTaskRequestMarshaller.marshall(setAsyncFetchTaskRequest.getAsyncFetchTaskConfiguration());
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setAsyncFetchTaskRequest)).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(setAsyncFetchTaskRequest).build();
        return this.doOperation(request, ResponseParsers.setAsyncFetchTaskResponseParser, bucketName, null, true);
    }

    public GetAsyncFetchTaskResult getAsyncFetchTask(GetAsyncFetchTaskRequest getAsyncFetchTaskRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(getAsyncFetchTaskRequest, "getAsyncFetchTaskInfoRequest");
        String bucketName = getAsyncFetchTaskRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        String taskId = getAsyncFetchTaskRequest.getTaskId();
        CodingUtils.assertParameterNotNull(taskId, "taskId");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("asyncFetch", null);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-oss-task-id", taskId);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(getAsyncFetchTaskRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setHeaders(headers).setParameters(params).setOriginalRequest(getAsyncFetchTaskRequest).build();
        return this.doOperation(request, ResponseParsers.getAsyncFetchTaskResponseParser, bucketName, null, true);
    }

    public CreateVpcipResult createVpcip(CreateVpcipRequest createVpcipRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(createVpcipRequest, "createVpcipRequest");
        String region = createVpcipRequest.getRegion();
        String vSwitchId = createVpcipRequest.getVSwitchId();
        CodingUtils.assertParameterNotNull(region, "region");
        CodingUtils.assertParameterNotNull(vSwitchId, "vSwitchId");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("vpcip", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(createVpcipRequest)).setParameters(params).setMethod(HttpMethod.POST).setInputStreamWithLength(RequestMarshallers.createVpcipRequestMarshaller.marshall(createVpcipRequest)).setOriginalRequest(createVpcipRequest).build();
        CreateVpcipResult createVpcipResult = new CreateVpcipResult();
        Vpcip vpcip = this.doOperation(request, ResponseParsers.createVpcipResultResponseParser, null, null, true);
        createVpcipResult.setVpcip(vpcip);
        return createVpcipResult;
    }

    public List<Vpcip> listVpcip() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("vpcip", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setParameters(params).build();
        return this.doOperation(request, ResponseParsers.listVpcipResultResponseParser, null, null, true);
    }

    public VoidResult deleteVpcip(DeleteVpcipRequest deleteVpcipRequest) {
        CodingUtils.assertParameterNotNull(deleteVpcipRequest, "deleteVpcipRequest");
        VpcPolicy vpcPolicy = deleteVpcipRequest.getVpcPolicy();
        String region = vpcPolicy.getRegion();
        String vpcId = vpcPolicy.getVpcId();
        String vip = vpcPolicy.getVip();
        CodingUtils.assertParameterNotNull(region, "region");
        CodingUtils.assertParameterNotNull(vpcId, "vpcId");
        CodingUtils.assertParameterNotNull(vip, "vip");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("vpcip", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(deleteVpcipRequest)).setParameters(params).setMethod(HttpMethod.DELETE).setInputStreamWithLength(RequestMarshallers.deleteVpcipRequestMarshaller.marshall(deleteVpcipRequest)).setOriginalRequest(deleteVpcipRequest).build();
        return this.doOperation(request, requestIdResponseParser, null, null);
    }

    public VoidResult createBucketVpcip(CreateBucketVpcipRequest createBucketVpcipRequest) {
        String bucketName = createBucketVpcipRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(createBucketVpcipRequest, "createBucketVpcipRequest");
        VpcPolicy vpcPolicy = createBucketVpcipRequest.getVpcPolicy();
        String region = vpcPolicy.getRegion();
        String vpcId = vpcPolicy.getVpcId();
        String vip = vpcPolicy.getVip();
        CodingUtils.assertParameterNotNull(region, "region");
        CodingUtils.assertParameterNotNull(vpcId, "vpcId");
        CodingUtils.assertParameterNotNull(vip, "vip");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("vip", null);
        params.put("comp", "add");
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(createBucketVpcipRequest)).setMethod(HttpMethod.POST).setParameters(params).setBucket(bucketName).setInputStreamWithLength(RequestMarshallers.createBucketVpcipRequestMarshaller.marshall(createBucketVpcipRequest)).setOriginalRequest(createBucketVpcipRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public VoidResult deleteBucketVpcip(DeleteBucketVpcipRequest deleteBucketVpcipRequest) {
        String bucketName = deleteBucketVpcipRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(deleteBucketVpcipRequest, "deleteBucketVpcipRequest");
        VpcPolicy vpcPolicy = deleteBucketVpcipRequest.getVpcPolicy();
        String region = vpcPolicy.getRegion();
        String vpcId = vpcPolicy.getVpcId();
        String vip = vpcPolicy.getVip();
        CodingUtils.assertParameterNotNull(region, "region");
        CodingUtils.assertParameterNotNull(vpcId, "vpcId");
        CodingUtils.assertParameterNotNull(vip, "vip");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("vip", null);
        params.put("comp", "delete");
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(deleteBucketVpcipRequest)).setMethod(HttpMethod.POST).setParameters(params).setBucket(bucketName).setInputStreamWithLength(RequestMarshallers.deleteBucketVpcipRequestMarshaller.marshall(vpcPolicy)).setOriginalRequest(vpcPolicy).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public List<VpcPolicy> getBucketVpcip(GenericRequest genericRequest) {
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("vip", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
        return this.doOperation(request, ResponseParsers.listVpcPolicyResultResponseParser, bucketName, null, true);
    }

    public VoidResult setBucketInventoryConfiguration(SetBucketInventoryConfigurationRequest setBucketInventoryConfigurationRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketInventoryConfigurationRequest, "SetBucketInventoryConfigurationRequest");
        String bucketName = setBucketInventoryConfigurationRequest.getBucketName();
        String inventoryId = setBucketInventoryConfigurationRequest.getInventoryConfiguration().getInventoryId();
        CodingUtils.assertParameterNotNull(inventoryId, "inventory configuration id");
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        byte[] rawContent = RequestMarshallers.setBucketInventoryRequestMarshaller.marshall(setBucketInventoryConfigurationRequest.getInventoryConfiguration());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("inventory", null);
        params.put("inventoryId", inventoryId);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setBucketInventoryConfigurationRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setHeaders(headers).setOriginalRequest(setBucketInventoryConfigurationRequest).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public GetBucketInventoryConfigurationResult getBucketInventoryConfiguration(GetBucketInventoryConfigurationRequest getBucketInventoryConfigurationRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(getBucketInventoryConfigurationRequest, "getBucketInventoryConfigurationRequest");
        String bucketName = getBucketInventoryConfigurationRequest.getBucketName();
        String inventoryId = getBucketInventoryConfigurationRequest.getInventoryId();
        CodingUtils.assertParameterNotNull(inventoryId, "inventory configuration id");
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("inventory", null);
        params.put("inventoryId", inventoryId);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(getBucketInventoryConfigurationRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(getBucketInventoryConfigurationRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketInventoryConfigurationParser, bucketName, null, true);
    }

    public ListBucketInventoryConfigurationsResult listBucketInventoryConfigurations(ListBucketInventoryConfigurationsRequest listBucketInventoryConfigurationsRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(listBucketInventoryConfigurationsRequest, "listBucketInventoryConfigurationsRequest");
        String bucketName = listBucketInventoryConfigurationsRequest.getBucketName();
        String continuationToken = listBucketInventoryConfigurationsRequest.getContinuationToken();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("inventory", null);
        if (continuationToken != null && !continuationToken.isEmpty()) {
            params.put("continuation-token", continuationToken);
        }
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(listBucketInventoryConfigurationsRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(listBucketInventoryConfigurationsRequest).build();
        return this.doOperation(request, ResponseParsers.listBucketInventoryConfigurationsParser, bucketName, null, true);
    }

    public VoidResult deleteBucketInventoryConfiguration(DeleteBucketInventoryConfigurationRequest deleteBucketInventoryConfigurationRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(deleteBucketInventoryConfigurationRequest, "deleteBucketInventoryConfigurationRequest");
        String bucketName = deleteBucketInventoryConfigurationRequest.getBucketName();
        String inventoryId = deleteBucketInventoryConfigurationRequest.getInventoryId();
        CodingUtils.assertParameterNotNull(inventoryId, "id");
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("inventory", null);
        params.put("inventoryId", inventoryId);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(deleteBucketInventoryConfigurationRequest)).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(deleteBucketInventoryConfigurationRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public InitiateBucketWormResult initiateBucketWorm(InitiateBucketWormRequest initiateBucketWormRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(initiateBucketWormRequest, "initiateBucketWormRequest");
        String bucketName = initiateBucketWormRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("worm", null);
        byte[] rawContent = RequestMarshallers.initiateBucketWormRequestMarshaller.marshall(initiateBucketWormRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(initiateBucketWormRequest)).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setHeaders(headers).setOriginalRequest(initiateBucketWormRequest).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).build();
        return this.doOperation(request, ResponseParsers.initiateBucketWormResponseParser, bucketName, null);
    }

    public VoidResult abortBucketWorm(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("worm", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public VoidResult completeBucketWorm(CompleteBucketWormRequest completeBucketWormRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(completeBucketWormRequest, "completeBucketWormRequest");
        String bucketName = completeBucketWormRequest.getBucketName();
        String wormId = completeBucketWormRequest.getWormId();
        CodingUtils.assertParameterNotNull(wormId, "wormId");
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("wormId", wormId);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(completeBucketWormRequest)).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setOriginalRequest(completeBucketWormRequest).setInputSize(0L).setInputStream(new ByteArrayInputStream(new byte[0])).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public VoidResult extendBucketWorm(ExtendBucketWormRequest extendBucketWormRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(extendBucketWormRequest, "extendBucketWormRequest");
        String bucketName = extendBucketWormRequest.getBucketName();
        String wormId = extendBucketWormRequest.getWormId();
        CodingUtils.assertParameterNotNull(wormId, "wormId");
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("wormId", wormId);
        params.put("wormExtend", null);
        byte[] rawContent = RequestMarshallers.extendBucketWormRequestMarshaller.marshall(extendBucketWormRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(extendBucketWormRequest)).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setHeaders(headers).setOriginalRequest(extendBucketWormRequest).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public GetBucketWormResult getBucketWorm(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("worm", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketWormResponseParser, bucketName, null, true);
    }

    public VoidResult setBucketResourceGroup(SetBucketResourceGroupRequest setBucketResourceGroupRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketResourceGroupRequest, "setBucketResourceGroupRequest");
        CodingUtils.assertParameterNotNull(setBucketResourceGroupRequest.getResourceGroupId(), "setBucketResourceGroupRequest.resourceGroupId");
        String bucketName = setBucketResourceGroupRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resourceGroup", null);
        byte[] rawContent = RequestMarshallers.setBucketResourceGroupRequestMarshaller.marshall(setBucketResourceGroupRequest.getResourceGroupId());
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setBucketResourceGroupRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(setBucketResourceGroupRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public GetBucketResourceGroupResult getBucketResourceGroup(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resourceGroup", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketResourceGroupResponseParser, bucketName, null, true);
    }

    private static void populateListObjectsRequestParameters(ListObjectsRequest listObjectsRequest, Map<String, String> params) {
        if (listObjectsRequest.getPrefix() != null) {
            params.put("prefix", listObjectsRequest.getPrefix());
        }
        if (listObjectsRequest.getMarker() != null) {
            params.put("marker", listObjectsRequest.getMarker());
        }
        if (listObjectsRequest.getDelimiter() != null) {
            params.put("delimiter", listObjectsRequest.getDelimiter());
        }
        if (listObjectsRequest.getMaxKeys() != null) {
            params.put("max-keys", Integer.toString(listObjectsRequest.getMaxKeys()));
        }
        if (listObjectsRequest.getEncodingType() != null) {
            params.put("encoding-type", listObjectsRequest.getEncodingType());
        }
    }

    private static void populateListObjectsV2RequestParameters(ListObjectsV2Request listObjectsV2Request, Map<String, String> params) {
        params.put("list-type", "2");
        if (listObjectsV2Request.getPrefix() != null) {
            params.put("prefix", listObjectsV2Request.getPrefix());
        }
        if (listObjectsV2Request.getDelimiter() != null) {
            params.put("delimiter", listObjectsV2Request.getDelimiter());
        }
        if (listObjectsV2Request.getMaxKeys() != null) {
            params.put("max-keys", Integer.toString(listObjectsV2Request.getMaxKeys()));
        }
        if (listObjectsV2Request.getEncodingType() != null) {
            params.put("encoding-type", listObjectsV2Request.getEncodingType());
        }
        if (listObjectsV2Request.getStartAfter() != null) {
            params.put("start-after", listObjectsV2Request.getStartAfter());
        }
        if (listObjectsV2Request.isFetchOwner()) {
            params.put("fetch-owner", Boolean.toString(listObjectsV2Request.isFetchOwner()));
        }
        if (listObjectsV2Request.getContinuationToken() != null) {
            params.put("continuation-token", listObjectsV2Request.getContinuationToken());
        }
    }

    private static void populateListVersionsRequestParameters(ListVersionsRequest listVersionsRequest, Map<String, String> params) {
        params.put("versions", null);
        if (listVersionsRequest.getPrefix() != null) {
            params.put("prefix", listVersionsRequest.getPrefix());
        }
        if (listVersionsRequest.getKeyMarker() != null) {
            params.put("key-marker", listVersionsRequest.getKeyMarker());
        }
        if (listVersionsRequest.getDelimiter() != null) {
            params.put("delimiter", listVersionsRequest.getDelimiter());
        }
        if (listVersionsRequest.getMaxResults() != null) {
            params.put("max-keys", Integer.toString(listVersionsRequest.getMaxResults()));
        }
        if (listVersionsRequest.getVersionIdMarker() != null) {
            params.put("version-id-marker", listVersionsRequest.getVersionIdMarker());
        }
        if (listVersionsRequest.getEncodingType() != null) {
            params.put("encoding-type", listVersionsRequest.getEncodingType());
        }
    }

    private static void addOptionalACLHeader(Map<String, String> headers, CannedAccessControlList cannedAcl) {
        if (cannedAcl != null) {
            headers.put("x-oss-acl", cannedAcl.toString());
        }
    }

    public VoidResult setBucketTransferAcceleration(SetBucketTransferAccelerationRequest setBucketTransferAccelerationRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketTransferAccelerationRequest, "putBucketTransferAccelerationRequest");
        String bucketName = setBucketTransferAccelerationRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("transferAcceleration", null);
        byte[] rawContent = RequestMarshallers.putBucketTransferAccelerationRequestMarshaller.marshall(setBucketTransferAccelerationRequest);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setBucketTransferAccelerationRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setOriginalRequest(setBucketTransferAccelerationRequest).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null, true);
    }

    public TransferAcceleration getBucketTransferAcceleration(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("transferAcceleration", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketTransferAccelerationResponseParser, bucketName, null, true);
    }

    public VoidResult deleteBucketTransferAcceleration(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("transferAcceleration", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    private static void addOptionalHnsHeader(Map<String, String> headers, String hnsStatus) {
        if (hnsStatus != null) {
            headers.put("x-oss-hns-status", hnsStatus.toLowerCase());
        }
    }

    private static void addOptionalResourceGroupIdHeader(Map<String, String> headers, String resourceGroupId) {
        if (resourceGroupId != null) {
            headers.put("x-oss-resource-group-id", resourceGroupId);
        }
    }

    private static void populateRequestPayerHeader(Map<String, String> headers, Payer payer) {
        if (payer != null && payer.equals((Object)Payer.Requester)) {
            headers.put("x-oss-request-payer", payer.toString().toLowerCase());
        }
    }

    public VoidResult putBucketAccessMonitor(PutBucketAccessMonitorRequest putBucketAccessMonitorRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(putBucketAccessMonitorRequest, "putBucketAccessMonitorRequest");
        String bucketName = putBucketAccessMonitorRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accessmonitor", null);
        byte[] rawContent = RequestMarshallers.putBucketAccessMonitorRequestMarshaller.marshall(putBucketAccessMonitorRequest);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setOriginalRequest(putBucketAccessMonitorRequest).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null, true);
    }

    public AccessMonitor getBucketAccessMonitor(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accessmonitor", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketAccessMonitorResponseParser, bucketName, null, true);
    }

    public VoidResult openMetaQuery(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("metaQuery", null);
        params.put("comp", "add");
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).setInputSize(0L).setInputStream(new ByteArrayInputStream(new byte[0])).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null, true);
    }

    public GetMetaQueryStatusResult getMetaQueryStatus(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("metaQuery", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getMetaQueryStatusResponseParser, bucketName, null, true);
    }

    public DoMetaQueryResult doMetaQuery(DoMetaQueryRequest doMetaQueryRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(doMetaQueryRequest, "doMetaQueryRequest");
        String bucketName = doMetaQueryRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("metaQuery", null);
        params.put("comp", "query");
        byte[] rawContent = RequestMarshallers.doMetaQueryRequestMarshaller.marshall(doMetaQueryRequest);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setOriginalRequest(doMetaQueryRequest).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).build();
        return this.doOperation(request, ResponseParsers.doMetaQueryResponseParser, bucketName, null, true);
    }

    public VoidResult closeMetaQuery(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("metaQuery", null);
        params.put("comp", "delete");
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).setInputSize(0L).setInputStream(new ByteArrayInputStream(new byte[0])).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null, true);
    }

    public DescribeRegionsResult describeRegions(DescribeRegionsRequest describeRegionsRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(describeRegionsRequest, "describeRegionsRequest");
        String bucketName = describeRegionsRequest.getBucketName();
        String region = describeRegionsRequest.getRegion();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("regions", region);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(describeRegionsRequest).build();
        return this.doOperation(request, ResponseParsers.describeRegionsResponseParser, bucketName, null, true);
    }

    public VoidResult setBucketCallbackPolicy(SetBucketCallbackPolicyRequest setBucketCallbackPolicyRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketCallbackPolicyRequest, "setBucketCallbackPolicyRequest");
        String bucketName = setBucketCallbackPolicyRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        params.put("comp", "callback");
        byte[] rawContent = RequestMarshallers.setBucketCallbackPolicyRequestMarshaller.marshall(setBucketCallbackPolicyRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setBucketCallbackPolicyRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(setBucketCallbackPolicyRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }

    public GetBucketCallbackPolicyResult getBucketCallbackPolicy(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        params.put("comp", "callback");
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketCallbackPolicyResponseParser, bucketName, null, true);
    }

    public VoidResult deleteBucketCallbackPolicy(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        params.put("comp", "callback");
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, null);
    }
}

