/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util.collections;

import org.apache.flink.table.runtime.util.MurmurHashUtil;
import org.apache.flink.table.runtime.util.collections.OptimizableHashSet;

public class LongHashSet
extends OptimizableHashSet {
    private long[] key;
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;

    public LongHashSet(int expected, float f) {
        super(expected, f);
        this.key = new long[this.n + 1];
    }

    public LongHashSet(int expected) {
        this(expected, 0.75f);
    }

    public LongHashSet() {
        this(16, 0.75f);
    }

    public boolean add(long k) {
        if (k == 0L) {
            if (this.containsZero) {
                return false;
            }
            this.containsZero = true;
        } else {
            long[] key = this.key;
            int pos = (int)MurmurHashUtil.fmix(k) & this.mask;
            long curr = key[pos];
            if (curr != 0L) {
                if (curr == k) {
                    return false;
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != 0L) {
                    if (curr != k) continue;
                    return false;
                }
            }
            key[pos] = k;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(OptimizableHashSet.arraySize(this.size + 1, this.f));
        }
        if (k < this.min) {
            this.min = k;
        }
        if (k > this.max) {
            this.max = k;
        }
        return true;
    }

    public boolean contains(long k) {
        if (this.isDense) {
            return k >= this.min && k <= this.max && this.used[(int)(k - this.min)];
        }
        if (k == 0L) {
            return this.containsZero;
        }
        long[] key = this.key;
        int pos = (int)MurmurHashUtil.fmix(k) & this.mask;
        long curr = key[pos];
        if (curr == 0L) {
            return false;
        }
        if (k == curr) {
            return true;
        }
        while ((curr = key[pos = pos + 1 & this.mask]) != 0L) {
            if (k != curr) continue;
            return true;
        }
        return false;
    }

    private void rehash(int newN) {
        long[] key = this.key;
        int mask = newN - 1;
        long[] newKey = new long[newN + 1];
        int i = this.n;
        int j = this.realSize();
        while (j-- != 0) {
            while (key[--i] == 0L) {
            }
            int pos = (int)MurmurHashUtil.fmix(key[i]) & mask;
            if (newKey[pos] != 0L) {
                while (newKey[pos = pos + 1 & mask] != 0L) {
                }
            }
            newKey[pos] = key[i];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = OptimizableHashSet.maxFill(this.n, this.f);
        this.key = newKey;
    }

    @Override
    public void optimize() {
        long range = this.max - this.min;
        if (range >= 0L && (range < (long)this.key.length || range < 8192L)) {
            this.used = new boolean[(int)(this.max - this.min + 1L)];
            for (long v : this.key) {
                if (v == 0L) continue;
                this.used[(int)(v - this.min)] = true;
            }
            if (this.containsZero) {
                this.used[(int)(-this.min)] = true;
            }
            this.isDense = true;
            this.key = null;
        }
    }
}

