/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class MapUnionFunction
extends BuiltInScalarFunction {
    private final ArrayData.ElementGetter keyElementGetter;
    private final ArrayData.ElementGetter valueElementGetter;
    private final SpecializedFunction.ExpressionEvaluator keyEqualityEvaluator;
    private transient MethodHandle keyEqualityHandle;

    public MapUnionFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.MAP_UNION, context);
        KeyValueDataType outputType = (KeyValueDataType)context.getCallContext().getOutputDataType().get();
        DataType keyDataType = outputType.getKeyDataType();
        DataType valueDataType = outputType.getValueDataType();
        this.keyElementGetter = ArrayData.createElementGetter((LogicalType)outputType.getKeyDataType().getLogicalType());
        this.valueElementGetter = ArrayData.createElementGetter((LogicalType)outputType.getValueDataType().getLogicalType());
        this.keyEqualityEvaluator = context.createEvaluator((Expression)Expressions.$((String)"element1").isEqual((Object)Expressions.$((String)"element2")), DataTypes.BOOLEAN(), new DataTypes.Field[]{DataTypes.FIELD((String)"element1", (DataType)((DataType)keyDataType.notNull()).toInternal()), DataTypes.FIELD((String)"element2", (DataType)((DataType)keyDataType.notNull()).toInternal())});
    }

    public void open(FunctionContext context) throws Exception {
        this.keyEqualityHandle = this.keyEqualityEvaluator.open(context);
    }

    @Nullable
    public MapData eval(MapData ... maps) {
        try {
            if (maps == null || maps.length == 0) {
                return null;
            }
            if (maps.length == 1) {
                return maps[0];
            }
            MapData result = maps[0];
            if (result == null) {
                return null;
            }
            for (int i = 1; i < maps.length; ++i) {
                MapData map = maps[i];
                if (map == null) {
                    return null;
                }
                if (map.size() <= 0) continue;
                result = new MapDataForMapUnion(result, map);
            }
            return result;
        }
        catch (Throwable t) {
            throw new FlinkRuntimeException(t);
        }
    }

    public void close() throws Exception {
        this.keyEqualityEvaluator.close();
    }

    private class MapDataForMapUnion
    implements MapData {
        private final GenericArrayData keysArray;
        private final GenericArrayData valuesArray;

        public MapDataForMapUnion(MapData map1, MapData map2) throws Throwable {
            ArrayList<Object> keysList = new ArrayList<Object>();
            ArrayList<Object> valuesList = new ArrayList<Object>();
            boolean isKeyNullExist = false;
            ArrayData keyArray2 = map2.keyArray();
            ArrayData valueArray2 = map2.valueArray();
            for (int i = 0; i < map2.size(); ++i) {
                Object key = MapUnionFunction.this.keyElementGetter.getElementOrNull(keyArray2, i);
                if (key == null) {
                    isKeyNullExist = true;
                }
                keysList.add(key);
                valuesList.add(MapUnionFunction.this.valueElementGetter.getElementOrNull(valueArray2, i));
            }
            ArrayData keyArray1 = map1.keyArray();
            ArrayData valueArray1 = map1.valueArray();
            for (int i = 0; i < map1.size(); ++i) {
                Object key1 = MapUnionFunction.this.keyElementGetter.getElementOrNull(keyArray1, i);
                boolean keyExists = false;
                if (key1 != null) {
                    for (int j = 0; j < keysList.size(); ++j) {
                        Object key2 = keysList.get(j);
                        if (key2 == null || !MapUnionFunction.this.keyEqualityHandle.invoke(key1, key2)) continue;
                        keyExists = true;
                        break;
                    }
                }
                if (isKeyNullExist && key1 == null || keyExists) continue;
                Object value1 = MapUnionFunction.this.valueElementGetter.getElementOrNull(valueArray1, i);
                keysList.add(key1);
                valuesList.add(value1);
            }
            this.keysArray = new GenericArrayData(keysList.toArray());
            this.valuesArray = new GenericArrayData(valuesList.toArray());
        }

        public int size() {
            return this.keysArray.size();
        }

        public ArrayData keyArray() {
            return this.keysArray;
        }

        public ArrayData valueArray() {
            return this.valuesArray;
        }
    }
}

