/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.api.internal.TableResultUtils;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.SqlLikeUtils;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.LikeType;
import org.apache.flink.table.operations.ShowOperation;

@Internal
public class ShowFunctionsOperation
implements ShowOperation {
    private final FunctionScope functionScope;
    private final String preposition;
    private final String catalogName;
    private final String databaseName;
    private final LikeType likeType;
    private final String likePattern;
    private final boolean notLike;

    public ShowFunctionsOperation() {
        this.functionScope = FunctionScope.ALL;
        this.preposition = null;
        this.catalogName = null;
        this.databaseName = null;
        this.likeType = null;
        this.likePattern = null;
        this.notLike = false;
    }

    public ShowFunctionsOperation(FunctionScope functionScope, String likeType, String likePattern, boolean notLike) {
        this.functionScope = functionScope;
        this.preposition = null;
        this.catalogName = null;
        this.databaseName = null;
        if (likeType != null) {
            this.likeType = LikeType.of(likeType);
            this.likePattern = Objects.requireNonNull(likePattern, "Like pattern must not be null");
            this.notLike = notLike;
        } else {
            this.likeType = null;
            this.likePattern = null;
            this.notLike = false;
        }
    }

    public ShowFunctionsOperation(FunctionScope functionScope, String preposition, String catalogName, String databaseName, String likeType, String likePattern, boolean notLike) {
        this.functionScope = functionScope;
        this.preposition = preposition;
        this.catalogName = catalogName;
        this.databaseName = databaseName;
        if (likeType != null) {
            this.likeType = LikeType.of(likeType);
            this.likePattern = Objects.requireNonNull(likePattern, "Like pattern must not be null");
            this.notLike = notLike;
        } else {
            this.likeType = null;
            this.likePattern = null;
            this.notLike = false;
        }
    }

    @Override
    public String asSummaryString() {
        StringBuilder builder = new StringBuilder();
        if (this.functionScope == FunctionScope.ALL) {
            builder.append("SHOW FUNCTIONS");
        } else {
            builder.append(String.format("SHOW %s FUNCTIONS", new Object[]{this.functionScope}));
        }
        if (this.preposition != null) {
            builder.append(String.format(" %s %s.%s", this.preposition, this.catalogName, this.databaseName));
        }
        if (this.isWithLike()) {
            if (this.isNotLike()) {
                builder.append(String.format(" NOT %s '%s'", this.likeType.name(), this.likePattern));
            } else {
                builder.append(String.format(" %s '%s'", this.likeType.name(), this.likePattern));
            }
        }
        return builder.toString();
    }

    public FunctionScope getFunctionScope() {
        return this.functionScope;
    }

    public boolean isLike() {
        return this.likeType == LikeType.LIKE;
    }

    public boolean isWithLike() {
        return this.likeType != null;
    }

    public boolean isNotLike() {
        return this.notLike;
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        String[] functionNames;
        block9: {
            block8: {
                if (this.preposition != null) break block8;
                switch (this.functionScope) {
                    case USER: {
                        functionNames = ctx.getFunctionCatalog().getUserDefinedFunctions();
                        break block9;
                    }
                    case ALL: {
                        functionNames = ctx.getFunctionCatalog().getFunctions();
                        break block9;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("SHOW FUNCTIONS with %s scope is not supported.", new Object[]{this.functionScope}));
                    }
                }
            }
            switch (this.functionScope) {
                case USER: {
                    functionNames = (String[])ctx.getFunctionCatalog().getUserDefinedFunctions(this.catalogName, this.databaseName).stream().map(FunctionIdentifier::getFunctionName).toArray(String[]::new);
                    break;
                }
                case ALL: {
                    functionNames = ctx.getFunctionCatalog().getFunctions(this.catalogName, this.databaseName);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("SHOW FUNCTIONS with %s scope is not supported.", new Object[]{this.functionScope}));
                }
            }
        }
        String[] rows = this.isWithLike() ? (String[])Arrays.stream(functionNames).filter(row -> {
            if (this.likeType == LikeType.ILIKE) {
                return this.isNotLike() != SqlLikeUtils.ilike(row, this.likePattern, "\\");
            }
            return this.isNotLike() != SqlLikeUtils.like(row, this.likePattern, "\\");
        }).sorted().toArray(String[]::new) : (String[])Arrays.stream(functionNames).sorted().toArray(String[]::new);
        return TableResultUtils.buildStringArrayResult("function name", rows);
    }

    @Internal
    public static enum FunctionScope {
        USER,
        ALL;

    }
}

