/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.orc.impl.HadoopShims;

class ZeroCopyShims {
    ZeroCopyShims() {
    }

    public static HadoopShims.ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream in, HadoopShims.ByteBufferPoolShim pool) throws IOException {
        return new ZeroCopyAdapter(in, pool);
    }

    private static final class ZeroCopyAdapter
    implements HadoopShims.ZeroCopyReaderShim {
        private final FSDataInputStream in;
        private final ByteBufferPoolAdapter pool;
        private static final EnumSet<ReadOption> CHECK_SUM = EnumSet.noneOf(ReadOption.class);
        private static final EnumSet<ReadOption> NO_CHECK_SUM = EnumSet.of(ReadOption.SKIP_CHECKSUMS);

        ZeroCopyAdapter(FSDataInputStream in, HadoopShims.ByteBufferPoolShim poolshim) {
            this.in = in;
            this.pool = poolshim != null ? new ByteBufferPoolAdapter(poolshim) : null;
        }

        @Override
        public ByteBuffer readBuffer(int maxLength, boolean verifyChecksums) throws IOException {
            EnumSet<ReadOption> options = NO_CHECK_SUM;
            if (verifyChecksums) {
                options = CHECK_SUM;
            }
            return this.in.read((ByteBufferPool)this.pool, maxLength, options);
        }

        @Override
        public void releaseBuffer(ByteBuffer buffer) {
            this.in.releaseBuffer(buffer);
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }

    private static final class ByteBufferPoolAdapter
    implements ByteBufferPool {
        private HadoopShims.ByteBufferPoolShim pool;

        ByteBufferPoolAdapter(HadoopShims.ByteBufferPoolShim pool) {
            this.pool = pool;
        }

        public ByteBuffer getBuffer(boolean direct, int length) {
            return this.pool.getBuffer(direct, length);
        }

        public void putBuffer(ByteBuffer buffer) {
            this.pool.putBuffer(buffer);
        }
    }
}

