// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.nereids.trees.expressions.functions.agg;

import org.apache.doris.catalog.FunctionSignature;
import org.apache.doris.nereids.trees.expressions.Expression;
import org.apache.doris.nereids.trees.expressions.functions.BitmapIntersectFunction;
import org.apache.doris.nereids.trees.expressions.functions.ExplicitlyCastableSignature;
import org.apache.doris.nereids.trees.expressions.literal.BigIntLiteral;
import org.apache.doris.nereids.trees.expressions.visitor.ExpressionVisitor;
import org.apache.doris.nereids.types.BigIntType;
import org.apache.doris.nereids.types.BitmapType;
import org.apache.doris.nereids.types.DataType;
import org.apache.doris.nereids.util.ExpressionUtils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

import java.util.List;

/**
 * AggregateFunction 'intersect_count'. This class is generated by GenerateFunction.
 */
public class IntersectCount extends NotNullableAggregateFunction
        implements ExplicitlyCastableSignature, BitmapIntersectFunction {

    public static final List<FunctionSignature> SIGNATURES = DataType.trivialTypes().stream()
            .map(type -> FunctionSignature.ret(BigIntType.INSTANCE).varArgs(BitmapType.INSTANCE, type, type))
            .collect(ImmutableList.toImmutableList());

    /**
     * constructor with 3 or more arguments.
     */
    public IntersectCount(Expression arg0, Expression arg1, Expression arg2, Expression... varArgs) {
        super("intersect_count", ExpressionUtils.mergeArguments(arg0, arg1, arg2, varArgs));
    }

    /**
     * constructor with 3 or more arguments.
     */
    public IntersectCount(boolean distinct, Expression arg0, Expression arg1, Expression arg2, Expression... varArgs) {
        super("intersect_count", distinct,
                ExpressionUtils.mergeArguments(arg0, arg1, arg2, varArgs));
    }

    /** constructor for withChildren and reuse signature */
    private IntersectCount(AggregateFunctionParams functionParams) {
        super(functionParams);
    }

    /**
     * withDistinctAndChildren.
     */
    @Override
    public IntersectCount withDistinctAndChildren(boolean distinct, List<Expression> children) {
        Preconditions.checkArgument(children.size() >= 3);
        return new IntersectCount(getFunctionParams(distinct, children));
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitIntersectCount(this, context);
    }

    @Override
    public List<FunctionSignature> getSignatures() {
        return SIGNATURES;
    }

    @Override
    public Expression resultForEmptyInput() {
        return new BigIntLiteral(0);
    }
}
