/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.cookers;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.daffodil.lib.cookers.EntityReplacer$;
import org.apache.daffodil.lib.cookers.EntitySyntaxException;
import org.apache.daffodil.lib.equality.package$ViewEqual$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.ThrowsSDE;
import org.apache.daffodil.lib.util.Maybe$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;

public final class EntityReplacer {
    private final String dfdlEntityName;
    private final String dfdlCharClassEntityName;
    private final List entityCharacterUnicode = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{Tuple3$.MODULE$.apply((Object)"NUL", (Object)"\u0000", (Object)Pattern.compile("%NUL;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"SOH", (Object)"\u0001", (Object)Pattern.compile("%SOH;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"STX", (Object)"\u0002", (Object)Pattern.compile("%STX;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"ETX", (Object)"\u0003", (Object)Pattern.compile("%ETX;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"EOT", (Object)"\u0004", (Object)Pattern.compile("%EOT;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"ENQ", (Object)"\u0005", (Object)Pattern.compile("%ENQ;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"ACK", (Object)"\u0006", (Object)Pattern.compile("%ACK;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"BEL", (Object)"\u0007", (Object)Pattern.compile("%BEL;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"BS", (Object)"\b", (Object)Pattern.compile("%BS;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"HT", (Object)"\t", (Object)Pattern.compile("%HT;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"LF", (Object)"\n", (Object)Pattern.compile("%LF;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"VT", (Object)"\u000b", (Object)Pattern.compile("%VT;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"FF", (Object)"\f", (Object)Pattern.compile("%FF;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"CR", (Object)"\r", (Object)Pattern.compile("%CR;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"SO", (Object)"\u000e", (Object)Pattern.compile("%SO;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"SI", (Object)"\u000f", (Object)Pattern.compile("%SI;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"DLE", (Object)"\u0010", (Object)Pattern.compile("%DLE;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"DC1", (Object)"\u0011", (Object)Pattern.compile("%DC1;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"DC2", (Object)"\u0012", (Object)Pattern.compile("%DC2;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"DC3", (Object)"\u0013", (Object)Pattern.compile("%DC3;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"DC4", (Object)"\u0014", (Object)Pattern.compile("%DC4;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"NAK", (Object)"\u0015", (Object)Pattern.compile("%NAK;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"SYN", (Object)"\u0016", (Object)Pattern.compile("%SYN;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"ETB", (Object)"\u0017", (Object)Pattern.compile("%ETB;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"CAN", (Object)"\u0018", (Object)Pattern.compile("%CAN;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"EM", (Object)"\u0019", (Object)Pattern.compile("%EM;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"SUB", (Object)"\u001a", (Object)Pattern.compile("%SUB;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"ESC", (Object)"\u001b", (Object)Pattern.compile("%ESC;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"FS", (Object)"\u001c", (Object)Pattern.compile("%FS;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"GS", (Object)"\u001d", (Object)Pattern.compile("%GS;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"RS", (Object)"\u001e", (Object)Pattern.compile("%RS;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"US", (Object)"\u001f", (Object)Pattern.compile("%US;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"SP", (Object)" ", (Object)Pattern.compile("%SP;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"DEL", (Object)"\u007f", (Object)Pattern.compile("%DEL;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"NBSP", (Object)"\u00a0", (Object)Pattern.compile("%NBSP;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"NEL", (Object)"\u0085", (Object)Pattern.compile("%NEL;", 8).matcher("")), Tuple3$.MODULE$.apply((Object)"LS", (Object)"\u2028", (Object)Pattern.compile("%LS;", 8).matcher(""))}));
    private final List charClassReplacements = (List)new .colon.colon((Object)Tuple3$.MODULE$.apply((Object)"WSP", (Object)" ", (Object)Pattern.compile("%WSP;", 8).matcher("")), (List)new .colon.colon((Object)Tuple3$.MODULE$.apply((Object)"WSP*", (Object)"", (Object)Pattern.compile("%WSP\\*;", 8).matcher("")), (List)new .colon.colon((Object)Tuple3$.MODULE$.apply((Object)"WSP+", (Object)" ", (Object)Pattern.compile("%WSP\\+;", 8).matcher("")), (List)new .colon.colon((Object)Tuple3$.MODULE$.apply((Object)"ES", (Object)"", (Object)Pattern.compile("%ES;", 8).matcher("")), (List)Nil$.MODULE$))));
    private final List escapeReplacements = (List)new .colon.colon((Object)Tuple3$.MODULE$.apply((Object)"%", (Object)"%", (Object)Pattern.compile("%%", 8).matcher("")), (List)Nil$.MODULE$);
    private final Matcher charEntityPattern = Pattern.compile("%(" + this.dfdlEntityName() + ");", 8).matcher("");
    private final Matcher hexPattern = Pattern.compile("%#x[0-9a-fA-F]+;", 8).matcher("");
    private final Matcher decPattern = Pattern.compile("%#[0-9]+;", 8).matcher("");
    private final Matcher bytePattern = Pattern.compile("%#r[0-9a-fA-F]{2};", 8).matcher("");
    private final Matcher charClassEntityPattern = Pattern.compile("%(" + this.dfdlCharClassEntityName() + ");", 8).matcher("");
    private final Regex charEntityRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(%(?:" + this.dfdlEntityName() + ");)(.*)"));
    private final Regex hexRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(%#x[0-9a-fA-F]+;)(.*)"));
    private final Regex decRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(%#[0-9]+;)(.*)"));
    private final Regex byteRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(%#r[0-9a-fA-F]{2};)(.*)"));
    private final Regex charClassEntityRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(%(?:" + this.dfdlCharClassEntityName() + ");)(.*)"));
    private final Regex dfdlEntityRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(%[^%]*?;)(.*)"));
    private final String markerForNL;
    private final String markerForDoublePercent;
    private final Matcher DPMatcher = Pattern.compile("(?<!%)%%", 8).matcher("");
    private final Matcher markerForDPMatcher = Pattern.compile(this.markerForDoublePercent, 8).matcher("");
    private final Matcher NLMatcher = Pattern.compile("%NL;", 8).matcher("");
    private final Matcher markerForNLMatcher = Pattern.compile(this.markerForNL(), 8).matcher("");

    public static <R> R apply(Function1<EntityReplacer, R> function1) {
        return EntityReplacer$.MODULE$.apply(function1);
    }

    public EntityReplacer() {
        this.dfdlEntityName = "NUL|SOH|STX|ETX|EOT|ENQ|ACK|BEL|BS|HT|LF|VT|FF|CR|SO|SI|DLE|DC[1-4]|NAK|SYN|ETB|CAN|EM|SUB|ESC|FS|GS|RS|US|SP|DEL|NBSP|NEL|LS";
        this.dfdlCharClassEntityName = "NL|WSP|WSP\\*|WSP\\+|ES";
        this.markerForNL = "\ufffc__NL_ENTITY__\ufffc";
        this.markerForDoublePercent = "\ufffc__DOUBLE_PERCENT__\ufffc";
    }

    public String dfdlEntityName() {
        return this.dfdlEntityName;
    }

    public String dfdlCharClassEntityName() {
        return this.dfdlCharClassEntityName;
    }

    public List<Tuple3<String, String, Matcher>> entityCharacterUnicode() {
        return this.entityCharacterUnicode;
    }

    public List<Tuple3<String, String, Matcher>> charClassReplacements() {
        return this.charClassReplacements;
    }

    public List<Tuple3<String, String, Matcher>> escapeReplacements() {
        return this.escapeReplacements;
    }

    public Matcher charEntityPattern() {
        return this.charEntityPattern;
    }

    public Matcher hexPattern() {
        return this.hexPattern;
    }

    public Matcher decPattern() {
        return this.decPattern;
    }

    public Matcher bytePattern() {
        return this.bytePattern;
    }

    public Matcher charClassEntityPattern() {
        return this.charClassEntityPattern;
    }

    public Regex charEntityRegex() {
        return this.charEntityRegex;
    }

    public Regex hexRegex() {
        return this.hexRegex;
    }

    public Regex decRegex() {
        return this.decRegex;
    }

    public Regex byteRegex() {
        return this.byteRegex;
    }

    public Regex charClassEntityRegex() {
        return this.charClassEntityRegex;
    }

    public Regex dfdlEntityRegex() {
        return this.dfdlEntityRegex;
    }

    public boolean hasDfdlEntity(String input) {
        return this.hasDfdlCharEntity(input) || this.hasDecimalCodePoint(input) || this.hasHexCodePoint(input) || this.hasByteCodePoint(input) || this.hasDfdlCharClassEntity(input);
    }

    private boolean isMatched(String input, Matcher m) {
        m.reset(input);
        return m.find();
    }

    public boolean hasDfdlCharClassEntity(String input) {
        return this.isMatched(input, this.charClassEntityPattern());
    }

    public boolean hasDfdlCharEntity(String input) {
        return this.isMatched(input, this.charEntityPattern());
    }

    public boolean hasDecimalCodePoint(String input) {
        return this.isMatched(input, this.decPattern());
    }

    public boolean hasHexCodePoint(String input) {
        return this.isMatched(input, this.hexPattern());
    }

    public boolean hasByteCodePoint(String input) {
        return this.isMatched(input, this.bytePattern());
    }

    private String replaceEntityWithChar(String input, String entity, char newChar) {
        Character c = (Character)org.apache.daffodil.lib.equality.package$.MODULE$.ViewEqual(BoxesRunTime.boxToCharacter((char)newChar));
        String replacement = package$ViewEqual$.MODULE$.$eq$hash$eq$extension(c, BoxesRunTime.boxToCharacter((char)'%')) ? "%%" : Matcher.quoteReplacement(BoxesRunTime.boxToCharacter((char)newChar).toString());
        return input.replaceAll(entity, replacement);
    }

    public String replaceHex(String input, String prefix) {
        String res = input;
        while (this.hasHexCodePoint(res)) {
            Matcher m = this.hexPattern();
            m.reset(res);
            if (!m.find()) continue;
            String rawStr = m.group().toString();
            String trimmedStr = rawStr.replace(prefix, "").replace(";", "");
            int intStr = Integer.parseInt(trimmedStr, 16);
            char newChar = (char)intStr;
            res = this.replaceEntityWithChar(res, rawStr, newChar);
        }
        return res;
    }

    public String replaceDecimal(String input, String prefix) {
        String res = input;
        while (this.hasDecimalCodePoint(res)) {
            Matcher m = this.decPattern();
            m.reset(res);
            if (!m.find()) continue;
            String rawStr = m.group().toString();
            String trimmedStr = rawStr.replace(prefix, "").replace(";", "");
            int intStr = Integer.parseInt(trimmedStr, 10);
            char newChar = (char)intStr;
            res = this.replaceEntityWithChar(res, rawStr, newChar);
        }
        return res;
    }

    public String replaceBytes(String input, String prefix) {
        String res = input;
        while (this.hasByteCodePoint(res)) {
            Matcher m = this.bytePattern();
            m.reset(res);
            if (!m.find()) continue;
            String rawStr = m.group().toString();
            String trimmedStr = rawStr.replace(prefix, "").replace(";", "");
            int upperNibble = Byte.parseByte(trimmedStr.substring(0, 1), 16) << 4;
            byte lowerNibble = Byte.parseByte(trimmedStr.substring(1, 2), 16);
            int byteStr = upperNibble | lowerNibble;
            char newChar = (char)byteStr;
            res = this.replaceEntityWithChar(res, rawStr, newChar);
        }
        return res;
    }

    public String replaceByte(String input) {
        return this.replaceBytes(input, "%#r");
    }

    public String replaceHex(String input) {
        return this.replaceHex(input, "%#x");
    }

    public String replaceDecimal(String input) {
        return this.replaceDecimal(input, "%#");
    }

    public String replaceDfdlEntity(String input) {
        return this.replace(input, this.entityCharacterUnicode());
    }

    public String replaceEscapes(String input) {
        return this.replace(input, this.escapeReplacements());
    }

    public String replaceCharClassForUnparse(String input) {
        return this.replace(input, this.charClassReplacements());
    }

    public String markerForNL() {
        return this.markerForNL;
    }

    public String replaceForUnparse(String raw) {
        this.markerForDPMatcher.reset(raw);
        if (this.markerForDPMatcher.find()) {
            throw Assert$.MODULE$.usageError2("string cannot contain " + this.markerForDPMatcher, "EntityReplacer.this.markerForDPMatcher.find().unary_!");
        }
        this.markerForNLMatcher.reset(raw);
        if (this.markerForNLMatcher.find()) {
            throw Assert$.MODULE$.usageError2("string cannot contain " + this.markerForNL(), "EntityReplacer.this.markerForNLMatcher.find().unary_!");
        }
        this.DPMatcher.reset(raw);
        String dpMarked = this.DPMatcher.replaceAll(this.markerForDoublePercent);
        String forUnp = this.replaceAll(dpMarked, (Option<ThrowsSDE>)None$.MODULE$, true, this.replaceAll$default$4());
        this.NLMatcher.reset(forUnp);
        String nlMarked = this.NLMatcher.replaceAll(this.markerForNL());
        String s2 = nlMarked.replaceAll(this.markerForDoublePercent, "%");
        return s2;
    }

    private String stripLeadingPercent(String s) {
        if (s.startsWith("%")) {
            return s.substring(1);
        }
        return s;
    }

    /*
     * Unable to fully structure code
     */
    private String replaceEntity(String proposedEntity, String orig, Option<ThrowsSDE> context, boolean forUnparse, boolean allowByteEntity) {
        var7_6 = proposedEntity;
        if (var7_6 == null) ** GOTO lbl-1000
        var8_7 = this.charClassEntityRegex().unapplySeq((CharSequence)var7_6);
        if (!var8_7.isEmpty() && (var9_8 = (List)var8_7.get()).lengthCompare(2) == 0) {
            var10_9 = (String)var9_8.apply(0);
            var11_10 = (String)var9_8.apply(1);
            v0 = forUnparse ? this.replaceCharClassForUnparse(proposedEntity) : proposedEntity;
        } else {
            var12_11 = this.hexRegex().unapplySeq((CharSequence)var7_6);
            if (!var12_11.isEmpty() && (var13_12 = (List)var12_11.get()).lengthCompare(2) == 0) {
                var14_13 = (String)var13_12.apply(0);
                var15_14 = (String)var13_12.apply(1);
                entity = var14_13;
                rest = var15_14;
                v0 = this.replaceHex(proposedEntity);
            } else {
                var18_17 = this.decRegex().unapplySeq((CharSequence)var7_6);
                if (!var18_17.isEmpty() && (var19_18 = (List)var18_17.get()).lengthCompare(2) == 0) {
                    var20_19 = (String)var19_18.apply(0);
                    var21_20 = (String)var19_18.apply(1);
                    entity = var20_19;
                    rest = var21_20;
                    v0 = this.replaceDecimal(proposedEntity);
                } else {
                    var24_23 = this.byteRegex().unapplySeq((CharSequence)var7_6);
                    if (!var24_23.isEmpty() && (var25_24 = (List)var24_23.get()).lengthCompare(2) == 0) {
                        var26_25 = (String)var25_24.apply(0);
                        var27_26 = (String)var25_24.apply(1);
                        entity = var26_25;
                        rest = var27_26;
                        if (allowByteEntity) {
                            v0 = this.replaceByte(proposedEntity);
                        } else {
                            msg = "DFDL Byte Entity (%%%s) is not allowed, but was found in \"%s\"";
                            v0 = (String)context.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$1(java.lang.String java.lang.String java.lang.String org.apache.daffodil.lib.exceptions.ThrowsSDE ), (Lorg/apache/daffodil/lib/exceptions/ThrowsSDE;)Lscala/runtime/Nothing$;)((EntityReplacer)this, (String)msg, (String)proposedEntity, (String)orig)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$2(java.lang.String java.lang.String java.lang.String ), ()Lscala/runtime/Nothing$;)((EntityReplacer)this, (String)msg, (String)proposedEntity, (String)orig));
                        }
                    } else {
                        var31_30 = this.charEntityRegex().unapplySeq((CharSequence)var7_6);
                        if (!var31_30.isEmpty() && (var32_31 = (List)var31_30.get()).lengthCompare(2) == 0) {
                            var33_32 = (String)var32_31.apply(0);
                            var34_33 = (String)var32_31.apply(1);
                            entity = var33_32;
                            rest = var34_33;
                            v0 = this.replace(proposedEntity, this.entityCharacterUnicode());
                        } else {
                            var37_36 = this.dfdlEntityRegex().unapplySeq((CharSequence)var7_6);
                            if (!var37_36.isEmpty() && (var38_37 = (List)var37_36.get()).lengthCompare(2) == 0) {
                                var39_38 = (String)var38_37.apply(0);
                                var40_39 = (String)var38_37.apply(1);
                                invalidEntity = var39_38;
                                rest = var40_39;
                                msg = "Invalid DFDL Entity (%%%s) found in \"%s\"";
                                v0 = (String)context.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$3(java.lang.String java.lang.String java.lang.String org.apache.daffodil.lib.exceptions.ThrowsSDE ), (Lorg/apache/daffodil/lib/exceptions/ThrowsSDE;)Lscala/runtime/Nothing$;)((EntityReplacer)this, (String)msg, (String)invalidEntity, (String)orig)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$4(java.lang.String java.lang.String java.lang.String ), ()Lscala/runtime/Nothing$;)((EntityReplacer)this, (String)msg, (String)invalidEntity, (String)orig));
                            } else lbl-1000:
                            // 2 sources

                            {
                                v0 = nonEntity = var7_6;
                            }
                        }
                    }
                }
            }
        }
        result = v0;
        return result;
    }

    private void errBadEntityLonePercent(String ent, String orig, Object context) {
        String msg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid DFDL Entity (%s) found in \"%s\". If a single percent was intended instead of a DFDL Entity, it must be self escaped (%%%%)."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ent, orig}));
        if (Maybe$.MODULE$.isDefined$extension(context)) {
            throw ((ThrowsSDE)Maybe$.MODULE$.get$extension(context)).SDE(msg, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        throw new EntitySyntaxException(msg);
    }

    private void errBadEntityNoSemi(String ent, String orig, Object context) {
        String msg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid DFDL Entity (%%%s) found in \"%s\". Missing semicolon at end of entity name?"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.stripLeadingPercent(ent), orig}));
        if (Maybe$.MODULE$.isDefined$extension(context)) {
            throw ((ThrowsSDE)Maybe$.MODULE$.get$extension(context)).SDE(msg, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        throw new EntitySyntaxException(msg);
    }

    private String process(String input, String orig, Option<ThrowsSDE> context, boolean forUnparse, boolean allowByteEntities) {
        if (input.contains("%%")) {
            throw Assert$.MODULE$.usageError("input.contains(\"%%\").unary_!");
        }
        if (!input.contains("%")) {
            return input;
        }
        if (input.equals("%")) {
            this.errBadEntityLonePercent(input, orig, Maybe$.MODULE$.toMaybe(context));
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])input.split("%"));
        Object[] tokens = (String[])ArrayOps$.MODULE$.$plus$plus$extension(object, (IterableOnce)(input.endsWith("%") ? (IterableOnce)new .colon.colon((Object)"", (List)Nil$.MODULE$) : package$.MODULE$.Nil()), ClassTag$.MODULE$.apply(String.class));
        Object object2 = Predef$.MODULE$.refArrayOps(tokens);
        String startingToken = (String)ArrayOps$.MODULE$.head$extension(object2);
        Object object3 = Predef$.MODULE$.refArrayOps(tokens);
        Object[] possibleEntityTokens = (String[])ArrayOps$.MODULE$.tail$extension(object3);
        Object object4 = Predef$.MODULE$.refArrayOps(possibleEntityTokens);
        Object[] tokens2 = (String[])ArrayOps$.MODULE$.map$extension(object4, (Function1 & Serializable)tok -> {
            if (tok.contains("%")) {
                throw Assert$.MODULE$.abort("Invariant broken: tok.contains(\"%\").unary_!");
            }
            if (!tok.contains(";")) {
                this.errBadEntityNoSemi((String)tok, orig, Maybe$.MODULE$.toMaybe(context));
            }
            int semiPos = tok.indexOf(";");
            String possibleEntityName = tok.substring(0, semiPos);
            String afterEntity = tok.substring(semiPos + 1);
            String newEntity = this.replaceEntity("%" + possibleEntityName + ";", orig, context, forUnparse, allowByteEntities);
            String res = newEntity + afterEntity;
            return res;
        }, ClassTag$.MODULE$.apply(String.class));
        String output = startingToken + Predef$.MODULE$.wrapRefArray(tokens2).mkString();
        return output;
    }

    private boolean process$default$5() {
        return true;
    }

    private boolean hasDoublePercentEnding(String input) {
        String string = input;
        String string2 = "";
        if (!(string == null ? string2 != null : !string.equals(string2)) || input.length() < 2) {
            return false;
        }
        return input.charAt(input.length() - 2) == '%' && StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(input)) == '%';
    }

    public String replaceAll(String input, Option<ThrowsSDE> context, boolean forUnparse, boolean allowByteEntities) {
        if (!input.contains("%")) {
            return input;
        }
        int startOfPossibleEntity = input.indexOf("%");
        String inputUntilPossibleEntity = input.substring(0, startOfPossibleEntity);
        String inputWithPossibleEntity = input.substring(startOfPossibleEntity);
        if (!inputWithPossibleEntity.contains("%%")) {
            String processedInput = this.process(inputWithPossibleEntity, input, context, forUnparse, allowByteEntities);
            String fullResult = inputUntilPossibleEntity + processedInput;
            return fullResult;
        }
        boolean endedWithDoublePercent = this.hasDoublePercentEnding(inputWithPossibleEntity);
        Object[] splitByDoublePercent = inputWithPossibleEntity.split("%%");
        Object object = Predef$.MODULE$.refArrayOps(splitByDoublePercent);
        Object[] replaced = (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)token -> this.process((String)token, input, context, forUnparse, this.process$default$5()), ClassTag$.MODULE$.apply(String.class));
        String replacementForDoublePercents = forUnparse ? "%" : "%%";
        String recomposedWithLiteralPercents = inputUntilPossibleEntity + Predef$.MODULE$.wrapRefArray(replaced).mkString(replacementForDoublePercents) + (endedWithDoublePercent ? replacementForDoublePercents : "");
        return recomposedWithLiteralPercents;
    }

    public Option<ThrowsSDE> replaceAll$default$2() {
        return None$.MODULE$;
    }

    public boolean replaceAll$default$3() {
        return false;
    }

    public boolean replaceAll$default$4() {
        return true;
    }

    private String replace(String input, List<Tuple3<String, String, Matcher>> chars) {
        ObjectRef res = ObjectRef.create((Object)input);
        chars.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                String entity = (String)tuple3._1();
                String unicode = (String)tuple3._2();
                Matcher m = (Matcher)tuple3._3();
                m.reset((String)res$1.elem);
                res$1.elem = m.replaceAll(unicode);
                return;
            }
            throw new MatchError((Object)tuple3);
        });
        return (String)res.elem;
    }

    private final /* synthetic */ Nothing$ $anonfun$1(String msg$1, String proposedEntity$1, String orig$1, ThrowsSDE _$5) {
        return _$5.SDE(msg$1, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.stripLeadingPercent(proposedEntity$1), orig$1}));
    }

    private final Nothing$ $anonfun$2(String msg$2, String proposedEntity$2, String orig$2) {
        throw new EntitySyntaxException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(msg$2), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.stripLeadingPercent(proposedEntity$2), orig$2})));
    }

    private final /* synthetic */ Nothing$ $anonfun$3(String msg$3, String invalidEntity$1, String orig$3, ThrowsSDE _$6) {
        return _$6.SDE(msg$3, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.stripLeadingPercent(invalidEntity$1), orig$3}));
    }

    private final Nothing$ $anonfun$4(String msg$4, String invalidEntity$2, String orig$4) {
        throw new EntitySyntaxException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(msg$4), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.stripLeadingPercent(invalidEntity$2), orig$4})));
    }
}

