/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.calendar;

import com.ibm.icu.util.TimeZone;
import java.io.Serializable;
import org.apache.daffodil.lib.calendar.DFDLCalendarOrder$;
import org.apache.daffodil.lib.calendar.DFDLDateTime;
import org.apache.daffodil.lib.exceptions.Assert$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public interface OrderedCalendar {
    public static Enumeration.Value order$(OrderedCalendar $this, DFDLDateTime p, DFDLDateTime q) {
        return $this.order(p, q);
    }

    default public Enumeration.Value order(DFDLDateTime p, DFDLDateTime q) {
        Enumeration.Value value;
        boolean pHasTZ = p.hasTimeZone();
        boolean qHasTZ = q.hasTimeZone();
        DFDLDateTime pPrime = p.getNormalizedCalendar();
        DFDLDateTime qPrime = q.getNormalizedCalendar();
        if (pHasTZ && qHasTZ || !pHasTZ && !qHasTZ) {
            value = this.orderCompareFields(pPrime, qPrime);
        } else if (pHasTZ && !qHasTZ) {
            DFDLDateTime qPlus = qPrime.getDateTimePlusFourteenHours();
            Enumeration.Value value2 = this.orderCompareFields(pPrime, qPlus);
            Enumeration.Value value3 = DFDLCalendarOrder$.MODULE$.P_LESS_THAN_Q();
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                value = DFDLCalendarOrder$.MODULE$.P_LESS_THAN_Q();
            } else {
                DFDLDateTime qMinus = q.getDateTimeMinusFourteenHours();
                Enumeration.Value value4 = this.orderCompareFields(pPrime, qMinus);
                Enumeration.Value value5 = DFDLCalendarOrder$.MODULE$.P_GREATER_THAN_Q();
                value = !(value4 != null ? !value4.equals(value5) : value5 != null) ? DFDLCalendarOrder$.MODULE$.P_GREATER_THAN_Q() : DFDLCalendarOrder$.MODULE$.P_NOT_EQUAL_Q();
            }
        } else if (!pHasTZ && qHasTZ) {
            DFDLDateTime pMinus = pPrime.getDateTimeMinusFourteenHours();
            Enumeration.Value value6 = this.orderCompareFields(pMinus, qPrime);
            Enumeration.Value value7 = DFDLCalendarOrder$.MODULE$.P_LESS_THAN_Q();
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                value = DFDLCalendarOrder$.MODULE$.P_LESS_THAN_Q();
            } else {
                DFDLDateTime pPlus = pPrime.getDateTimePlusFourteenHours();
                Enumeration.Value value8 = this.orderCompareFields(pPlus, qPrime);
                Enumeration.Value value9 = DFDLCalendarOrder$.MODULE$.P_GREATER_THAN_Q();
                value = !(value8 != null ? !value8.equals(value9) : value9 != null) ? DFDLCalendarOrder$.MODULE$.P_GREATER_THAN_Q() : DFDLCalendarOrder$.MODULE$.P_NOT_EQUAL_Q();
            }
        } else {
            throw Assert$.MODULE$.impossibleCase();
        }
        Enumeration.Value res = value;
        return res;
    }

    private Enumeration.Value orderCompareFields(DFDLDateTime p, DFDLDateTime q) {
        if (p.hasTimeZone()) {
            TimeZone timeZone = p.calendar().getTimeZone();
            TimeZone timeZone2 = TimeZone.GMT_ZONE;
            if (timeZone == null ? timeZone2 != null : !timeZone.equals(timeZone2)) {
                throw Assert$.MODULE$.abort("Invariant broken: p.hasTimeZone.unary_!.||(p.calendar.getTimeZone().==(com.ibm.icu.util.TimeZone.GMT_ZONE))");
            }
        }
        if (q.hasTimeZone()) {
            TimeZone timeZone = q.calendar().getTimeZone();
            TimeZone timeZone3 = TimeZone.GMT_ZONE;
            if (timeZone == null ? timeZone3 != null : !timeZone.equals(timeZone3)) {
                throw Assert$.MODULE$.abort("Invariant broken: q.hasTimeZone.unary_!.||(q.calendar.getTimeZone().==(com.ibm.icu.util.TimeZone.GMT_ZONE))");
            }
        }
        Object object = Predef$.MODULE$.intArrayOps(DFDLCalendarOrder$.MODULE$.fieldsForComparison());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)field -> OrderedCalendar.orderCompareFields$$anonfun$1(p, q, BoxesRunTime.unboxToInt((Object)field)), ClassTag$.MODULE$.apply(Option.class)));
        return (Enumeration.Value)ArrayOps$.MODULE$.find$extension(object2, (Function1 & Serializable)_$2 -> _$2.isDefined()).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()).getOrElse(OrderedCalendar::orderCompareFields$$anonfun$3);
    }

    private static /* synthetic */ Option orderCompareFields$$anonfun$1(DFDLDateTime p$1, DFDLDateTime q$1, int field) {
        int qVal;
        boolean hasP = p$1.calendar().isSet(field);
        boolean hasQ = q$1.calendar().isSet(field);
        if (!hasP && !hasQ) {
            return None$.MODULE$;
        }
        if (hasP ^ hasQ) {
            return Some$.MODULE$.apply((Object)DFDLCalendarOrder$.MODULE$.P_NOT_EQUAL_Q());
        }
        int pVal = p$1.calendar().get(field);
        if (pVal < (qVal = q$1.calendar().get(field))) {
            return Some$.MODULE$.apply((Object)DFDLCalendarOrder$.MODULE$.P_LESS_THAN_Q());
        }
        if (pVal > qVal) {
            return Some$.MODULE$.apply((Object)DFDLCalendarOrder$.MODULE$.P_GREATER_THAN_Q());
        }
        return None$.MODULE$;
    }

    private static Enumeration.Value orderCompareFields$$anonfun$3() {
        return DFDLCalendarOrder$.MODULE$.P_EQUAL_Q();
    }
}

