/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans.rules;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyOutputter;
import net.sf.saxon.event.SequenceCollector;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.RecordTest;
import net.sf.saxon.ma.map.SingleEntryMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.ShallowCopyRuleSet;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class ShallowCopyAllRuleSet
extends ShallowCopyRuleSet {
    private static final ShallowCopyAllRuleSet THE_INSTANCE = new ShallowCopyAllRuleSet();

    public static ShallowCopyAllRuleSet getInstance() {
        return THE_INSTANCE;
    }

    private ShallowCopyAllRuleSet() {
    }

    @Override
    public void process(Item item, ParameterSet parameters, ParameterSet tunnelParams, Outputter out, XPathContext context, Location locationId) throws XPathException {
        block7: {
            Item resultItem;
            block8: {
                int size;
                block9: {
                    block6: {
                        if (!(item instanceof ArrayItem)) break block6;
                        SequenceCollector collector = context.getController().allocateSequenceOutputter();
                        ComplexContentOutputter cco = new ComplexContentOutputter(collector);
                        ShallowCopyProxyOutputterForArrays checker = new ShallowCopyProxyOutputterForArrays(cco, locationId);
                        collector.setSystemId(out.getSystemId());
                        SequenceIterator iter = ((ArrayItem)item).parcels();
                        PipelineConfiguration pipe = out.getPipelineConfiguration();
                        XPathContextMajor c2 = context.newContext();
                        c2.setOrigin(this);
                        c2.trackFocus(iter);
                        c2.setCurrentComponent(c2.getCurrentMode());
                        pipe.setXPathContext(c2);
                        for (TailCall tc = context.getCurrentMode().getActor().applyTemplates(parameters, tunnelParams, null, checker, c2, locationId); tc != null; tc = tc.processLeavingTail()) {
                        }
                        pipe.setXPathContext(context);
                        ArrayList<GroundedValue> members = new ArrayList<GroundedValue>();
                        for (Item it : collector.getList()) {
                            members.add(((MapItem)it).get(new StringValue("value")));
                        }
                        SimpleArrayItem newArray = new SimpleArrayItem(members);
                        out.append(newArray, locationId, 0);
                        break block7;
                    }
                    if (!(item instanceof MapItem)) break block8;
                    size = ((MapItem)item).size();
                    if (size != 1) break block9;
                    AtomicValue key = null;
                    GroundedValue singletonValue = null;
                    Iterator<KeyValuePair> iter = ((MapItem)item).keyValuePairs().iterator();
                    if (iter.hasNext()) {
                        KeyValuePair pair = iter.next();
                        key = pair.key;
                        singletonValue = pair.value;
                    }
                    SequenceCollector collector = context.getController().allocateSequenceOutputter();
                    ComplexContentOutputter cco = new ComplexContentOutputter(collector);
                    collector.setSystemId(out.getSystemId());
                    SequenceIterator iter2 = singletonValue.iterate();
                    PipelineConfiguration pipe = out.getPipelineConfiguration();
                    XPathContextMajor c2 = context.newContext();
                    c2.setOrigin(this);
                    c2.trackFocus(iter2);
                    c2.setCurrentComponent(c2.getCurrentMode());
                    pipe.setXPathContext(c2);
                    for (TailCall tc = context.getCurrentMode().getActor().applyTemplates(parameters, tunnelParams, null, cco, c2, locationId); tc != null; tc = tc.processLeavingTail()) {
                    }
                    pipe.setXPathContext(context);
                    SingleEntryMap singletonMap = new SingleEntryMap(key, collector.getSequence());
                    out.append(singletonMap, locationId, 0);
                    break block7;
                }
                if (size <= 1) break block7;
                SequenceCollector collector = context.getController().allocateSequenceOutputter();
                ComplexContentOutputter cco = new ComplexContentOutputter(collector);
                ShallowCopyProxyOutputterForMaps checker = new ShallowCopyProxyOutputterForMaps(cco, locationId);
                collector.setSystemId(out.getSystemId());
                SequenceIterator iter = ((MapItem)item).entries();
                PipelineConfiguration pipe = out.getPipelineConfiguration();
                XPathContextMajor c2 = context.newContext();
                c2.setOrigin(this);
                c2.trackFocus(iter);
                c2.setCurrentComponent(c2.getCurrentMode());
                pipe.setXPathContext(c2);
                for (TailCall tc = context.getCurrentMode().getActor().applyTemplates(parameters, tunnelParams, null, checker, c2, locationId); tc != null; tc = tc.processLeavingTail()) {
                }
                pipe.setXPathContext(context);
                MapItem mergedMap = MapFunctionSet.MapMerge.mergeMaps(collector.iterate(), context, "use-last", null, null);
                out.append(mergedMap, locationId, 0);
                break block7;
            }
            SequenceCollector collector = context.getController().allocateSequenceOutputter();
            ComplexContentOutputter cco = new ComplexContentOutputter(collector);
            collector.setSystemId(out.getSystemId());
            super.process(item, parameters, tunnelParams, cco, context, locationId);
            SequenceIterator resultIter = collector.iterate();
            while ((resultItem = resultIter.next()) != null) {
                out.append(resultItem);
            }
        }
    }

    @Override
    public String getName() {
        return "shallow-copy-all";
    }

    private static class ShallowCopyProxyOutputterForArrays
    extends ProxyOutputter {
        private final Location locationId;

        public ShallowCopyProxyOutputterForArrays(ComplexContentOutputter cco, Location locationId) {
            super(cco);
            this.locationId = locationId;
        }

        @Override
        public void append(Item item) throws XPathException {
            if (RecordTest.VALUE_RECORD.matches(item, this.getConfiguration().getTypeHierarchy())) {
                super.append(item);
            } else {
                this.mustBeValueRecord(this.locationId);
            }
        }

        @Override
        public void append(Item item, Location locationId, int properties) throws XPathException {
            if (RecordTest.VALUE_RECORD.matches(item, this.getConfiguration().getTypeHierarchy())) {
                super.append(item, locationId, properties);
            } else {
                this.mustBeValueRecord(locationId);
            }
        }

        private void mustBeValueRecord(Location locationId) throws XPathException {
            throw new XPathException("Template rule invoked when processing an array using the shallow-copy-all rule must return a sequence of value records", "XPTY0004", locationId);
        }
    }

    private static class ShallowCopyProxyOutputterForMaps
    extends ProxyOutputter {
        private final Location locationId;

        public ShallowCopyProxyOutputterForMaps(ComplexContentOutputter cco, Location locationId) {
            super(cco);
            this.locationId = locationId;
        }

        @Override
        public void append(Item item) throws XPathException {
            if (item instanceof MapItem) {
                super.append(item);
            } else {
                this.mustBeParcel(this.locationId);
            }
        }

        @Override
        public void append(Item item, Location locationId, int properties) throws XPathException {
            if (item instanceof MapItem) {
                super.append(item, locationId, properties);
            } else {
                this.mustBeParcel(locationId);
            }
        }

        private void mustBeParcel(Location locationId) throws XPathException {
            throw new XPathException("Template rule invoked when processing a map using the shallow-copy-all rule must return a sequence of maps", "XPTY0004", locationId);
        }
    }
}

