/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Arrays;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.PushElaborator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;

public class LocalParamBlock
extends Instruction {
    Operand[] operanda;

    public LocalParamBlock(LocalParam[] params) {
        this.operanda = new Operand[params.length];
        for (int i = 0; i < params.length; ++i) {
            this.operanda[i] = new Operand(this, params[i], OperandRole.NAVIGATE);
        }
    }

    @Override
    public String getExpressionName() {
        return "params";
    }

    @Override
    public Iterable<Operand> operands() {
        return Arrays.asList(this.operanda);
    }

    public int getNumberOfParams() {
        return this.operanda.length;
    }

    @Override
    protected int computeSpecialProperties() {
        return 0;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        LocalParam[] lps2 = new LocalParam[this.getNumberOfParams()];
        int i = 0;
        for (Operand o : this.operands()) {
            LocalParam oldLps = (LocalParam)o.getChildExpression();
            LocalParam newLps = oldLps.copy(rebindings);
            rebindings.put(oldLps, newLps);
            lps2[i++] = newLps;
        }
        return new LocalParamBlock(lps2);
    }

    @Override
    public final ItemType getItemType() {
        return ErrorType.getInstance();
    }

    @Override
    public final int getCardinality() {
        return 8192;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("params", this);
        for (Operand o : this.operands()) {
            o.getChildExpression().export(out);
        }
        out.endElement();
    }

    @Override
    public int getImplementationMethod() {
        return 4;
    }

    @Override
    public Elaborator getElaborator() {
        return new LocalParamBlockElaborator();
    }

    public static class LocalParamBlockElaborator
    extends PushElaborator {
        @Override
        public PushEvaluator elaborateForPush() {
            LocalParamBlock expr = (LocalParamBlock)this.getExpression();
            SequenceEvaluator[] paramEval = new SequenceEvaluator[expr.operanda.length];
            for (int i = 0; i < expr.operanda.length; ++i) {
                paramEval[i] = expr.operanda[i].getChildExpression().makeElaborator().eagerly();
            }
            return (out, context) -> {
                for (SequenceEvaluator eagerEvaluator : paramEval) {
                    eagerEvaluator.evaluate(context);
                }
                return null;
            };
        }
    }
}

