/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.inference;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.numbers.core.DD;
import org.apache.commons.numbers.core.Precision;
import org.apache.commons.numbers.core.Sum;
import org.apache.commons.statistics.descriptive.Mean;
import org.apache.commons.statistics.inference.Arguments;
import org.apache.commons.statistics.inference.InferenceException;

final class StatisticUtils {
    private StatisticUtils() {
    }

    static double[] subtract(double[] x, double y) {
        return y == 0.0 ? x : Arrays.stream(x).map(v -> v - y).toArray();
    }

    static int computeDegreesOfFreedom(int n, int m) {
        int df = n - 1 - m;
        if (df <= 0) {
            throw new InferenceException("Invalid degrees of freedom: " + df);
        }
        return df;
    }

    static double computeRatio(double[] expected, long[] observed) {
        Arguments.checkValuesRequiredSize(expected.length, 2);
        Arguments.checkValuesSizeMatch(expected.length, observed.length);
        Arguments.checkStrictlyPositive(expected);
        Arguments.checkNonNegative(observed);
        DD e = DD.ZERO;
        DD o = DD.ZERO;
        for (int i = 0; i < observed.length; ++i) {
            e = e.add(expected[i]);
            o = StatisticUtils.add(o, observed[i]);
        }
        if (o.doubleValue() == 0.0) {
            throw new InferenceException("No data");
        }
        double ratio = o.divide(e).doubleValue();
        return Precision.equals((double)ratio, (double)1.0, (int)0) ? 1.0 : ratio;
    }

    private static DD add(DD sum, long v) {
        return v >>> 32 == 0L ? sum.add((double)v) : sum.add(DD.of((long)v));
    }

    static double mean(Collection<double[]> samples) {
        double mean = samples.stream().map(Mean::of).reduce(Mean::combine).orElseGet(Mean::create).getAsDouble();
        long n = samples.stream().mapToInt(x -> ((double[])x).length).sum();
        return mean + samples.stream().flatMapToDouble(Arrays::stream).map(v -> v - mean).sum() / (double)n;
    }

    static double meanDifference(double[] x, double[] y) {
        int n = x.length;
        if (n != y.length) {
            throw new InferenceException("Values size mismatch %s != %s", n, y.length);
        }
        Sum sum = Sum.create();
        for (int i = 0; i < n; ++i) {
            sum.add(x[i] - y[i]);
        }
        return sum.getAsDouble() / (double)n;
    }

    static double varianceDifference(double[] x, double[] y, double mean) {
        int n = x.length;
        if (n != y.length) {
            throw new InferenceException("Values size mismatch %s != %s", n, y.length);
        }
        if (n == 1) {
            return 0.0;
        }
        double s = 0.0;
        double ss = 0.0;
        for (int i = 0; i < n; ++i) {
            double dx = x[i] - y[i] - mean;
            s += dx;
            ss += dx * dx;
        }
        return (ss - s * s / (double)n) / (double)(n - 1);
    }
}

