/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.inference;

final class SquareMatrixSupport {
    private SquareMatrixSupport() {
    }

    static RealSquareMatrix create(int dimension, double[] data) {
        if (dimension * dimension != data.length) {
            throw new IllegalArgumentException(String.format("Not square: %d * %<d != %d", dimension, data.length));
        }
        return new ArrayRealSquareMatrix(dimension, data, 0);
    }

    private static class ArrayRealSquareMatrix
    implements RealSquareMatrix {
        private static final double SCALE_THRESHOLD = 2.5822498780869086E120;
        private final int dim;
        private final double[] data;
        private final int exp;

        ArrayRealSquareMatrix(int dimension, double[] data, int scale) {
            this.dim = dimension;
            this.data = data;
            this.exp = scale;
        }

        @Override
        public int dimension() {
            return this.dim;
        }

        @Override
        public int scale() {
            return this.exp;
        }

        @Override
        public double get(int i, int j) {
            return this.data[i * this.dim + j];
        }

        @Override
        public RealSquareMatrix power(int n) {
            ArrayRealSquareMatrix.checkExponent(n);
            if (n == 0) {
                return this.identity();
            }
            if (n == 1) {
                return this;
            }
            double[] col = new double[this.dim];
            double[] b = new double[this.data.length];
            double[] a = this.data;
            int ea = this.exp;
            double[] r = (double[])a.clone();
            int er = ea;
            int shift = Integer.numberOfLeadingZeros(n) + 1;
            int bits = n << shift;
            int i = 32 - shift;
            while (i != 0) {
                er = ArrayRealSquareMatrix.multiply(r, er, r, er, col, b);
                double[] tmp = b;
                b = r;
                r = tmp;
                if (bits < 0) {
                    er = ArrayRealSquareMatrix.multiply(r, er, a, ea, col, b);
                    tmp = b;
                    b = r;
                    r = tmp;
                }
                --i;
                bits <<= 1;
            }
            return new ArrayRealSquareMatrix(this.dim, r, er);
        }

        private RealSquareMatrix identity() {
            final int n = this.dimension();
            return new RealSquareMatrix(){

                @Override
                public int dimension() {
                    return n;
                }

                @Override
                public int scale() {
                    return 0;
                }

                @Override
                public double get(int i, int j) {
                    return i == j ? 1.0 : 0.0;
                }

                @Override
                public RealSquareMatrix power(int p) {
                    return this;
                }
            };
        }

        private static int multiply(double[] a, int sa, double[] b, int sb, double[] col, double[] out) {
            int i;
            int k;
            int m = col.length;
            for (int c = 0; c < m; ++c) {
                k = c;
                int i2 = 0;
                while (i2 < m) {
                    col[i2] = b[k];
                    ++i2;
                    k += m;
                }
                k = 0;
                for (int r = 0; r < m; ++r) {
                    double sum = 0.0;
                    i = 0;
                    while (i < m) {
                        sum += a[k] * col[i];
                        ++i;
                        ++k;
                    }
                    out[r * m + c] = sum;
                }
            }
            int s = sa + sb;
            k = m >> 1;
            if (out[k * m + k] > 2.5822498780869086E120) {
                int exp = Math.getExponent(out[k * m + k]);
                double downScale = Math.scalb(1.0, -exp);
                s += exp;
                i = 0;
                while (i < out.length) {
                    int n = i++;
                    out[n] = out[n] * downScale;
                }
            }
            return s;
        }

        private static void checkExponent(int p) {
            if (p < 0) {
                throw new IllegalArgumentException("Not positive exponent: " + p);
            }
        }
    }

    static interface RealSquareMatrix {
        public int dimension();

        public int scale();

        public double get(int var1, int var2);

        public RealSquareMatrix power(int var1);
    }
}

